/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.List;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMatchFactory;
import org.eclipse.vjet.eclipse.internal.codeassist.select.JstNodeDLTKElementResolver;

public class VjoTypeReferencesVisitor
implements IJstVisitor {
    private IType type;
    private List<VjoMatch> result;
    private IJstType dependentType;

    public VjoTypeReferencesVisitor(IType type, IJstType dependentType, List<VjoMatch> result) {
        this.type = type;
        this.result = result;
        this.dependentType = dependentType;
    }

    public void endVisit(IJstNode node) {
    }

    public void postVisit(IJstNode node) {
    }

    public void preVisit(IJstNode node) {
    }

    public boolean visit(IJstNode node) {
        if (node instanceof JstTypeReference) {
            this.processJstTypeReference((IJstTypeReference)((JstTypeReference)node));
        }
        if (node instanceof JstIdentifier) {
            this.processJstIdentifier((JstIdentifier)node);
        }
        if (node instanceof JstVars) {
            this.processJstTypeReference(((JstVars)node).getTypeRef());
        }
        return true;
    }

    private void processJstIdentifier(JstIdentifier identifier) {
        IType resolvedType;
        IModelElement modelElement;
        if (identifier.getSource() == null || identifier.getJstBinding() == null) {
            return;
        }
        if (!identifier.getName().equals(this.type.getElementName())) {
            return;
        }
        if (CodeassistUtils.isNativeType(this.dependentType)) {
            return;
        }
        IType sourceType = CodeassistUtils.findType(this.dependentType);
        if (sourceType == null) {
            return;
        }
        identifier.getSource().getStartOffSet();
        IModelElement[] elements = JstNodeDLTKElementResolver.lookupAndConvert((IJstNode)identifier);
        if (elements != null && elements.length > 0 && (modelElement = elements[0]) instanceof IType && (resolvedType = (IType)modelElement).getFullyQualifiedName().equals(this.type.getFullyQualifiedName())) {
            this.createMatch((IJstNode)identifier);
        }
    }

    private void processJstTypeReference(IJstTypeReference typeReference) {
        if (typeReference.getSource() == null) {
            return;
        }
        IJstType jstType = typeReference.getReferencedType();
        this.processTypeMatch(jstType, (IJstNode)typeReference);
    }

    private void processTypeMatch(IJstType opitionType, IJstNode node) {
        if (opitionType == null || opitionType.getName() == null) {
            return;
        }
        String targetTypeName = this.type.getElementName();
        boolean isTypeMatch = opitionType.getSimpleName().equals(targetTypeName);
        if (isTypeMatch) {
            this.createMatch(node);
        }
    }

    private void createMatch(IJstNode jstNode) {
        IType dltkType = CodeassistUtils.findType((ScriptProject)this.type.getScriptProject(), this.dependentType.getRootType());
        if (dltkType == null) {
            return;
        }
        JstSource jstSource = jstNode.getSource();
        VjoMatch match = VjoMatchFactory.createTypeMatch(dltkType, jstSource.getStartOffSet(), jstSource.getLength());
        this.result.add(match);
    }
}

