/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.JSSourceField;
import org.eclipse.dltk.mod.internal.core.JSSourceFieldElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceType;
import org.eclipse.dltk.mod.internal.core.ModelElementRequestor;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.codeassist.VjoCompletionEngine;
import org.eclipse.vjet.eclipse.codeassist.keywords.CompletionContext;
import org.eclipse.vjet.eclipse.codeassist.keywords.ExpressionCall;
import org.eclipse.vjet.eclipse.codeassist.keywords.FieldOrMethodCompletionHandler;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordFactory;
import org.eclipse.vjet.eclipse.core.IJSMethod;
import org.eclipse.vjet.eclipse.core.ts.ExpressionListCreator;
import org.eclipse.vjet.eclipse.internal.core.util.Util;

public class MethodCompletionHandler
extends FieldOrMethodCompletionHandler {
    private List<IType> processedTypes = new ArrayList<IType>();

    @Override
    public void complete(org.eclipse.dltk.mod.compiler.env.ISourceModule module, int position, JstCompletion completion, List<CompletionProposal> list) {
        CompletionContext.setStaticContext(completion.inScope(ScopeIds.PROPS));
        CompletionContext.setInstanceContext(false);
        IModelElement currentElement = this.getCurrentElement(module, position);
        IMethod currentMethod = this.getCurrentMethod(currentElement);
        String token = this.getToken(completion);
        IType type = this.getType(module);
        TypeMembersRequestor requestor = this.createTypeMemberRequestor(completion, token, type);
        this.requestMembers(requestor, module);
        IJstNode realParent = completion.getRealParent();
        CompletionContext.thisWithinStaticContext(realParent instanceof FieldAccessExpr && ((FieldAccessExpr)realParent).getExpr().toString().equals(VjoKeywordFactory.KWD_THIS.getName()));
        CompletionContext.setCompletedContext(this.isCompletedContext(completion));
        this.createMethodCompletions(position, list, currentMethod, requestor);
        this.createFieldCompletions(position, list, requestor);
        if (currentMethod != null) {
            this.addLocalVarProposals(currentMethod, token, list, position);
        }
        if (!token.equals("") && completion.getCompositeToken() == null) {
            this.createTypeProposals(module, position, completion, list);
        }
        this.completePackages(module, position, completion, list);
    }

    protected TypeMembersRequestor createTypeMemberRequestor(JstCompletion completion, String token, IType type) {
        return new TypeMembersRequestor(token, false, type, completion);
    }

    private void createFieldCompletions(int position, List<CompletionProposal> list, TypeMembersRequestor requestor) {
        List<IField> fields = requestor.getFields();
        for (IField field : fields) {
            int flags = 0;
            try {
                flags = field.getFlags();
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
            CompletionProposal data = this.createFieldProposal(position, field, flags);
            list.add(data);
        }
    }

    protected CompletionProposal createFieldProposal(int position, IField field, int flags) {
        String typeName = null;
        CompletionProposal data = CompletionProposal.create((int)1, (int)position);
        char[] token = field.getElementName().toCharArray();
        data.setCompletion(token);
        data.setName(field.getElementName().toCharArray());
        data.setModelElement((IModelElement)field);
        data.setFlags(flags);
        try {
            JSSourceFieldElementInfo info = (JSSourceFieldElementInfo)((JSSourceField)field).getElementInfo();
            typeName = info.getType();
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        data.extraInfo = String.valueOf(typeName) + " - " + field.getParent().getElementName();
        return data;
    }

    private void createMethodCompletions(int position, List<CompletionProposal> list, IMethod currentMethod, TypeMembersRequestor requestor) {
        List<IMethod> methods = requestor.getMethods();
        this.createMethodsProposal(position, list, currentMethod, methods);
    }

    private void createMethodsProposal(int position, List<CompletionProposal> list, IMethod currentMethod, List<IMethod> methods) {
        for (IMethod method : methods) {
            boolean isConstructor = false;
            try {
                isConstructor = method.isConstructor();
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
            if (isConstructor) continue;
            CompletionProposal data = this.createMethodProposal(position, method);
            int flags = 0;
            try {
                flags = method.getFlags();
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
            data.setFlags(flags);
            String returnType = null;
            try {
                if (method instanceof IJSMethod) {
                    returnType = ((IJSMethod)method).getReturnType();
                    data.extraInfo = String.valueOf(returnType) + " - " + method.getParent().getElementName();
                }
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
            list.add(data);
        }
    }

    protected CompletionProposal createMethodProposal(int position, IMethod method) {
        CompletionProposal data = CompletionProposal.create((int)5, (int)position);
        data.setCompletion(method.getElementName().toCharArray());
        data.setName(method.getElementName().toCharArray());
        data.setModelElement((IModelElement)method);
        this.setParameters(method, data);
        return data;
    }

    protected CompletionProposal createTypeProposal(int position, IType type, JstCompletion completion) {
        CompletionProposal data = CompletionProposal.create((int)7, (int)position);
        data.setCompletion(CodeassistUtils.getTypeCompletionToken(type));
        String name = type.getElementName();
        String packageName = CodeassistUtils.getPackageName(type);
        if (packageName != null && packageName.trim().length() > 0) {
            name = String.valueOf(name) + " - " + packageName;
        }
        data.setName(name.toCharArray());
        data.setModelElement((IModelElement)type);
        data.extraInfo = completion.getOwnerType();
        return data;
    }

    private String getToken(JstCompletion completion) {
        String token = completion.getToken();
        if (token == null) {
            token = "";
        }
        return token;
    }

    private IModelElement getCurrentElement(org.eclipse.dltk.mod.compiler.env.ISourceModule module, int position) {
        IModelElement currentElement = null;
        try {
            currentElement = ((ISourceModule)module).getElementAt(position);
        }
        catch (ModelException e1) {
            DLTKCore.error((String)e1.toString(), (Throwable)e1);
        }
        return currentElement;
    }

    private IMethod getCurrentMethod(IModelElement currentElement) {
        IMethod currentMethod = null;
        if (currentElement != null && currentElement.getElementType() == 9) {
            currentMethod = (IMethod)currentElement;
        }
        return currentMethod;
    }

    protected void addLocalVarProposals(IMethod method, String token, List<CompletionProposal> list, int position) {
        try {
            IModelElement[] children;
            IModelElement[] iModelElementArray = children = method.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                if (child.getElementType() == 8 && child.getElementName().startsWith(token)) {
                    CompletionProposal data = CompletionProposal.create((int)4, (int)position);
                    data.setCompletion(child.getElementName().toCharArray());
                    data.setName(child.getElementName().toCharArray());
                    data.setModelElement(child);
                    try {
                        if (child instanceof JSSourceField) {
                            JSSourceFieldElementInfo info = (JSSourceFieldElementInfo)((JSSourceField)child).getElementInfo();
                            String typeName = info.getType();
                            data.extraInfo = typeName;
                        }
                    }
                    catch (ModelException e) {
                        DLTKCore.error((String)e.toString(), (Throwable)e);
                    }
                    list.add(data);
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    @Override
    public Class getCompletionClass() {
        return null;
    }

    protected void requestMembers(TypeMembersRequestor requestor, org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        this.processedTypes.clear();
        IType type = this.getType(module);
        this.getMembers(requestor, type);
        type = CodeassistUtils.createNativeType(module, "Window");
        this.getMembers(requestor, type);
        type = CodeassistUtils.createNativeType(module, "Global");
        this.getMembers(requestor, type);
        type = CodeassistUtils.createNativeType(module, "Object");
        this.getMembers(requestor, type);
    }

    private void getMembers(TypeMembersRequestor requestor, IType type) {
        this.getMembers(requestor, type, true);
    }

    protected IType getType(org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        return CodeassistUtils.getType(module, null);
    }

    protected void getMembers(TypeMembersRequestor requestor, IType type, boolean processDepends) {
        if (type == null || requestor == null) {
            return;
        }
        this.processedTypes.add(type);
        try {
            IType superType;
            IJstType jstType = Util.toJstType(type);
            IMethod[] methods = type.getMethods();
            IField[] fields = type.getFields();
            Object object = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = object[n2];
                requestor.acceptMember((IMember)method);
                ++n2;
            }
            object = fields;
            n = fields.length;
            n2 = 0;
            while (n2 < n) {
                IMethod field = object[n2];
                requestor.acceptMember((IMember)field);
                ++n2;
            }
            String[] superClassNames = type.getSuperClasses();
            if (superClassNames != null && superClassNames.length > 0 && (superType = CodeassistUtils.findResourceType((org.eclipse.dltk.mod.compiler.env.ISourceModule)type.getParent(), superClassNames[0])) != null) {
                this.getDependsMembers(requestor, superType);
            }
            if (processDepends) {
                List imports = jstType.getImports();
                for (IJstType importType : imports) {
                    if (importType.getPackage() == null || importType.getPackage().getGroupName() == null || !CompletionContext.isStaticContext()) continue;
                    this.getDependsMembers(requestor, Util.toIType(importType));
                }
                List mixinTypes = jstType.getMixinsRef();
                for (IJstTypeReference mixinType : mixinTypes) {
                    this.getDependsMembers(requestor, Util.toIType(mixinType.getReferencedType()));
                }
                if (type instanceof JSSourceType) {
                    String[] interfaces;
                    String[] stringArray = interfaces = ((JSSourceType)type).getSuperInterfaceNames();
                    int n3 = interfaces.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string = stringArray[n4];
                        IType superInterface = CodeassistUtils.findResourceType((org.eclipse.dltk.mod.compiler.env.ISourceModule)type.getParent(), string);
                        if (superInterface != null) {
                            this.getDependsMembers(requestor, superInterface);
                        }
                        ++n4;
                    }
                }
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    private void getDependsMembers(TypeMembersRequestor requestor, IType type) {
        if (!this.processedTypes.contains(type)) {
            this.getMembers(requestor, type, false);
        }
    }

    protected void createTypeProposals(org.eclipse.dltk.mod.compiler.env.ISourceModule module, int position, JstCompletion completion, List<CompletionProposal> list) {
        ModelElementRequestor requestor = new ModelElementRequestor();
        CodeassistUtils.findTypes((SourceModule)module, completion.getToken(), requestor);
        if (requestor.getTypes() != null && requestor.getTypes().length > 0) {
            IType[] iTypeArray = requestor.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (!VjoCompletionEngine.UNEXIST_TYPES.contains(type.getElementName())) {
                    list.add(this.createTypeProposal(position, type, completion));
                }
                ++n2;
            }
        }
    }

    private boolean isCompletedContext(JstCompletion completion) {
        boolean isCompletedContext = false;
        IJstNode node = completion.getRealParent();
        List<IExpr> list = ExpressionListCreator.create(node);
        if (list.size() > 1) {
            isCompletedContext = list.get(1).toExprText().equals("this.vj$");
        }
        return isCompletedContext;
    }

    protected static class TypeMembersRequestor {
        private List<IMethod> methods = new ArrayList<IMethod>();
        private List<IField> fields = new ArrayList<IField>();
        private String namePrefix = "";
        private boolean isExactMatch = false;
        private IType currentType;
        private JstCompletion completion;

        public TypeMembersRequestor(String namePrefix, boolean isExactMatch, IType currentType, JstCompletion completion) {
            if (namePrefix != null) {
                this.namePrefix = namePrefix;
                this.isExactMatch = isExactMatch;
            }
            this.currentType = currentType;
            this.completion = completion;
        }

        public void acceptMember(IMember member) {
            int flags = 0;
            try {
                flags = member.getFlags();
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
            boolean accept = this.accept(member, flags);
            if (accept) {
                switch (member.getElementType()) {
                    case 9: {
                        this.methods.add((IMethod)member);
                        break;
                    }
                    case 8: {
                        this.fields.add((IField)member);
                    }
                }
            }
        }

        protected boolean accept(IMember member, int flags) {
            boolean isStatic = this.isStatic(flags);
            boolean nameMatch = this.isExactMatch ? member.getElementName().equals(this.namePrefix) : member.getElementName().startsWith(this.namePrefix);
            boolean allowUnderScore = this.allowUnderScore(member);
            boolean isInCurrentType = this.currentType.equals(member.getDeclaringType());
            boolean acceptPrivate = isInCurrentType ? true : (flags & 0x20) == 0;
            IModelElement sourceModule = member.getAncestor(5);
            boolean isNative = sourceModule instanceof NativeVjoSourceModule;
            boolean isWrongCall = !isNative && !ExpressionCall.isRightCall(this.completion, isStatic);
            boolean accept = !this.methods.contains(member) && nameMatch && acceptPrivate && !isWrongCall && allowUnderScore;
            return accept;
        }

        private boolean allowUnderScore(IMember member) {
            return !member.getElementName().startsWith("_") || CompletionContext.isVariableContext();
        }

        protected boolean isStatic(int flags) {
            return (flags & 0x100) != 0;
        }

        public List<IMethod> getMethods() {
            return this.methods;
        }

        public List<IField> getFields() {
            return this.fields;
        }

        public IType getType() {
            return this.currentType;
        }
    }
}

