/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.HashMap;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.eclipse.codeassist.keywords.CompletionContext;

public class ExpressionCall {
    private static final String DELIMITER = "-";
    private static final boolean PROPS = true;
    private static final boolean PROTOS = false;
    private static final String THIS_VJO = "THIS_VJO";
    private static final String THIS = "this";
    private static final String VAR = "var";
    private static final boolean STATIC_FIELD = true;
    private static final boolean INSTANCE_FIELD = false;
    private static HashMap<String, Boolean> table = new HashMap();

    static {
        ExpressionCall.populateTable();
    }

    public static boolean isRightCall(JstCompletion completion, boolean isStatic) {
        String context = ExpressionCall.getContext();
        boolean isPropsBlock = !completion.inScope(ScopeIds.PROTOS);
        return ExpressionCall.isRightCall(isPropsBlock, context, isStatic);
    }

    private static String getContext() {
        String staticContext = THIS;
        if (CompletionContext.isStaticContext()) {
            staticContext = THIS_VJO;
        }
        if (CompletionContext.isVariableContext()) {
            staticContext = VAR;
        }
        return staticContext;
    }

    private static void populateTable() {
        ExpressionCall.addCall(true, THIS_VJO, true, true);
        ExpressionCall.addCall(true, THIS_VJO, false, false);
        ExpressionCall.addCall(true, THIS, true, true);
        ExpressionCall.addCall(true, THIS, false, false);
        ExpressionCall.addCall(true, VAR, true, true);
        ExpressionCall.addCall(true, VAR, false, true);
        ExpressionCall.addCall(false, THIS_VJO, true, true);
        ExpressionCall.addCall(false, THIS_VJO, false, false);
        ExpressionCall.addCall(false, THIS, true, true);
        ExpressionCall.addCall(false, THIS, false, true);
        ExpressionCall.addCall(false, VAR, true, true);
        ExpressionCall.addCall(false, VAR, false, true);
    }

    private static boolean isRightCall(boolean isPropsBlock, String context, boolean isStaticMember) {
        String key = ExpressionCall.createKey(isPropsBlock, context, isStaticMember);
        Boolean isRightCall = false;
        isRightCall = table.get(key);
        if (isRightCall == null) {
            throw new InternalError("Invalid call for member context : " + key);
        }
        return isRightCall;
    }

    public static String createKey(boolean isPropsBlock, String context, boolean isStaticMember) {
        StringBuilder builder = new StringBuilder();
        builder.append(isPropsBlock);
        builder.append(DELIMITER);
        builder.append(context);
        builder.append(DELIMITER);
        builder.append(isStaticMember);
        return builder.toString();
    }

    public static void addCall(boolean isPropsBlock, String staticContext, boolean isStaticMember, boolean isRightCall) {
        String key = ExpressionCall.createKey(isPropsBlock, staticContext, isStaticMember);
        table.put(key, isRightCall);
    }
}

