/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.IRegion;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ITypeHierarchy;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.internal.core.ExternalScriptProject;
import org.eclipse.dltk.mod.internal.core.ModelOperation;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.hierarchy.VjoTypeHierarchy;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceListener;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoCreateTypeHierarchyOperation
extends ModelOperation
implements TypeSpaceListener {
    protected VjoTypeHierarchy m_typeHierarchy;

    public VjoCreateTypeHierarchyOperation(IRegion region, ISourceModule[] workingCopies, IType element, boolean computeSubtypes) {
        super((IModelElement)element);
    }

    public VjoCreateTypeHierarchyOperation(IType element, ISourceModule[] workingCopies, IDLTKSearchScope scope, boolean computeSubtypes) {
        super((IModelElement)element);
        this.m_typeHierarchy = new VjoTypeHierarchy(element);
        TypeSpaceMgr.getInstance().addTypeSpaceListener((TypeSpaceListener)this);
    }

    public VjoCreateTypeHierarchyOperation(IType element, ISourceModule[] workingCopies, IScriptProject project, boolean computeSubtypes) {
        super((IModelElement)element);
        this.m_typeHierarchy = new VjoTypeHierarchy(element);
        TypeSpaceMgr.getInstance().addTypeSpaceListener((TypeSpaceListener)this);
    }

    protected void executeOperation() throws ModelException {
        this.m_typeHierarchy.refresh((IProgressMonitor)this);
    }

    public ITypeHierarchy getResult() {
        return this.m_typeHierarchy;
    }

    public boolean isReadOnly() {
        return true;
    }

    public IModelStatus verify() {
        IModelElement elementToProcess = this.getElementToProcess();
        if (elementToProcess != null && !elementToProcess.exists()) {
            return new ModelStatus(969, elementToProcess);
        }
        IScriptProject project = this.m_typeHierarchy.javaProject();
        if (project != null && (project.getElementName().equals("Native project") || project instanceof ExternalScriptProject)) {
            return IModelStatus.VERIFIED_OK;
        }
        if (project != null && !project.exists()) {
            return new ModelStatus(969, (IModelElement)project);
        }
        return IModelStatus.VERIFIED_OK;
    }

    public void loadTypesFinished() {
        this.m_typeHierarchy.fireChanged();
    }

    public void refreshFinished(List<SourceTypeName> list) {
        this.m_typeHierarchy.fireChanged();
    }

    private class VjoTypeSpaceListener
    implements TypeSpaceListener {
        private IType type;

        private VjoTypeSpaceListener(IType type) {
            this.type = type;
        }

        public void loadTypesFinished() {
        }

        public void refreshFinished(List<SourceTypeName> list) {
        }
    }
}

