/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.mod.compiler.problem.DefaultProblem;
import org.eclipse.dltk.mod.compiler.problem.IProblem;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.compiler.problem.ProblemCollector;
import org.eclipse.dltk.mod.core.DLTKContentTypeManager;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceModuleInfoCache;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.SourceParserUtil;
import org.eclipse.dltk.mod.core.builder.IBuildContext;
import org.eclipse.dltk.mod.core.builder.IScriptBuilder;
import org.eclipse.dltk.mod.core.builder.IScriptBuilderExtension;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.internal.core.BuildpathEntry;
import org.eclipse.dltk.mod.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.mod.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.mod.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.mod.internal.core.ExternalSourceModule;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.VjoSourceHelper;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.core.builder.BuildProblemReporter;
import org.eclipse.dltk.mod.internal.core.builder.ScriptBuilder;
import org.eclipse.dltk.mod.internal.core.builder.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.VjoLanguageToolkit;
import org.eclipse.vjet.eclipse.core.builder.Messages;
import org.eclipse.vjet.eclipse.core.builder.ScriptBuilderManager;
import org.eclipse.vjet.eclipse.core.builder.TypeSpaceBuilder;
import org.eclipse.vjet.eclipse.core.builder.VjetSourceModuleBuildCtx;
import org.eclipse.vjet.eclipse.core.parser.VjoParserToJstAndIType;
import org.eclipse.vjet.eclipse.core.ts.EclipseTypeSpaceLoader;
import org.eclipse.vjet.eclipse.core.validation.ValidationEntry;
import org.eclipse.vjet.eclipse.core.validation.utils.ProblemUtility;
import org.eclipse.vjet.eclipse.internal.parser.VjoSourceParser;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjetScriptBuilder
extends ScriptBuilder {
    public static final boolean DEBUG = VjetPlugin.DEBUG_SCRIPT_BUILDER;
    public static final boolean TRACE = VjetPlugin.TRACE_SCRIPT_BUILDER;
    public IProject currentProject = null;
    ScriptProject scriptProject = null;
    State lastState;
    public long lastBuildResources = 0L;
    public long lastBuildSourceFiles = 0L;
    private TypeSpaceBuilder typeSpaceBuilder = new TypeSpaceBuilder();
    private static final QualifiedName PROPERTY_BUILDER_VERSION = new QualifiedName("org.eclipse.dltk.mod.core", "builderVersion");
    private static final String CURRENT_VERSION = "200810012003-2123";
    private static final int WORK_RESOURCES = 50;
    private static final int WORK_EXTERNAL = 100;
    private static final int WORK_SOURCES = 100;
    private static final int WORK_BUILD = 750;
    private static final String NONAME = "";

    public static void buildStarting() {
        if (VjetPlugin.DEBUG) {
            System.out.println("vjet build starting");
        }
    }

    public static void buildFinished() {
        if (VjetPlugin.DEBUG) {
            System.out.println("vjet build finished");
        }
    }

    private static void log(String message) {
        System.out.println(message);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return new IProject[0];
        }
        if (!DLTKLanguageManager.hasScriptNature((IProject)this.currentProject)) {
            return null;
        }
        long startTime = 0L;
        if (DEBUG || TRACE) {
            startTime = System.currentTimeMillis();
            VjetScriptBuilder.log("\nStarting build of " + this.currentProject.getName() + " @ " + new Date(startTime));
        }
        this.scriptProject = (ScriptProject)DLTKCore.create((IProject)this.currentProject);
        String version = this.currentProject.getPersistentProperty(PROPERTY_BUILDER_VERSION);
        if (version == null) {
            this.removeWrongTaskMarkers();
            this.currentProject.setPersistentProperty(PROPERTY_BUILDER_VERSION, CURRENT_VERSION);
            kind = 6;
        } else if (!CURRENT_VERSION.equals(version)) {
            if ("200810012003".equals(version)) {
                this.removeWrongTaskMarkers();
            }
            this.currentProject.setPersistentProperty(PROPERTY_BUILDER_VERSION, CURRENT_VERSION);
            kind = 6;
        }
        this.lastBuildResources = 0L;
        this.lastBuildSourceFiles = 0L;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (kind == 6) {
            if (DEBUG) {
                VjetScriptBuilder.log("Performing full build as requested by user");
            }
            this.fullBuild(monitor);
        } else {
            this.lastState = this.getLastState(this.currentProject, monitor);
            if (this.lastState == null) {
                if (DEBUG) {
                    VjetScriptBuilder.log("Performing full build since last saved state was not found");
                }
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    if (DEBUG) {
                        VjetScriptBuilder.log("Performing full build since deltas are missing after incremental request");
                    }
                    this.fullBuild(monitor);
                } else if (VjoParserToJstAndIType.getJstParseController().getJstTypeSpaceMgr().getTypeSpace().getGroup(this.currentProject.getName()) == null) {
                    if (DEBUG) {
                        VjetScriptBuilder.log("Performing full build since group was not found in typespace");
                    }
                    this.fullBuild(monitor);
                } else if (EclipseTypeSpaceLoader.isBildPathChangedEvent(delta)) {
                    if (DEBUG) {
                        VjetScriptBuilder.log("Performing full build since build path changed");
                    }
                    this.fullBuild(monitor);
                } else if (EclipseTypeSpaceLoader.isBootstrapChangedEvent(delta)) {
                    if (DEBUG) {
                        VjetScriptBuilder.log("Performing full build since bootstrap.js changed");
                    }
                    this.fullBuild(monitor);
                } else {
                    if (DEBUG) {
                        VjetScriptBuilder.log("Performing incremental build");
                    }
                    try {
                        this.incrementalBuild(delta, monitor);
                    }
                    catch (ModelException exception) {
                        DLTKCore.error((String)exception.getMessage());
                    }
                }
            }
        }
        IProject[] requiredProjects = this.getRequiredProjects(true);
        long endTime = 0L;
        if (DEBUG || TRACE) {
            endTime = System.currentTimeMillis();
        }
        if (DEBUG) {
            VjetScriptBuilder.log("Finished build of " + this.currentProject.getName() + " @ " + new Date(endTime) + ", elapsed " + (endTime - startTime) + " ms");
        }
        if (TRACE) {
            System.out.println("-----SCRIPT-BUILDER-INFORMATION-TRACE----------------------------");
            System.out.println("Finished build of project:" + this.currentProject.getName() + "\n" + "Building time:" + Long.toString(endTime - startTime) + "\n" + "Resources count:" + this.lastBuildResources + "\n" + "Sources count:" + this.lastBuildSourceFiles + "\n" + "Build type:" + (kind == 6 ? "Full build" : "Incremental build"));
            System.out.println("-----------------------------------------------------------------");
        }
        monitor.done();
        return requiredProjects;
    }

    private void removeWrongTaskMarkers() throws CoreException {
        IMarker[] markers = this.currentProject.findMarkers("org.eclipse.core.resources.taskmarker", false, 2);
        int i = 0;
        while (i < markers.length) {
            Map attributes;
            IMarker marker = markers[i];
            IResource resource = marker.getResource();
            if (resource.getType() == 1 && DLTKContentTypeManager.isValidResourceForContentType((IDLTKLanguageToolkit)this.scriptProject.getLanguageToolkit(), (IResource)resource) && (attributes = marker.getAttributes()) != null && Boolean.FALSE.equals(attributes.get("userEditable")) && attributes.containsKey("lineNumber") && attributes.containsKey("message") && attributes.containsKey("priority") && attributes.containsKey("charStart") && attributes.containsKey("charEnd")) {
                marker.delete();
            }
            ++i;
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        long start = 0L;
        if (TRACE) {
            start = System.currentTimeMillis();
        }
        this.currentProject = this.getProject();
        if (!DLTKLanguageManager.hasScriptNature((IProject)this.currentProject)) {
            return;
        }
        this.scriptProject = (ScriptProject)DLTKCore.create((IProject)this.currentProject);
        monitor.beginTask(MessageFormat.format("Cleaning typespace for project {0}", this.currentProject.getName()), 66);
        if (monitor.isCanceled()) {
            return;
        }
        TypeSpaceMgr.getInstance().cleanGroup(this.scriptProject.getElementName());
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return;
        }
        monitor.beginTask(MessageFormat.format(Messages.ScriptBuilder_cleaningScriptsIn, this.currentProject.getName()), 66);
        if (monitor.isCanceled()) {
            return;
        }
        IScriptBuilder[] builders = this.getScriptBuilders();
        if (builders != null) {
            int k = 0;
            while (k < builders.length) {
                SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
                builders[k].clean((IScriptProject)this.scriptProject, (IProgressMonitor)sub);
                if (monitor.isCanceled()) break;
                ++k;
            }
            this.resetBuilders(builders);
        }
        if (TRACE) {
            System.out.println("-----SCRIPT-BUILDER-INFORMATION-TRACE----------------------------");
            System.out.println("Finished clean of project:" + this.currentProject.getName() + "\n" + "Building time:" + Long.toString(System.currentTimeMillis() - start));
            System.out.println("-----------------------------------------------------------------");
        }
        monitor.done();
    }

    private IProject[] getRequiredProjects(boolean includeBinaryPrerequisites) {
        if (this.scriptProject == null) {
            return new IProject[0];
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            IBuildpathEntry[] entries = this.scriptProject.getExpandedBuildpath(true);
            int i = 0;
            int l = entries.length;
            while (i < l) {
                IBuildpathEntry entry = entries[i];
                IPath path = entry.getPath();
                IProject p = null;
                switch (entry.getEntryKind()) {
                    case 2: {
                        p = workspaceRoot.getProject(path.lastSegment());
                        if (!((BuildpathEntry)entry).isOptional() || ScriptProject.hasScriptNature((IProject)p)) break;
                        p = null;
                        break;
                    }
                    case 1: {
                        IResource resource;
                        if (!includeBinaryPrerequisites || path.segmentCount() <= 1 || !((resource = workspaceRoot.findMember(path.segment(0))) instanceof IProject)) break;
                        p = (IProject)resource;
                    }
                }
                if (p != null && !projects.contains(p)) {
                    projects.add(p);
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return new IProject[0];
        }
        IProject[] result = new IProject[projects.size()];
        projects.toArray(result);
        return result;
    }

    public State getLastState(IProject project, IProgressMonitor monitor) {
        return (State)ModelManager.getModelManager().getLastBuiltState(project, monitor);
    }

    private State clearLastState() {
        State state = new State((ScriptBuilder)this);
        State prevState = (State)ModelManager.getModelManager().getLastBuiltState(this.currentProject, null);
        if (prevState != null && prevState.noCleanExternalFolders) {
            state.externalFolderLocations = prevState.externalFolderLocations;
            return state;
        }
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, null);
        return state;
    }

    protected void fullBuild(IProgressMonitor monitor) {
        int resourceTicks;
        ArrayList localResources;
        Set externalElements;
        Set resources;
        IScriptBuilder[] builders;
        block15: {
            ArrayList localElements;
            int totalFiles;
            HashSet externalFolders;
            block14: {
                block13: {
                    block12: {
                        State newState;
                        this.lastState = newState = this.clearLastState();
                        builders = null;
                        monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
                        ArrayList<String> groupDepends = new ArrayList<String>();
                        IBuildpathEntry bootstrapPath = TypeSpaceBuilder.getBootstrapDir((IScriptProject)this.scriptProject);
                        this.typeSpaceBuilder.buildProject(this.scriptProject, null, monitor, groupDepends, bootstrapPath);
                        monitor.beginTask(NONAME, 1000);
                        resources = this.getResourcesFrom((Object)this.currentProject, (IProgressMonitor)monitor, (int)50).resources;
                        if (!monitor.isCanceled()) break block12;
                        this.resetBuilders(builders);
                        monitor.done();
                        ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                        return;
                    }
                    externalElements = this.getExternalElementsFrom(this.scriptProject, monitor, 100, true);
                    externalFolders = new HashSet(this.lastState.externalFolderLocations);
                    if (!monitor.isCanceled()) break block13;
                    this.resetBuilders(builders);
                    monitor.done();
                    ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                    return;
                }
                totalFiles = resources.size() + externalElements.size();
                if (totalFiles == 0) {
                    totalFiles = 1;
                }
                builders = this.getScriptBuilders();
                localResources = new ArrayList();
                localElements = new ArrayList();
                this.locateSourceModules(monitor, 100, resources, localElements, localResources);
                if (!monitor.isCanceled()) break block14;
                this.resetBuilders(builders);
                monitor.done();
                ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                return;
            }
            resourceTicks = 750 * (resources.size() - localElements.size()) / totalFiles;
            resourceTicks = Math.min(resourceTicks, 187);
            try {
                this.clearMarkers(localElements);
                this.buildElements(localElements, externalElements, monitor, 750 - resourceTicks, 1, Collections.EMPTY_SET, externalFolders, builders);
                this.lastBuildSourceFiles += (long)externalElements.size();
            }
            catch (CoreException e) {
                DLTKCore.error((String)Messages.ScriptBuilder_errorBuildElements, (Throwable)e);
            }
            if (!monitor.isCanceled()) break block15;
            this.resetBuilders(builders);
            monitor.done();
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
            return;
        }
        try {
            try {
                this.buildResources(localResources, monitor, resourceTicks, 6, builders);
                this.lastBuildResources = resources.size() + externalElements.size();
            }
            catch (CoreException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                this.resetBuilders(builders);
                monitor.done();
                ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
            }
        }
        catch (Throwable throwable) {
            this.resetBuilders(builders);
            monitor.done();
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
            throw throwable;
        }
        this.resetBuilders(builders);
        monitor.done();
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
    }

    private void clearMarkers(List localElements) throws CoreException {
        for (Object o : localElements) {
            IResource resource;
            if (!(o instanceof IModelElement) || (resource = ((IModelElement)o).getResource()) == null) continue;
            resource.deleteMarkers("org.eclipse.dltk.mod.core.problem", true, 2);
            resource.deleteMarkers("org.eclipse.dltk.mod.core.task", true, 2);
        }
    }

    private void resetBuilders(IScriptBuilder[] builders) {
        if (builders != null) {
            int k = 0;
            while (k < builders.length) {
                builders[k].reset((IScriptProject)this.scriptProject);
                ++k;
            }
        }
    }

    private ResourceVisitor getResourcesFrom(Object el, IProgressMonitor monitor, int ticks) throws CoreException {
        monitor.subTask(Messages.ScriptBuilder_scanningProject);
        try {
            ResourceVisitor resourceVisitor = new ResourceVisitor(monitor);
            if (el instanceof IProject) {
                IProject prj = (IProject)el;
                prj.accept((IResourceVisitor)resourceVisitor);
            } else if (el instanceof IResourceDelta) {
                IResourceDelta delta = (IResourceDelta)el;
                delta.accept((IResourceDeltaVisitor)resourceVisitor);
            }
            ResourceVisitor resourceVisitor2 = resourceVisitor;
            return resourceVisitor2;
        }
        finally {
            monitor.worked(ticks);
        }
    }

    private Set getExternalElementsFrom(ScriptProject prj, IProgressMonitor monitor, int tiks, boolean updateState) throws ModelException {
        String name = Messages.ScriptBuilder_scanningExternalFolders;
        monitor.subTask(name);
        SubProgressMonitor mon = new SubProgressMonitor(monitor, tiks);
        IProjectFragment[] fragments = prj.getAllProjectFragments();
        ArrayList<IProjectFragment> extFragments = new ArrayList<IProjectFragment>(fragments.length);
        ArrayList<IPath> fragmentPaths = new ArrayList<IPath>(fragments.length);
        int i = 0;
        while (i < fragments.length) {
            IProjectFragment fragment = fragments[i];
            if (fragment instanceof ExternalProjectFragment || fragment instanceof BuiltinProjectFragment) {
                IPath path = fragment.getPath();
                if (!updateState || !this.lastState.externalFolderLocations.contains(path)) {
                    extFragments.add(fragment);
                } else {
                    fragmentPaths.add(path);
                }
            }
            ++i;
        }
        ExternalModuleVisitor visitor = new ExternalModuleVisitor((IProgressMonitor)mon);
        mon.beginTask(name, extFragments.size());
        for (IProjectFragment fragment : extFragments) {
            fragment.accept((IModelElementVisitor)visitor);
            if (updateState) {
                fragmentPaths.add(fragment.getPath());
            }
            mon.worked(1);
        }
        mon.done();
        if (updateState) {
            this.lastState.externalFolderLocations.clear();
            this.lastState.externalFolderLocations.addAll(fragmentPaths);
        }
        return visitor.elements;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        int resourceTicks;
        ArrayList localResources;
        Set externalElements;
        Set resources;
        IScriptBuilder[] builders;
        block16: {
            ResourceVisitor resourcesFrom;
            block15: {
                ArrayList localElements;
                int totalFiles;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                State newState = new State((ScriptBuilder)this);
                                HashSet externalFoldersBefore = new HashSet();
                                if (this.lastState != null) {
                                    newState.copyFrom(this.lastState);
                                    externalFoldersBefore.addAll(newState.getExternalFolders());
                                }
                                this.lastState = newState;
                                builders = null;
                                try {
                                    monitor.setTaskName(NLS.bind((String)Messages.ScriptBuilder_buildingScriptsIn, (Object)this.currentProject.getName()));
                                    monitor.beginTask(NONAME, 1000);
                                    if (!monitor.isCanceled()) break block11;
                                    this.resetBuilders(builders);
                                }
                                catch (Throwable throwable) {
                                    this.resetBuilders(builders);
                                    monitor.done();
                                    ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                                    throw throwable;
                                }
                                monitor.done();
                                ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                                return;
                            }
                            resourcesFrom = this.getResourcesFrom(delta, monitor, 50);
                            resources = resourcesFrom.resources;
                            if (!monitor.isCanceled()) break block12;
                            this.resetBuilders(builders);
                            monitor.done();
                            ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                            return;
                        }
                        if (DEBUG) {
                            VjetScriptBuilder.log("Number of changed resources in delta: " + resources.size());
                        }
                        externalElements = this.getExternalElementsFrom(this.scriptProject, monitor, 100, true);
                        new HashSet(this.lastState.externalFolderLocations);
                        if (!monitor.isCanceled()) break block13;
                        this.resetBuilders(builders);
                        monitor.done();
                        ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                        return;
                    }
                    totalFiles = resources.size() + externalElements.size();
                    if (totalFiles == 0) {
                        totalFiles = 1;
                    }
                    builders = this.getScriptBuilders();
                    localResources = new ArrayList();
                    localElements = new ArrayList();
                    this.locateSourceModules(monitor, 100, resources, localElements, localResources);
                    if (!monitor.isCanceled()) break block14;
                    this.resetBuilders(builders);
                    monitor.done();
                    ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                    return;
                }
                resourceTicks = 750 * (resources.size() - localElements.size()) / totalFiles;
                if (!monitor.isCanceled()) break block15;
                this.resetBuilders(builders);
                monitor.done();
                ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
                return;
            }
            this.typeSpaceBuilder.incrementalBuildProject(resourcesFrom.changedTypes);
            this.lastBuildSourceFiles += (long)externalElements.size();
            if (!monitor.isCanceled()) break block16;
            this.resetBuilders(builders);
            monitor.done();
            ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
            return;
        }
        this.buildResources(localResources, monitor, resourceTicks, 6, builders);
        this.lastBuildResources = resources.size() + externalElements.size();
        this.resetBuilders(builders);
        monitor.done();
        ModelManager.getModelManager().setLastBuiltState(this.currentProject, (Object)this.lastState);
    }

    private IScriptBuilder[] getScriptBuilders() throws CoreException {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.scriptProject);
        if (toolkit != null) {
            IScriptBuilder[] builders = ScriptBuilderManager.getScriptBuilders(toolkit.getNatureId());
            if (builders != null) {
                int k = 0;
                while (k < builders.length) {
                    builders[k].initialize((IScriptProject)this.scriptProject);
                    ++k;
                }
            }
            return builders;
        }
        return null;
    }

    protected void locateSourceModules(IProgressMonitor monitor, int tiks, Set resources, List realElements, List realResources) {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, tiks / 3);
        sub.beginTask(NONAME, resources.size());
        int remainingWork = resources.size();
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            IResource res = (IResource)iterator.next();
            sub.subTask(NLS.bind((String)Messages.ScriptBuilder_Locating_source_modules, (Object)String.valueOf(remainingWork), (Object)res.getName()));
            sub.worked(1);
            if (sub.isCanceled()) {
                return;
            }
            IModelElement element = DLTKCore.create((IResource)res);
            if (element != null && element.getElementType() == 5 && element.exists()) {
                realElements.add(element);
            } else {
                realResources.add(res);
            }
            --remainingWork;
        }
        sub.done();
        this.lastBuildSourceFiles += (long)realElements.size();
    }

    protected void buildResources(List realResources, IProgressMonitor monitor, int tiks, int buildType, IScriptBuilder[] builders) {
        if (builders == null || builders.length == 0 || realResources.isEmpty()) {
            monitor.worked(tiks);
            return;
        }
        SubProgressMonitor ssub = new SubProgressMonitor(monitor, tiks);
        try {
            ssub.beginTask(Messages.ScriptBuilder_building, builders.length);
            int k = 0;
            while (k < builders.length) {
                builders[k].buildResources((IScriptProject)this.scriptProject, realResources, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)ssub, 1), buildType);
                ++k;
            }
        }
        finally {
            ssub.done();
        }
    }

    protected void buildElements(List localElements, Set externalElements, IProgressMonitor monitor, int ticks, int buildType, Set externalFoldersBefore, Set externalFolders, IScriptBuilder[] builders) throws CoreException {
        if (builders == null) {
            return;
        }
        int[] workEstimations = new int[builders.length];
        List[] builderToElements = new List[builders.length];
        List[] builderExternalElements = new List[builders.length];
        int[] buildTypes = new int[builders.length];
        Arrays.fill(buildTypes, buildType);
        this.estimateBuild(localElements, externalElements, externalFoldersBefore, externalFolders, builders, workEstimations, builderToElements, builderExternalElements, buildTypes);
        int total = 0;
        int k = 0;
        while (k < builders.length) {
            total += workEstimations[k];
            ++k;
        }
        k = 0;
        while (k < builders.length) {
            List buildElementsList;
            if (monitor.isCanceled()) {
                return;
            }
            IScriptBuilder builder = builders[k];
            int builderWork = workEstimations[k] * ticks / total;
            List buildExternalElements = builderExternalElements[k];
            if (buildExternalElements != null && buildExternalElements.size() > 0 && builder instanceof IScriptBuilderExtension) {
                int step = buildExternalElements.size() * ticks / total;
                builderWork -= step;
                monitor.subTask(NLS.bind((String)Messages.ScriptBuilder_building_N_externalModules, (Object)Integer.toString(buildExternalElements.size())));
                ((IScriptBuilderExtension)builder).buildExternalElements(this.scriptProject, buildExternalElements, (IProgressMonitor)new SubProgressMonitor(monitor, step), buildTypes[k]);
            }
            if ((buildElementsList = builderToElements[k]).size() > 0) {
                int step = buildElementsList.size() * ticks / total;
                builderWork -= step;
                monitor.subTask(NLS.bind((String)Messages.ScriptBuilder_building_N_localModules, (Object)Integer.toString(buildElementsList.size())));
                ArrayList<VjetSourceModuleBuildCtx> postBuildCtx = new ArrayList<VjetSourceModuleBuildCtx>(buildElementsList.size());
                for (ISourceModule module : buildElementsList) {
                    VjetSourceModuleBuildCtx context = new VjetSourceModuleBuildCtx(module);
                    this.build(context);
                    postBuildCtx.add(context);
                }
                for (VjetSourceModuleBuildCtx module : postBuildCtx) {
                    IProblemReporter reporter = module.getProblemReporter();
                    boolean validatable = reporter != null;
                    IJstType unit = module.getUnit();
                    TypeSpaceMgr.getInstance().getController().resolve(module.getVjoSourceModule().getGroupName(), unit);
                    if (unit == null || !ValidationEntry.isEnableVjetValidation()) continue;
                    List<DefaultProblem> dproblems = null;
                    List problems = unit.getProblems();
                    if (problems != null && !problems.isEmpty() && validatable) {
                        dproblems = ProblemUtility.reportProblems(problems);
                    } else if (validatable) {
                        dproblems = ValidationEntry.validator(unit);
                    }
                    if (dproblems != null && reporter != null) {
                        this.reportProblems(dproblems, reporter);
                    }
                    module.setUnit(null);
                    ((BuildProblemReporter)reporter).flush();
                }
                postBuildCtx = null;
            }
            if (builderWork > 0) {
                monitor.worked(builderWork);
            }
            ++k;
        }
    }

    private void reportProblems(List<DefaultProblem> problems, IProblemReporter reporter) {
        if (problems == null) {
            return;
        }
        for (IProblem iProblem : problems) {
            reporter.reportProblem(iProblem);
        }
    }

    public void build(VjetSourceModuleBuildCtx context) throws CoreException {
        VjoSourceParser parser = new VjoSourceParser();
        ModuleDeclaration moduleDeclaration = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
        if (moduleDeclaration != null) {
            return;
        }
        ISourceModuleInfoCache.ISourceModuleInfo cacheEntry = ModelManager.getModelManager().getSourceModuleInfoCache().get(context.getSourceModule());
        moduleDeclaration = SourceParserUtil.getModuleFromCache((ISourceModuleInfoCache.ISourceModuleInfo)cacheEntry, (int)0, (IProblemReporter)context.getProblemReporter());
        if (moduleDeclaration != null) {
            context.set(IBuildContext.ATTR_MODULE_DECLARATION, moduleDeclaration);
        }
        ProblemCollector problemCollector = new ProblemCollector();
        moduleDeclaration = parser.parse(context.getSourceModule().getPath().toString().toCharArray(), context.getContents(), context.getProblemReporter(), context);
        SourceParserUtil.putModuleToCache((ISourceModuleInfoCache.ISourceModuleInfo)cacheEntry, (ModuleDeclaration)moduleDeclaration, (int)0, (ProblemCollector)problemCollector);
        problemCollector.copyTo(context.getProblemReporter());
    }

    private void estimateBuild(List localElements, Set externalElements, Set externalFoldersBefore, Set externalFolders, IScriptBuilder[] builders, int[] workEstimations, List[] builderToElements, List[] builderExternalElements, int[] buildTypes) throws CoreException {
        HashSet elementsAsSet = new HashSet(localElements);
        List projectElements = null;
        ArrayList projectExternalElements = null;
        int k = 0;
        while (k < builders.length) {
            ArrayList buildExternalElements;
            ArrayList buildElementsList;
            IScriptBuilder builder = builders[k];
            IScriptBuilder.DependencyResponse response = builder.getDependencies((IScriptProject)this.scriptProject, buildTypes[k], elementsAsSet, externalElements, externalFoldersBefore, externalFolders);
            if (response == null) {
                buildElementsList = localElements;
                buildExternalElements = null;
            } else {
                HashSet e;
                Set dependencies;
                if (response.isFullLocalBuild()) {
                    if (buildTypes[k] == 1) {
                        buildElementsList = localElements;
                    } else {
                        if (projectElements == null) {
                            projectElements = this.collectLocalElements();
                        }
                        buildElementsList = projectElements;
                    }
                } else {
                    dependencies = response.getLocalDependencies();
                    if (dependencies != null && !dependencies.isEmpty() && !elementsAsSet.containsAll(dependencies)) {
                        e = new HashSet(elementsAsSet.size() + dependencies.size());
                        e.addAll(elementsAsSet);
                        e.addAll(dependencies);
                        buildElementsList = new ArrayList(e);
                    } else {
                        buildElementsList = localElements;
                    }
                }
                if (response.isFullExternalBuild()) {
                    if (buildTypes[k] == 1) {
                        buildExternalElements = new ArrayList(externalElements);
                    } else {
                        if (projectExternalElements == null) {
                            projectExternalElements = new ArrayList(this.getExternalElementsFrom(this.scriptProject, (IProgressMonitor)new NullProgressMonitor(), 1, false));
                        }
                        buildExternalElements = projectExternalElements;
                    }
                } else {
                    dependencies = response.getExternalDependencies();
                    if (dependencies != null && !dependencies.isEmpty() && !externalElements.containsAll(dependencies)) {
                        e = new HashSet(externalElements.size() + dependencies.size());
                        e.addAll(externalElements);
                        e.addAll(dependencies);
                        buildExternalElements = new ArrayList(e);
                    } else {
                        buildExternalElements = null;
                    }
                }
                if (response.isFullLocalBuild() || response.isFullExternalBuild()) {
                    buildTypes[k] = 1;
                }
            }
            builderToElements[k] = buildElementsList;
            builderExternalElements[k] = buildExternalElements;
            int work = buildElementsList.size();
            if (buildExternalElements != null) {
                work += buildExternalElements.size();
            }
            workEstimations[k] = Math.max(work, 1);
            ++k;
        }
    }

    private List collectLocalElements() throws CoreException {
        NullProgressMonitor nullMon = new NullProgressMonitor();
        Set resources = this.getResourcesFrom((Object)this.currentProject, (IProgressMonitor)nullMon, (int)1).resources;
        ArrayList elements = new ArrayList();
        this.locateSourceModules((IProgressMonitor)nullMon, 1, resources, elements, new ArrayList());
        return elements;
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.dltk.mod.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.dltk.mod.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void writeState(Object state, DataOutputStream out) throws IOException {
        ((State)state).write(out);
    }

    public static State readState(IProject project, DataInputStream in) throws IOException {
        State state = State.read((IProject)project, (DataInputStream)in);
        return state;
    }

    static class ExternalModuleVisitor
    implements IModelElementVisitor {
        final Set elements = new HashSet();
        private final IProgressMonitor monitor;

        public ExternalModuleVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IModelElement element) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (element.getElementType() == 3) {
                if (!(element instanceof ExternalProjectFragment) && !(element instanceof BuiltinProjectFragment)) {
                    return false;
                }
                IProjectFragment fragment = (IProjectFragment)element;
                String localPath = EnvironmentPathUtils.getLocalPath((IPath)fragment.getPath()).toString();
                if (!localPath.startsWith("#")) {
                    this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningExternalFolder) + localPath);
                }
            } else {
                IScriptFolder folder;
                String localPath;
                if (element.getElementType() == 5) {
                    if (element instanceof ExternalSourceModule || element instanceof BuiltinSourceModule) {
                        this.elements.add(element);
                    }
                    return false;
                }
                if (element.getElementType() == 4 && !(localPath = EnvironmentPathUtils.getLocalPath((IPath)(folder = (IScriptFolder)element).getPath()).toString()).startsWith("#")) {
                    this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningExternalFolder) + localPath);
                }
            }
            return true;
        }
    }

    class ResourceVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        final Set resources = new HashSet();
        List<SourceTypeName> changedTypes = new ArrayList<SourceTypeName>();
        private final IProgressMonitor monitor;

        public ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource.getType() == 2) {
                this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningProjectFolder) + resource.getProjectRelativePath().toString());
            }
            if (resource.getType() == 1) {
                SourceTypeName name;
                IFile file = (IFile)resource;
                ISourceModule module = VjoSourceHelper.getModuleFromResource((IResource)file, VjetScriptBuilder.this.scriptProject);
                TypeSpaceMgr tsmgr = TypeSpaceMgr.getInstance();
                String typeName = CodeassistUtils.getClassName(file);
                if (module instanceof VjoSourceModule) {
                    VjoSourceModule vjoSourceModule = (VjoSourceModule)module;
                    IType iType = vjoSourceModule.getTypes()[0];
                    String pkg = vjoSourceModule.getPackageDeclarations()[0].getElementName();
                    if (!pkg.equals(VjetScriptBuilder.NONAME)) {
                        pkg = String.valueOf(pkg) + ".";
                    }
                    typeName = String.valueOf(pkg) + iType.getElementName();
                    name = new SourceTypeName(VjetScriptBuilder.this.scriptProject.getElementName(), typeName);
                    name.setSource(new String(this.getFileContent(file)));
                } else {
                    name = file.exists() ? this.createSourceTypeName(file) : this.createSourceTypeName(file, SourceTypeName.EMPTY_CONTENT);
                }
                switch (delta.getKind()) {
                    case 1: {
                        if (!tsmgr.existType(file.getProject().getName(), typeName)) {
                            name.setAction(1);
                            this.changedTypes.add(name);
                            if (file.exists()) {
                                tsmgr.getController().parseAndResolve(name.groupName(), file.getLocation().toFile());
                            }
                        }
                        this.resources.add(resource);
                        break;
                    }
                    case 4: {
                        if (tsmgr.existType(file.getProject().getName(), typeName)) {
                            name.setAction(4);
                            this.changedTypes.add(name);
                        }
                        this.resources.add(resource);
                        break;
                    }
                    case 2: {
                        if (!tsmgr.existType(file.getProject().getName(), typeName)) break;
                        name.setAction(2);
                        this.changedTypes.add(name);
                    }
                }
            }
            return true;
        }

        private SourceTypeName createSourceTypeName(IFile file) {
            byte[] content = SourceTypeName.EMPTY_CONTENT;
            content = this.getFileContent(file);
            return this.createSourceTypeName(file, content);
        }

        private byte[] doGetFileContent(IFile file) throws CoreException, IOException {
            InputStream stream = file.getContents();
            int available = stream.available();
            byte[] bs = new byte[available];
            stream.read(bs);
            stream.close();
            return bs;
        }

        private SourceTypeName createSourceTypeName(IFile file, byte[] bs) {
            String group = file.getProject().getName();
            String source = new String(bs);
            String name = CodeassistUtils.getClassName(file);
            SourceTypeName typeName = new SourceTypeName(group, name, source);
            return typeName;
        }

        private void logError(Exception e1) {
            VjetPlugin.error(e1.getMessage(), e1);
        }

        private void refresh(IFile file) {
            try {
                file.refreshLocal(2, null);
            }
            catch (CoreException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }

        private byte[] getFileContent(IFile file) {
            byte[] bs = SourceTypeName.EMPTY_CONTENT;
            try {
                bs = this.doGetFileContent(file);
            }
            catch (IOException e) {
                this.logError(e);
            }
            catch (ResourceException resourceException) {
                this.refresh(file);
                try {
                    bs = this.doGetFileContent(file);
                }
                catch (Exception e1) {
                    this.logError(e1);
                }
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
            }
            return bs;
        }

        private boolean isValidName(IFile file) {
            boolean isValid = false;
            try {
                isValid = DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)VjoLanguageToolkit.getDefault(), (IPath)file.getLocation());
            }
            catch (Exception e) {
                DLTKCore.error((String)e.getMessage(), (Throwable)e);
            }
            return isValid;
        }

        public boolean visit(IResource resource) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (resource.getType() == 2) {
                this.monitor.subTask(String.valueOf(Messages.ScriptBuilder_scanningProjectFolder) + resource.getProjectRelativePath().toString());
            }
            if (resource.getType() == 1) {
                this.resources.add(resource);
                return false;
            }
            return true;
        }
    }
}

