/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion.advisor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.vjo.tool.codecompletion.IVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;
import org.eclipse.vjet.vjo.tool.codecompletion.advisor.AbstractVjoCcAdvisor;
import org.eclipse.vjet.vjo.tool.codecompletion.proposaldata.VjoCcProposalData;

public class VjoCcGlobalAdvisor
extends AbstractVjoCcAdvisor
implements IVjoCcAdvisor {
    public static final String ID = VjoCcGlobalAdvisor.class.getName();

    public void adviseOld(VjoCcCtx ctx) {
        String token = ctx.getActingToken();
        IJstType calledType = ctx.getGlobalType();
        if (calledType == null) {
            return;
        }
        List methods = calledType.getMethods();
        for (IJstMethod method : methods) {
            if (!method.getName().getName().startsWith(token)) continue;
            this.appendData(ctx, (IJstNode)method);
        }
        List properties = calledType.getProperties();
        for (IJstProperty property : properties) {
            if (!property.getName().getName().startsWith(token)) continue;
            this.appendData(ctx, (IJstNode)property);
        }
    }

    @Override
    public void advise(VjoCcCtx ctx) {
        String token = ctx.getToken();
        List vars = ctx.getJstTypeSpaceMgr().getQueryExecutor().getAllGroupScopedGlobalVars(ctx.getGroupName());
        if (vars == null) {
            return;
        }
        for (IJstNode node : vars) {
            JstAttributedType attrType;
            String name;
            IJstGlobalVar jsvar;
            IJstProperty property;
            IJstMethod method;
            if (node instanceof IJstMethod && (method = (IJstMethod)node).getName().getName().startsWith(token)) {
                this.appendMethod(ctx, method, method.getName().getName());
            }
            if (node instanceof IJstProperty && (property = (IJstProperty)node).getName().getName().startsWith(token)) {
                this.appendData(ctx, (IJstNode)property);
            }
            if (!(node instanceof IJstGlobalVar) || (jsvar = (IJstGlobalVar)node).getScopeForGlobal() != null || !(name = jsvar.getName().getName()).startsWith(token)) continue;
            if (jsvar.getTypeRef() instanceof JstTypeReference) {
                JstTypeReference tref = (JstTypeReference)jsvar.getTypeRef();
                if (tref.getReferencedType().isFType()) {
                    IJstMethod m = tref.getReferencedType().getMethod("_invoke_");
                    this.appendMethod(ctx, m, name);
                }
                tref.getOwnerType();
            }
            if (jsvar.getType() instanceof JstAttributedType && (attrType = (JstAttributedType)jsvar.getType()).getJstBinding() instanceof IJstMethod) {
                IJstMethod method2 = (IJstMethod)attrType.getJstBinding();
                this.appendMethod(ctx, method2, name);
            }
            if (jsvar.isFunc()) {
                this.appendData(ctx, (IJstNode)jsvar.getFunction());
                continue;
            }
            this.appendData(ctx, (IJstNode)jsvar.getProperty());
        }
    }

    private void appendMethod(VjoCcCtx ctx, IJstMethod method, final String name) {
        List smethods = JstTypeHelper.getSignatureMethods((IJstMethod)method);
        Iterator it = smethods.iterator();
        while (it.hasNext()) {
            ctx.getReporter().addPropsal(new VjoCcProposalData((IJstNode)it.next(), ctx, this.getId()){

                @Override
                public String getName() {
                    return name;
                }
            });
        }
    }

    @Override
    protected int[] getCallLevel(IJstType callingType, IJstType calledType) {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }
}

