/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.tool.codecompletion;

import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.vjo.tool.codecompletion.VjoCcCtx;

public class VjoCcCtxUtil {
    public static final String KEYWORD_TYPENAME = "@TYPENAME";
    public static final String WRAPPER_PREFIX = "vjo.ctype('@TYPENAME')\n.props({\n\t//>public void main(String... args)\n\tmain : function(args){\n\t\t";
    public static final String WRAPPER_SURFIX = "\n\t}\n})\n.endType();";

    public static boolean isAnalyzableCtx(VjoCcCtx ctx) {
        if (!ctx.isInSciptUnitArea()) {
            return true;
        }
        JstIdentifier jidentifier = ctx.getSFirstIdentifer();
        return jidentifier != null && "vjo".equals(jidentifier.getName());
    }

    public static String wrapContent(String content, String typeName) {
        return String.valueOf(WRAPPER_PREFIX.replace(KEYWORD_TYPENAME, typeName.replace('\\', '.'))) + content + WRAPPER_SURFIX;
    }

    public static int getPrefixOffset(String typeName) {
        return WRAPPER_PREFIX.length() - KEYWORD_TYPENAME.length() + typeName.length();
    }

    public static String getDotTypeName(String typeName) {
        int index = typeName.indexOf(".");
        if (index != -1) {
            typeName = typeName.substring(0, index);
        }
        if ((typeName = typeName.replace('\\', '.')).startsWith(".")) {
            typeName = typeName.substring(1);
        }
        return typeName;
    }

    public static JstBlock getExactBlock(IJstType unit, int position) {
        List blocks = unit.getJstBlockList();
        if (blocks != null && !blocks.isEmpty()) {
            int i = blocks.size() - 1;
            while (i > 0) {
                JstBlock block = (JstBlock)blocks.get(i);
                JstSource source = block.getSource();
                if (unit.getSource().getStartOffSet() != source.getStartOffSet() && VjoCcCtxUtil.isInSource(source, position)) {
                    return block;
                }
                --i;
            }
            return (JstBlock)blocks.get(0);
        }
        return null;
    }

    public static boolean isInSource(JstSource source, int position) {
        if (source == null) {
            return false;
        }
        return position > source.getStartOffSet() && position <= source.getEndOffSet();
    }
}

