/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.vjet.dsf.common.resource.ResolverFactory;

public class ResourceUtil {
    private static boolean s_debugFlag = true;

    static {
        String debugProp = System.getProperty("org.eclipse.vjet.dsf.common.resource.debugStartUp");
        if (debugProp != null && debugProp.length() > 0) {
            try {
                s_debugFlag = Boolean.parseBoolean(debugProp);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public static void setDebugStartUp(boolean flag) {
        s_debugFlag = flag;
    }

    public static InputStream getResourceAsStream(String relDir, String resourceName) throws IOException {
        InputStream is = null;
        URL resURL = ResourceUtil.getResource(relDir, resourceName);
        if (resURL != null) {
            is = resURL.openStream();
        }
        return is;
    }

    public static InputStream getResourceAsStream(Class sourceClass, String resourceName) throws IOException {
        InputStream is = null;
        URL resURL = ResourceUtil.getResource(sourceClass, resourceName);
        if (resURL != null) {
            is = resURL.openStream();
        }
        return is;
    }

    public static InputStream getMandatoryResourceAsStream(String relDir, String resourceName) throws IOException {
        InputStream result = ResourceUtil.getResourceAsStream(relDir, resourceName);
        if (result != null) {
            return result;
        }
        String err = "Unable to find resource " + relDir + File.separator + resourceName;
        throw new IOException(err);
    }

    public static InputStream getMandatoryResourceAsStream(Class sourceClass, String resourceName) throws IOException {
        InputStream result = ResourceUtil.getResourceAsStream(sourceClass, resourceName);
        if (result != null) {
            return result;
        }
        String err = "Unable to find resource " + resourceName + " relative to class " + sourceClass.getName();
        throw new IOException(err);
    }

    public static InputStream getResourceAsStream(Class sourceClass) throws IOException {
        return ResourceUtil.getResourceAsStream(sourceClass, ResourceUtil.getName(sourceClass));
    }

    public static URL getResource(String relDir, String resourceName) throws IOException {
        URL resURL = ResolverFactory.getInstance().getResource(relDir, resourceName);
        if (s_debugFlag && resURL != null) {
            System.out.println("Found file at " + resURL);
        }
        return resURL;
    }

    public static URL getResource(Class sourceClass, String resourceName) throws IOException {
        URL resURL = ResolverFactory.getInstance().getResource(sourceClass, resourceName);
        if (s_debugFlag && resURL != null) {
            System.out.println("Found config file at " + resURL);
        }
        return resURL;
    }

    public static URL getResource(Class sourceClass) throws IOException {
        return ResourceUtil.getResource(sourceClass, ResourceUtil.getName(sourceClass));
    }

    public static Properties getResourceAsProperties(String relDir, String resourceName) throws IOException {
        InputStream inputStream = ResourceUtil.getResourceAsStream(relDir, resourceName);
        if (inputStream == null) {
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            inputStream.close();
        }
    }

    public static Properties getResourceAsProperties(Class sourceClass, String resourceName) throws IOException {
        InputStream inputStream = ResourceUtil.getResourceAsStream(sourceClass, resourceName);
        if (inputStream == null) {
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            inputStream.close();
        }
    }

    public static Properties getResourceAsProperties(Class sourceClass) throws IOException {
        return ResourceUtil.getResourceAsProperties(sourceClass, ResourceUtil.getName(sourceClass));
    }

    private static String getName(Class clz) {
        String name = clz.getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return String.valueOf(name) + ".properties";
    }
}

