/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.initialization;

import java.util.ArrayList;
import org.eclipse.vjet.dsf.common.initialization.Initializable;
import org.eclipse.vjet.dsf.common.initialization.InitializationContext;
import org.eclipse.vjet.dsf.common.initialization.InitializationException;
import org.eclipse.vjet.dsf.common.initialization.InitializationHelper;
import org.eclipse.vjet.dsf.common.initialization.InitializationManagerInterface;
import org.eclipse.vjet.dsf.common.initialization.InitializationState;
import org.eclipse.vjet.dsf.common.initialization.ModuleInterface;
import org.eclipse.vjet.dsf.logger.LogLevel;
import org.eclipse.vjet.dsf.logger.Logger;

public abstract class BaseInitializationManager
implements InitializationManagerInterface {
    private static Logger s_logger = Logger.getInstance(BaseInitializationManager.class);
    private final ModuleInterface[] m_dependentModules;
    private InitializationState m_state = InitializationState.PRISTINE;
    private final InitializationHelper m_initializationHelper = new InitializationHelper();
    private long m_initTime = -1L;

    public BaseInitializationManager(ModuleInterface[] dependentModules) {
        this.m_dependentModules = dependentModules;
    }

    @Override
    public InitializationState getState() {
        return this.m_state;
    }

    protected final InitializationHelper getInitializationHelper() {
        return this.m_initializationHelper;
    }

    @Override
    public ModuleInterface[] getDependentModules() {
        return this.m_dependentModules;
    }

    public String getComponentName() {
        return this.getClass().getName();
    }

    @Override
    public final synchronized void doInitialize(InitializationContext context) throws InitializationException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.m_state == InitializationState.INITAILIZED) {
            context.out("initializing '" + this.getComponentName() + "' } already DONE ");
            return;
        }
        boolean isSuccess = false;
        try {
            context.out("initializing '" + this.getComponentName() + "' {");
            long startTime = System.currentTimeMillis();
            this.initialize(context);
            long endTime = System.currentTimeMillis();
            this.m_initTime = endTime - startTime;
            String msg = "initializing '" + this.getComponentName() + "' } DONE - time " + this.m_initTime + "ms";
            context.out(msg);
            if (this.m_initTime > 1000L) {
                s_logger.log(LogLevel.WARN, "ALERT-Mod-Init slow!!! " + msg);
            }
            this.m_state = this.hasCharacteristic(context) ? InitializationState.INITIALIZED_CHARACTERISTIC : InitializationState.INITAILIZED;
            isSuccess = true;
        }
        finally {
            if (!isSuccess) {
                this.m_state = InitializationState.INITAILIZED_FAILED;
                context.out("initializing FAILED '" + this.getComponentName() + "' }");
            }
        }
    }

    private boolean hasCharacteristic(InitializationContext context) {
        Initializable.CharacteristicEnum characteristic = context.getCharacteristic();
        return characteristic != null && characteristic != Initializable.CharacteristicEnum.NONE;
    }

    protected void initialize(InitializationContext context) {
        this.m_initializationHelper.initialize(context);
    }

    @Override
    public final synchronized void doShutdown(InitializationContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        try {
            context.out("shutdown '" + this.getComponentName() + "' {");
            this.shutdown(context);
            context.out("shutdown '" + this.getComponentName() + "' }DONE");
            this.m_state = InitializationState.SHUTDOWN;
        }
        finally {
            if (this.m_state != InitializationState.SHUTDOWN) {
                this.m_state = InitializationState.SHUTDOWN_FAILED;
            }
        }
    }

    protected void shutdown(InitializationContext context) {
        this.m_initializationHelper.shutdown(context);
    }

    @Override
    public boolean isNotifyUponInitDone() {
        return this.m_initializationHelper.isNotifyUponInitDone();
    }

    @Override
    public void notifyInitDone() {
        this.m_initializationHelper.notifyInitDone();
    }

    @Override
    public Initializable[] getInitializablesWithCharacteristic(Initializable.CharacteristicEnum characteristic) {
        ArrayList<Initializable> filteredInits = new ArrayList<Initializable>();
        Initializable[] inits = this.m_initializationHelper.getInitializables();
        if (characteristic == null || characteristic.equals(Initializable.CharacteristicEnum.NONE)) {
            return inits;
        }
        Initializable[] initializableArray = inits;
        int n = inits.length;
        int n2 = 0;
        while (n2 < n) {
            Initializable init = initializableArray[n2];
            if (init.getCharacteristics().contains(characteristic)) {
                filteredInits.add(init);
            }
            ++n2;
        }
        return filteredInits.toArray(new Initializable[0]);
    }

    @Override
    public boolean isLazyInitable() {
        return true;
    }
}

