/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstProxyIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstComletionOnMessageSend;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;

public class AllocationExpressionTranslator
extends BaseAst2JstTranslator<AllocationExpression, ObjCreationExpr> {
    private ObjCreationExpr objCreationExpr;

    @Override
    protected ObjCreationExpr doTranslate(AllocationExpression expr) {
        IExpr result = (IExpr)this.getTranslatorAndTranslate((IASTNode)expr.getMember());
        IExpr[] m_args = new IExpr[]{};
        if (expr.arguments != null) {
            this.m_ctx.enterBlock(ScopeIds.METHOD_CALL);
            m_args = new IExpr[expr.arguments.length];
            Expression[] arguments = expr.arguments;
            int i = 0;
            while (i < arguments.length) {
                m_args[i] = (IExpr)this.getTranslatorAndTranslate((IASTNode)arguments[i]);
                ++i;
            }
            this.m_ctx.exitBlock();
        }
        MtdInvocationExpr mtd = new MtdInvocationExpr((JstIdentifier)new JstProxyIdentifier(result), m_args);
        mtd.setSource(TranslateHelper.getSource((IASTNode)expr, (IFindTypeSupport.ILineInfoProvider)this.m_ctx.getSourceUtil()));
        this.objCreationExpr = new ObjCreationExpr(mtd);
        this.objCreationExpr.setSource(TranslateHelper.getSource((IASTNode)expr, (IFindTypeSupport.ILineInfoProvider)this.m_ctx.getSourceUtil()));
        return this.objCreationExpr;
    }

    @Override
    protected JstCompletion createCompletion(AllocationExpression node, boolean isAfter) {
        String token;
        int indexCloseBracket;
        int tempBegin = node.sourceStart();
        String literal = new String(this.m_ctx.getOriginalSource(), tempBegin, node.sourceEnd() - tempBegin + 1);
        JstComletionOnMessageSend completion = null;
        int indexOpenBracket = tempBegin + literal.indexOf("(");
        if (this.isInBracket(indexOpenBracket, indexCloseBracket = tempBegin + literal.lastIndexOf(")"), node) && this.isJavaIdentifier(token = this.getTokenInArgurent(node))) {
            completion = new JstComletionOnMessageSend((BaseJstNode)this.objCreationExpr);
            completion.setToken(this.getTokenInArgurent(node));
            completion.setCompositeToken(this.getCompositeTokenInArgument(node));
        }
        if (completion != null) {
            this.m_ctx.setCreatedCompletion(true);
        }
        return completion;
    }

    private boolean isInBracket(int indexOpen, int indexClose, AllocationExpression astNode) {
        int pos = this.m_ctx.getCompletionPos();
        boolean isInBracket = false;
        if (indexOpen != -1) {
            boolean bl = isInBracket = pos > indexOpen && pos <= indexClose;
        }
        if (indexOpen != -1 && indexClose != -1 && astNode.statementEnd != -1) {
            isInBracket = pos > indexOpen && pos <= astNode.statementEnd - 1;
        }
        return isInBracket;
    }

    private String getCompositeTokenInArgument(AllocationExpression node) {
        Object exprs = null;
        int pos = this.m_ctx.getCompletionPos();
        if (exprs == null || (exprs).length == 0) {
            return "";
        }
        Object var7_4 = exprs;
        int n = (var7_4).length;
        int n2 = 0;
        while (n2 < n) {
            void expr = var7_4[n2];
            if (expr.sourceStart() < pos && expr.sourceEnd() >= pos) {
                String s = new String(this.m_ctx.getOriginalSource(), expr.sourceStart() + 1, expr.sourceEnd() - expr.sourceStart() - 1);
                s = (String.valueOf(s) + "a").trim();
                s = s.substring(0, s.length() - 1);
                return s;
            }
            ++n2;
        }
        return "";
    }

    private String getTokenInArgurent(AllocationExpression node) {
        Object exprs = null;
        int pos = this.m_ctx.getCompletionPos();
        if (exprs == null || (exprs).length == 0) {
            return "";
        }
        Object var7_4 = exprs;
        int n = (var7_4).length;
        int n2 = 0;
        while (n2 < n) {
            void expr = var7_4[n2];
            if (expr.sourceStart() < pos && expr.sourceEnd() >= pos) {
                String s = new String(this.m_ctx.getOriginalSource(), expr.sourceStart() + 1, pos - expr.sourceStart() - 1);
                s = (String.valueOf(s) + "a").trim();
                s = s.substring(0, s.length() - 1);
                return s;
            }
            ++n2;
        }
        return "";
    }
}

