/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.robust.AvlTree;

public class JstSourceUtil
implements IFindTypeSupport.ILineInfoProvider {
    private static final LineInfo NEGONE = new LineInfo(-1, -1, -1);
    private char[] m_source;
    private List<LineInfo> m_lineInfo = new ArrayList<LineInfo>();
    private boolean m_init = false;
    private AvlTree m_tree;

    public JstSourceUtil(char[] source) {
        this.m_source = source;
    }

    public LineInfo lineInfo(int startOffset) {
        this.init();
        if (this.m_tree.getRoot() == null) {
            return new LineInfo(0, 0, 0);
        }
        return JstSourceUtil.binarySearch(this.m_lineInfo, startOffset);
    }

    @Override
    public int line(int startOffset) {
        this.init();
        LineInfo line = JstSourceUtil.binarySearchNew(this.m_tree, startOffset);
        return line.m_line;
    }

    /*
     * Unable to fully structure code
     */
    public static LineInfo binarySearch(List<LineInfo> a, int startOffset) {
        low = 0;
        high = a.size() - 1;
        if (startOffset != 0) ** GOTO lbl16
        return a.get(0);
lbl-1000:
        // 1 sources

        {
            mid = (low + high) / 2;
            lineInfo = a.get(mid);
            if (startOffset <= LineInfo.access$2(lineInfo) && startOffset >= LineInfo.access$3(lineInfo)) {
                return lineInfo;
            }
            if (JstSourceUtil.inLowerRange(lineInfo, startOffset)) {
                high = mid - 1;
                continue;
            }
            if (JstSourceUtil.inHigherRange(lineInfo, startOffset)) {
                low = mid + 1;
                continue;
            }
            return lineInfo;
lbl16:
            // 3 sources

            ** while (low <= high)
        }
lbl17:
        // 1 sources

        return JstSourceUtil.NEGONE;
    }

    public static LineInfo binarySearchNew(AvlTree tree, int startOffset) {
        return (LineInfo)JstSourceUtil.findLine((AvlTree)tree, (Comparable)new LineInfo((int)0, (int)startOffset, (int)0)).element;
    }

    private static AvlTree.AvlNode findLine(AvlTree tree, Comparable x) {
        AvlTree.AvlNode t = tree.getRoot();
        AvlTree.AvlNode preNode = null;
        while (t != null) {
            AvlTree.AvlNode rootCheck;
            if (preNode == null ? (rootCheck = JstSourceUtil.checkOffset(x, t, null)) != null : (rootCheck = JstSourceUtil.checkOffset(x, t, preNode)) != null) {
                return rootCheck;
            }
            if (x.compareTo(t.element) < 0 && t.left != null) {
                preNode = t;
                t = t.left;
                continue;
            }
            if (x.compareTo(t.element) > 0 && t.right != null) {
                preNode = t;
                t = t.right;
                continue;
            }
            if ((t = JstSourceUtil.checkOffset(x, t, preNode)) == null) continue;
            return t;
        }
        return null;
    }

    private static AvlTree.AvlNode checkOffset(Comparable x, AvlTree.AvlNode t, AvlTree.AvlNode preNode) {
        LineInfo tlio = (LineInfo)t.element;
        LineInfo xlio = (LineInfo)x;
        LineInfo prlio = null;
        if (preNode != null) {
            prlio = (LineInfo)preNode.element;
        }
        if (xlio.m_colStart >= tlio.m_colStart && xlio.m_colStart <= tlio.m_colEnd) {
            return t;
        }
        if (prlio != null && xlio.m_colStart >= prlio.m_colStart && xlio.m_colStart <= prlio.m_colEnd) {
            return preNode;
        }
        t = null;
        return t;
    }

    private static boolean inHigherRange(LineInfo lineInfo, int startOffset) {
        return startOffset > lineInfo.m_colEnd;
    }

    private static boolean inLowerRange(LineInfo lineInfo, int startOffset) {
        return startOffset < lineInfo.m_colStart;
    }

    private void init() {
        String[] lines;
        if (this.m_init || this.m_source == null) {
            return;
        }
        String source = new String(this.m_source);
        int lineCount = 1;
        int colStart = 0;
        int colEnd = 0;
        String[] stringArray = lines = source.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            colEnd = colEnd + line.length() + 1;
            this.m_lineInfo.add(new LineInfo(lineCount, colStart, colEnd));
            colStart = colEnd + 1;
            ++lineCount;
            ++n2;
        }
        this.setupBinaryTree();
        this.m_init = true;
    }

    private void setupBinaryTree() {
        AvlTree tree = new AvlTree();
        int i = 0;
        while (i < this.m_lineInfo.size()) {
            LineInfo linfo = this.m_lineInfo.get(i);
            tree.insert(linfo);
            ++i;
        }
        this.m_tree = tree;
    }

    @Override
    public int col(int startOffset) {
        this.init();
        LineInfo lineInfo = JstSourceUtil.binarySearchNew(this.m_tree, startOffset);
        return startOffset - lineInfo.m_colStart;
    }

    public static void main(String[] args) {
        String x = "abcd\nxyz\nddddddd\ndddddd\ndd\ndddd\ndddddd\nddddddd\ndddddd\n";
        JstSourceUtil y = new JstSourceUtil(x.toCharArray());
        int i = 0;
        while (i < x.length()) {
            System.out.println("i=" + i + ": " + y.line(i) + "," + y.col(i));
            ++i;
        }
    }

    public static class LineInfo
    implements Comparable<LineInfo> {
        private final int m_line;
        private final int m_colStart;
        private final int m_colEnd;

        public LineInfo(int lineCount, int colStart, int colEnd) {
            this.m_line = lineCount;
            this.m_colStart = colStart;
            this.m_colEnd = colEnd;
        }

        public int line() {
            return this.m_line;
        }

        public int colStart() {
            return this.m_colStart;
        }

        public int colEnd() {
            return this.m_colEnd;
        }

        @Override
        public int compareTo(LineInfo o) {
            int anotherVal;
            int thisVal = this.colStart();
            return thisVal < (anotherVal = o.colStart()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public String toString() {
            return "" + this.m_colStart;
        }
    }
}

