/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.vjet.dsf.jst.FileBinding;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstCommentLocation;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jstojava.parser.comments.CommentCollector;
import org.eclipse.vjet.dsf.jstojava.translator.BaseTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.TranslatorFactory;

public class TypeTranslator
extends BaseTranslator {
    public TypeTranslator(TranslateCtx ctx) {
        super(ctx);
    }

    public void processType(MessageSend el, JstType jstType) {
        assert (el != null);
        MessageSend receiver = el;
        do {
            if (receiver instanceof MessageSend) {
                MessageSend message = receiver;
                String method = String.valueOf(message.selector);
                if ("protos".equals(method)) {
                    this.getProvider().getProtosTranslator().process(message.arguments[0], jstType);
                } else if ("props".equals(method)) {
                    this.getProvider().getPropsTranslator().process(message.arguments[0], jstType);
                } else if ("globals".equals(method)) {
                    this.getProvider().getGlobalsTranslator().process(message.arguments[0], jstType);
                } else if ("inherits".equals(method)) {
                    this.processInherits(message, jstType);
                } else if ("satisfies".equals(method)) {
                    this.processSatisfies(message, jstType);
                } else if ("expects".equals(method)) {
                    this.processExpects(message, jstType);
                } else if ("mixin".equals(method)) {
                    this.processMixins(message, jstType);
                } else if ("makeFinal".equals(method)) {
                    jstType.getModifiers().merge(16);
                } else if ("inits".equals(method)) {
                    this.processInits(message.arguments[0], jstType);
                } else if ("options".equals(method)) {
                    this.getProvider().getGlobalsTranslator().process(message.arguments[0], jstType);
                } else if (!"endType".equals(method) && JstUtil.isType(method)) {
                    JstSource.IBinding oldBinding;
                    String fullName = TypeTranslator.getName(message);
                    JstCommentLocation comment = this.getCtx().getCommentCollector().getCommentLocationNonMeta2(message.sourceStart);
                    if (comment != null) {
                        jstType.addCommentLocation(comment);
                    }
                    int idx = 0;
                    if (!jstType.isEmbededType()) {
                        fullName = fullName.trim();
                        idx = fullName.lastIndexOf(46);
                        boolean hasGenericParams = true;
                        int end = fullName.indexOf("<");
                        if (end < 0) {
                            hasGenericParams = false;
                            end = fullName.length();
                        }
                        String clzName = fullName.substring(idx + 1, end);
                        if (idx > 0) {
                            String pkgName = fullName.substring(0, idx);
                            JstSource source = this.getPackageSource(message.arguments[0], idx);
                            JstPackage pkg = new JstPackage(pkgName);
                            pkg.setGroupName(this.m_ctx.getGroup());
                            pkg.setSource(source);
                            jstType.setPackage(pkg);
                        }
                        jstType.setSimpleName(clzName);
                        if (hasGenericParams && fullName.charAt(fullName.length() - 1) == '>') {
                            TranslateHelper.addParamsToType(this.getCtx(), jstType, fullName.substring(end + 1, fullName.length() - 1));
                        }
                        TypeTranslator.addInactiveNeeds(jstType, this.m_ctx);
                    }
                    JstSource source = this.getTypeNameSource((Expression)message, idx, fullName.length());
                    if (jstType.getSource() != null && (oldBinding = jstType.getSource().getBinding()) != null && oldBinding instanceof FileBinding) {
                        source.setBinding(oldBinding);
                    }
                    jstType.setSource(source);
                    if ("etype".equals(method)) {
                        jstType.setCategory(JstType.Category.ENUM);
                        jstType.getModifiers().setFinal();
                    } else if ("itype".equals(method)) {
                        jstType.setCategory(JstType.Category.INTERFACE);
                    } else if ("mtype".equals(method)) {
                        jstType.setCategory(JstType.Category.MODULE);
                    } else if ("otype".equals(method)) {
                        jstType.setCategory(JstType.Category.OTYPE);
                    } else if ("ftype".equals(method)) {
                        jstType.setCategory(JstType.Category.FTYPE);
                    }
                }
                receiver = message.getReceiver();
                continue;
            }
            if (receiver instanceof SingleNameReference) {
                receiver = null;
                continue;
            }
            System.err.println("Unprocessed type in processType TypeTranslator" + receiver);
            receiver = null;
        } while (receiver != null);
    }

    public static void addInactiveNeeds(JstType jstType, TranslateCtx ctx) {
        List<CommentCollector.InactiveNeedsWrapper> ineeds = ctx.getCommentCollector().getInactiveNeeds();
        for (CommentCollector.InactiveNeedsWrapper ineed : ineeds) {
            JstSource source;
            String ineedsTypeName = ineed.getNeedsTypeName();
            IJstTypeReference importType = TranslateHelper.getType(ctx, ineedsTypeName, source = new JstSource(2, -1, -1, ineedsTypeName.length(), ineed.getBeginOffset(), ineed.getEndOffset() + ineedsTypeName.length()));
            if (jstType.getInactiveImport(importType.getReferencedType().getSimpleName()) != null) {
                jstType.addInactiveImport("", importType);
                continue;
            }
            jstType.addInactiveImport(importType);
        }
    }

    private static String getName(MessageSend message) {
        String fullName = "";
        if (message.arguments != null && message.arguments.length > 0) {
            fullName = message.arguments[0].toString();
            fullName = JstUtil.getCorrectName(fullName);
        }
        return fullName;
    }

    private static String getName(Expression expr) {
        String fullName = "";
        if (expr instanceof MessageSend) {
            MessageSend message = (MessageSend)expr;
            if (message.arguments != null && message.arguments.length > 0) {
                fullName = message.arguments[0].toString();
                fullName = JstUtil.getCorrectName(fullName);
            }
        } else {
            fullName = expr.toString();
            fullName = JstUtil.getCorrectName(fullName);
        }
        return fullName;
    }

    public void processIType(MessageSend el, JstType jstType) {
        assert (el != null);
        jstType.setCategory(JstType.Category.INTERFACE);
        this.processType(el, jstType);
    }

    public void processMType(MessageSend el, JstType jstType) {
        assert (el != null);
        jstType.setCategory(JstType.Category.MODULE);
        this.processType(el, jstType);
    }

    public void processOType(MessageSend el, JstType jstType) {
        assert (el != null);
        jstType.setCategory(JstType.Category.OTYPE);
        this.processType(el, jstType);
    }

    public void processEType(MessageSend el, JstType jstType) {
        assert (el != null);
        jstType.setCategory(JstType.Category.ENUM);
        this.processType(el, jstType);
    }

    public void processAType(MessageSend el, JstType jstType) {
        assert (el != null);
        jstType.getModifiers().setAbstract();
        this.processCType(el, jstType);
    }

    public void processCType(MessageSend el, JstType jstType) {
        jstType.setCategory(JstType.Category.CLASS);
        this.processType(el, jstType);
    }

    public void processFType(MessageSend el, JstType jstType) {
        assert (el != null);
        jstType.setCategory(JstType.Category.FTYPE);
        this.processType(el, jstType);
    }

    public void processInits(Expression expr, JstType jstType) {
        if (this.m_ctx.isSkiptImplementation()) {
            return;
        }
        if (expr instanceof FunctionExpression) {
            FunctionExpression funcExpr = (FunctionExpression)expr;
            IProgramElement[] statements = funcExpr.getMethodDeclaration().getStatements();
            if (statements != null) {
                IProgramElement[] iProgramElementArray = statements;
                int n = statements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object result;
                    IProgramElement st = iProgramElementArray[n2];
                    BaseAst2JstTranslator translator = TranslatorFactory.getTranslator((IASTNode)st, this.m_ctx);
                    if (translator != null && (result = translator.translate(st)) instanceof IStmt) {
                        jstType.addInit((IStmt)result, true);
                    }
                    ++n2;
                }
            }
        } else {
            System.err.println("Unprocessed type: " + expr.getClass() + " in processInits TypeTranslator");
        }
    }

    public void processSatisfies(MessageSend expr, JstType jstType) {
        this.processInheritsOrImplements(expr, jstType, JstType.Category.INTERFACE);
    }

    public void processInherits(MessageSend expr, JstType jstType) {
        this.processInheritsOrImplements(expr, jstType, JstType.Category.CLASS);
    }

    public void processExpects(MessageSend expr, JstType jstType) {
        this.processInheritsOrImplements(expr, jstType, JstType.Category.MODULE);
    }

    private void processInheritsOrImplements(MessageSend expr, JstType jstType, JstType.Category category) {
        Expression[] params = expr.arguments;
        if (params != null && params.length > 0) {
            if (this.isString((IExpression)params[0])) {
                this.processInheritsOrSatisfies(params[0], jstType, category);
            } else if (this.isArray((IExpression)params[0])) {
                ArrayInitializer param = (ArrayInitializer)params[0];
                if (param.expressions != null && param.expressions.length > 0) {
                    if (JstType.Category.INTERFACE == category) {
                        Expression[] expressionArray = param.expressions;
                        int n = param.expressions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Expression ast = expressionArray[n2];
                            this.processInheritsOrSatisfies(ast, jstType, category);
                            ++n2;
                        }
                    } else {
                        Expression ast = param.expressions[0];
                        this.processInheritsOrSatisfies(ast, jstType, category);
                    }
                }
            }
        } else {
            this.processInheritsOrSatisfies((Expression)expr, jstType, category);
        }
    }

    private void processInheritsOrSatisfies(Expression expr, JstType jstType, JstType.Category category) {
        String extendedTypeName = TypeTranslator.getName(expr);
        IJstType extendedType = TranslateHelper.findType((IFindTypeSupport)this.m_ctx, extendedTypeName);
        JstSource source = this.getTypeNameSource(expr, extendedTypeName.lastIndexOf("."), extendedTypeName.length());
        switch (category) {
            case CLASS: {
                JstTypeReference reference = TranslateHelper.createRef(extendedType, source);
                jstType.addExtend((IJstTypeReference)reference);
                break;
            }
            case INTERFACE: {
                JstTypeReference reference = TranslateHelper.createRef(extendedType, source);
                jstType.addSatisfy((IJstTypeReference)reference);
                jstType.addImport(extendedType);
                break;
            }
            case MODULE: {
                JstTypeReference reference = TranslateHelper.createRef(extendedType, source);
                jstType.addExpects((IJstTypeReference)reference);
            }
        }
    }

    public void processMixins(MessageSend expr, JstType jstType) {
        assert (expr != null) : "Error parsing mixin";
        boolean isError = false;
        if (expr.getArguments() != null) {
            IExpression argExpr = expr.getArguments()[0];
            if (this.isString(argExpr)) {
                JstTypeReference mixinType = this.getType(this.m_ctx, (Literal)argExpr);
                if (mixinType != null) {
                    jstType.addMixin((IJstTypeReference)mixinType);
                }
            } else if (this.isArray(argExpr)) {
                ArrayInitializer mixinExpr = (ArrayInitializer)argExpr;
                Expression[] expressionArray = mixinExpr.expressions;
                int n = mixinExpr.expressions.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression e = expressionArray[n2];
                    if (this.isString((IExpression)e)) {
                        JstTypeReference mixinType = this.getType(this.m_ctx, (Literal)e);
                        jstType.addMixin((IJstTypeReference)mixinType);
                    } else {
                        isError = true;
                    }
                    ++n2;
                }
            } else {
                isError = true;
            }
        } else {
            isError = true;
        }
        if (isError) {
            System.err.println("Error while proccesing mixin statement: " + expr.toString());
        }
    }

    public void processNeeds(IExpression[] params, JstType jstType) {
        assert (params != null);
        if (params != null && params.length > 0) {
            if (this.isString(params[0])) {
                Literal literal = (Literal)params[0];
                JstTypeReference type = this.getType(this.m_ctx, literal);
                if (type != null) {
                    if (params.length > 1 && this.isString(params[1])) {
                        literal = (Literal)params[1];
                        String alias = JstUtil.getCorrectName(literal);
                        jstType.addImport(alias, (IJstTypeReference)type);
                    } else {
                        jstType.addImport((IJstTypeReference)type);
                    }
                }
            } else if (this.isArray(params[0])) {
                ArrayInitializer param = (ArrayInitializer)params[0];
                if (param.expressions != null) {
                    Expression[] expressionArray = param.expressions;
                    int n = param.expressions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JstTypeReference type;
                        Expression ast = expressionArray[n2];
                        if (ast instanceof StringLiteral && (type = this.getType(this.m_ctx, (Literal)ast)) != null) {
                            jstType.addImport((IJstTypeReference)type);
                        }
                        ++n2;
                    }
                } else {
                    System.err.println("Error while proccesing needs statement");
                }
            }
        } else {
            System.err.println("Error while proccesing needs statement");
        }
    }

    private JstTypeReference getType(TranslateCtx m_ctx, Literal literal) {
        assert (literal != null);
        String typeName = JstUtil.getCorrectName(literal);
        if (typeName.equals("")) {
            return null;
        }
        JstSource source = this.getTypeNameSource((Expression)literal, typeName.lastIndexOf("."), typeName.length());
        IJstType type = TranslateHelper.getJstType(TranslateHelper.findType((IFindTypeSupport)m_ctx, typeName));
        JstTypeReference reference = TranslateHelper.createRef(type, source);
        return reference;
    }

    private JstSource getTypeNameSource(Expression expression, int lastDotIdx, int length) {
        if (expression instanceof MessageSend) {
            MessageSend messageSendExpression = (MessageSend)expression;
            if (messageSendExpression.arguments != null && messageSendExpression.arguments.length > 0) {
                expression = messageSendExpression.arguments[0];
            } else {
                JstSource source = TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), 0, messageSendExpression.sourceEnd, messageSendExpression.sourceEnd);
                return source;
            }
        }
        if (lastDotIdx != -1) {
            length = length - lastDotIdx - 1;
        }
        int beginOffset = expression.sourceStart() + 1 + lastDotIdx + 1;
        JstSource source = TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), length, beginOffset, beginOffset + length - 1);
        return source;
    }

    private JstSource getPackageSource(Expression expression, int lastDotIdx) {
        int len = lastDotIdx > 0 ? lastDotIdx : 0;
        int endOffset = len > 0 ? expression.sourceStart + len : expression.sourceStart + 1;
        return TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), len, expression.sourceStart + 1, endOffset);
    }
}

