/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jstojava.resolver.ITypeConstructContext;
import org.eclipse.vjet.dsf.jstojava.resolver.ITypeConstructorResolver;

public class TypeConstructorRegistry {
    private static final TypeConstructorRegistry s_instance = new TypeConstructorRegistry();
    private Map<String, List<ITypeConstructorResolver>> m_resolvers = new HashMap<String, List<ITypeConstructorResolver>>();

    public static TypeConstructorRegistry getInstance() {
        return s_instance;
    }

    public TypeConstructorRegistry addResolver(String key, ITypeConstructorResolver resolver) {
        List<ITypeConstructorResolver> resolverList = this.m_resolvers.get(key);
        if (resolverList == null) {
            resolverList = new ArrayList<ITypeConstructorResolver>(1);
            this.m_resolvers.put(key, resolverList);
        }
        resolverList.add(resolver);
        return this;
    }

    public void resolve(String key, ITypeConstructContext constrCtx) {
        List<ITypeConstructorResolver> resolverList = this.m_resolvers.get(key);
        if (resolverList == null) {
            return;
        }
        int i = 0;
        while (i < resolverList.size()) {
            ITypeConstructorResolver resolver = resolverList.get(i);
            if (constrCtx.getExprClass().equals(resolver.getExprClass())) {
                resolver.resolve(constrCtx);
                return;
            }
            ++i;
        }
    }

    public boolean hasResolver(String key) {
        return this.m_resolvers.containsKey(key);
    }

    public void clear(String groupId) {
        for (List<ITypeConstructorResolver> resolverList : this.m_resolvers.values()) {
            int i = resolverList.size() - 1;
            while (i >= 0) {
                ITypeConstructorResolver resolver = resolverList.get(i);
                String[] stringArray = resolver.getGroupIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String grp = stringArray[n2];
                    if (groupId.endsWith(grp)) {
                        resolverList.remove(resolver);
                    }
                    ++n2;
                }
                --i;
            }
        }
    }

    public void clearAll() {
        this.m_resolvers.clear();
    }
}

