/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser.bootstrap;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeSerializer;
import org.eclipse.vjet.dsf.jstojava.parser.bootstrap.BootstrapParser;
import org.eclipse.vjet.vjo.VjBootStrapDef;
import org.eclipse.vjet.vjo.VjBootstrapJsr;

public class VjoBootstrapGen {
    public static void main(String[] args) {
        if (args.length == 0) {
            throw new RuntimeException("Must provide location of ser file to generate");
        }
        String filePath = args[0];
        System.out.println("Target file: " + filePath);
        URL f = VjBootstrapJsr.getJsAsUrl();
        URL bapi = VjBootstrapJsr.getVjoApIAsUrl();
        try {
            Collection<? extends IJstType> types = BootstrapParser.createJstType("vjo", f, VjBootStrapDef.SCHEMA, bapi, VjBootstrapJsr.getVjoConsoleAsUrl(), VjBootstrapJsr.getVjoClassAsUrl(), VjBootstrapJsr.getVjoEnumAsUrl(), VjBootstrapJsr.getVjoOptionsOLUrl(), VjBootstrapJsr.getVjoObjectAsUrl()).values();
            IJstType[] typeAry = new IJstType[types.size()];
            types.toArray(typeAry);
            ArrayList<IJstType> typeList = new ArrayList<IJstType>(types);
            VjoBootstrapGen.serialize(typeList, filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void serialize(List<IJstType> types, String filePath) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            JstTypeSerializer.getInstance().serialize(types, (OutputStream)fos);
            System.out.println("JsLibPreBuildTask: wrote " + filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error serializing JstType - " + e.getMessage());
        }
    }
}

