/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.manifest;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.dsf.jstojava.loader.DefaultJstTypeLoader;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.vjo.lib.TsLibLoader;

public class CreateTypesList {
    private static String createManifest(Collection<IJstType> types) {
        StringBuilder sb = new StringBuilder();
        for (IJstType type : types) {
            String fullName = type.getName();
            if (type instanceof JstObjectLiteralType) {
                System.out.println(type);
                fullName = type.getPackage().getName();
            }
            sb.append(String.valueOf(fullName) + "\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        JstParseController controller = new JstParseController(new VjoParser());
        JstTypeSpaceMgr ts = new JstTypeSpaceMgr((IJstParseController)controller, (IJstTypeLoader)new DefaultJstTypeLoader());
        ts.initialize();
        TsLibLoader.loadDefaultLibs((JstTypeSpaceMgr)ts);
        IGroup group = ts.getTypeSpace().getGroup(TsLibLoader.getBrowserGroups()[0]);
        String manifest = CreateTypesList.createManifest(group.getEntities().values());
        System.out.println(manifest);
    }

    public static void createManifest(File typestxt, Collection<IJstType> values) {
        block12: {
            String manifestTxt = CreateTypesList.createManifest(values);
            FileWriter fos = null;
            try {
                try {
                    fos = new FileWriter(typestxt);
                    fos.append(manifestTxt);
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fos == null) break block12;
                    try {
                        fos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

