/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.vjet.dsf.jsgroup.bootstrap.JsLibBootstrapLoader;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.SimpleBinding;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.util.JstRefTypeDependencyCollector;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeSerializer;
import org.eclipse.vjet.dsf.jstojava.loader.CharOperation;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateConfig;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;

public class OnDemandAllTypeLoader
implements IJstTypeLoader {
    private static final String ONDEMAND = "ONDEMAND";
    private static final String JS = ".js";
    private static final String SUFFIX_ZIP = ".zip";
    private static final String SUFFIX_JAR = "jar";
    private IJstType m_type;
    private String m_group = "ONDEMAND";
    private List<IJstTypeLoader.SourceType> m_sources;
    private Map<String, String> m_lookedup = new HashMap<String, String>();
    private List<String> m_exclusionRules;

    public OnDemandAllTypeLoader(IJstType type) {
        this.m_type = type;
    }

    public OnDemandAllTypeLoader(String group, IJstType type) {
        this.m_type = type;
        this.m_group = group;
    }

    public OnDemandAllTypeLoader(String group, IJstType type, List<String> exclusionRules) {
        this.m_type = type;
        this.m_group = group;
        this.m_exclusionRules = exclusionRules;
    }

    protected void findSources(IJstType type) {
        JavaSourceLocator locator = JavaSourceLocator.getInstance();
        for (IJstTypeReference ineed : JstRefTypeDependencyCollector.getDependency((IJstType)type).values()) {
            this.addSource(locator, ineed.getReferencedType());
            this.findSources(ineed.getReferencedType().getName());
        }
        for (IJstTypeReference ineed : type.getImports()) {
            if (ineed.getAlias() == null) continue;
            this.addSource(locator, (IJstType)ineed);
            this.findSources(ineed.getName());
        }
    }

    public List<IJstTypeLoader.SourceType> loadJstTypes(List<AddGroupEvent> groupList) {
        this.m_sources = new ArrayList<IJstTypeLoader.SourceType>(5);
        JavaSourceLocator locator = JavaSourceLocator.getInstance();
        if (this.m_type.getName() != null) {
            this.addSource(locator, this.m_type);
            this.findSources(this.m_type);
            ArrayList<IJstTypeLoader.SourceType> rev = new ArrayList<IJstTypeLoader.SourceType>();
            int i = this.m_sources.size() - 1;
            while (i >= 0) {
                rev.add(this.m_sources.get(i));
                --i;
            }
            return rev;
        }
        for (AddGroupEvent event : groupList) {
            if (event.getGroupPath() == null || !event.getGroupPath().endsWith(SUFFIX_ZIP)) continue;
            return this.loadJstTypesFromLibrary(event.getGroupName(), new File(event.getGroupPath()));
        }
        return Collections.EMPTY_LIST;
    }

    public static boolean isBinaryPath(String path) {
        return path.endsWith(SUFFIX_ZIP) || path.endsWith(SUFFIX_JAR);
    }

    protected List<IJstTypeLoader.SourceType> loadJstTypesFromLibrary(String groupName, File libFile) {
        ArrayList<IJstTypeLoader.SourceType> typeList = new ArrayList<IJstTypeLoader.SourceType>();
        String libFileName = libFile.getName().toLowerCase();
        if (OnDemandAllTypeLoader.isBinaryPath(libFileName)) {
            ZipFile jarFile = null;
            try {
                try {
                    jarFile = new ZipFile(libFile);
                    ZipEntry bootstrapEntry = jarFile.getEntry("bootstrap.js");
                    if (bootstrapEntry != null) {
                        InputStream stream = jarFile.getInputStream(bootstrapEntry);
                        JsLibBootstrapLoader.load(VjoParser.load(stream, "bootstrap.js"), groupName);
                    }
                    Enumeration<? extends ZipEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry elem = enumeration.nextElement();
                        if (elem.getName().endsWith(".ser")) {
                            typeList.addAll(this.loadAllTypes(groupName, jarFile, elem));
                            continue;
                        }
                        if (elem.getName().contains("bootstrap.js")) continue;
                        typeList.add(this.createType(groupName, jarFile, elem));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        jarFile.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return typeList;
    }

    protected IJstTypeLoader.SourceType createType(String groupName, ZipFile jarFile, ZipEntry elem) throws IOException {
        String typeName = elem.getName();
        if (!typeName.endsWith(JS)) {
            return null;
        }
        int end = typeName.lastIndexOf(JS);
        typeName = typeName.substring(0, end);
        typeName = typeName.replace("\\", ".");
        typeName = typeName.replace("/", ".");
        InputStream stream = jarFile.getInputStream(elem);
        byte[] bs = new byte[stream.available()];
        stream.read(bs);
        stream.close();
        String source = new String(bs);
        File f = null;
        f = new File(String.valueOf(jarFile.getName()) + "!" + elem.getName());
        IJstTypeLoader.SourceType srcType = new IJstTypeLoader.SourceType(groupName, typeName, source, f);
        return srcType;
    }

    protected List<IJstTypeLoader.SourceType> loadAllTypes(String groupName, ZipFile jarFile, ZipEntry elem) throws IOException {
        InputStream stream = jarFile.getInputStream(elem);
        List jstTypes = JstTypeSerializer.getInstance().deserialize(stream);
        ArrayList<IJstTypeLoader.SourceType> srcTypes = new ArrayList<IJstTypeLoader.SourceType>();
        for (IJstType type : jstTypes) {
            if (JstCache.getInstance().getType(type.getName()) == null) {
                JstCache.getInstance().addType((JstType)type);
                if (type.getAliasTypeName() != null && type instanceof JstObjectLiteralType) {
                    JstCache.getInstance().addAliasType(type.getAliasTypeName(), (JstObjectLiteralType)type);
                }
            }
            srcTypes.add(new IJstTypeLoader.SourceType(groupName, type));
        }
        return srcTypes;
    }

    protected void findSources(String typeName) {
        if (this.alreadyLookedup(typeName)) {
            return;
        }
        JavaSourceLocator locator = JavaSourceLocator.getInstance();
        URL url = locator.getSourceUrl(typeName, JS);
        if (url == null) {
            url = locator.getSourceUrl(typeName, ".vjo");
        }
        if (url != null) {
            TranslateConfig cfg = new TranslateConfig();
            cfg.setSkiptImplementation(true);
            VjoParser p = new VjoParser(cfg);
            IJstType type = p.parse(this.m_group, url);
            if (type != null) {
                this.findSources(type);
            }
        }
    }

    protected boolean alreadyLookedup(String typeName) {
        if (this.m_lookedup.get(typeName) != null) {
            return true;
        }
        this.m_lookedup.put(typeName, "");
        return false;
    }

    protected void addSource(JavaSourceLocator locator, IJstType ineed) {
        URL url = locator.getSourceUrl(ineed.getName(), JS);
        if (url == null && ineed.getSource() != null && ineed.getSource().getBinding() != null && ineed.getSource().getBinding() instanceof SimpleBinding) {
            try {
                File f = new File(((SimpleBinding)ineed.getSource().getBinding()).getName());
                url = f.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (url != null) {
            String src = locator.getSource(url);
            File file = new File(url.getFile());
            if (!this.isExcluded(file, null, this.m_exclusionRules)) {
                this.m_sources.add(new IJstTypeLoader.SourceType(this.m_group, ineed.getName(), src, file));
            }
        }
    }

    public boolean isExcluded(File file, List<String> inclusionPatterns, List<String> exclusionPatterns) {
        if (inclusionPatterns.size() == 0 && exclusionPatterns.size() == 0) {
            return false;
        }
        Object inclusionPatternsChar = new char[][]{};
        inclusionPatternsChar = OnDemandAllTypeLoader.processPatterns(inclusionPatterns);
        Object exclusionPatternsChar = new char[][]{};
        exclusionPatternsChar = OnDemandAllTypeLoader.processPatterns(exclusionPatterns);
        boolean excluded = OnDemandAllTypeLoader.isExcluded(file.toString().toCharArray(), inclusionPatternsChar, exclusionPatternsChar, file.isDirectory());
        if (excluded) {
            System.out.println("file excluded :" + file);
        }
        return excluded;
    }

    public static final boolean isExcluded(char[] path, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        int length;
        int i;
        block9: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            if (inclusionPatterns != null) {
                i = 0;
                length = inclusionPatterns.length;
                while (i < length) {
                    int star;
                    int lastSlash;
                    char[] pattern;
                    char[] folderPattern = pattern = inclusionPatterns[i];
                    if (isFolderPath && (lastSlash = CharOperation.lastIndexOf('/', pattern)) != -1 && lastSlash != pattern.length - 1 && ((star = CharOperation.indexOf('*', pattern, lastSlash)) == -1 || star >= pattern.length - 1 || pattern[star + 1] != '*')) {
                        folderPattern = CharOperation.subarray(pattern, 0, lastSlash);
                    }
                    if (!CharOperation.pathMatch(folderPattern, path, true, '/')) {
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = CharOperation.concat(path, new char[]{'*'}, '/');
        }
        if (exclusionPatterns != null) {
            i = 0;
            length = exclusionPatterns.length;
            while (i < length) {
                if (CharOperation.pathMatch(exclusionPatterns[i], path, true, '/')) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static char[][] processPatterns(List<String> patterns) {
        int length = patterns.size();
        char[][] patternsChar = new char[length][];
        int i = 0;
        while (i < length) {
            patternsChar[i] = patterns.get(i).toCharArray();
            ++i;
        }
        return patternsChar;
    }
}

