/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.controller;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgroup.bootstrap.JsLibBootstrapLoader;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.lib.IJstLibProvider;
import org.eclipse.vjet.vjo.lib.LibManager;

public class NativeJsLibProvider
implements IJstLibProvider {
    private Map<String, IJstLib> m_jstLibMap = new HashMap<String, IJstLib>();
    private boolean m_primitivesFixed = false;

    public NativeJsLibProvider() {
        IJstLib javaPrimitivelib = LibManager.getInstance().getJavaPrimitiveLib();
        this.add(javaPrimitivelib);
        IJstLib jsGlobals = LibManager.getInstance().getJsNativeGlobalLib();
        this.add(jsGlobals);
        this.fixPrimitives(jsGlobals, javaPrimitivelib);
        IJstLib browserLib = LibManager.getInstance().getBrowserTypesLib();
        this.addBrowserExtensions(browserLib.getName());
        this.add(browserLib);
    }

    private void addBrowserExtensions(String name) {
        try {
            InputStream resource = NativeJsLibProvider.class.getResourceAsStream("browserbootstrap.js");
            String bootstrapJS = this.getFileContents(resource);
            JsLibBootstrapLoader.load(bootstrapJS, "JsNativeLib");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    protected String getFileContents(InputStream stream) throws IOException, URISyntaxException {
        byte[] bs = new byte[stream.available()];
        stream.read(bs);
        stream.close();
        return new String(bs);
    }

    private void fixPrimitives(IJstLib jsGlobals, IJstLib javaPrimitivelib) {
        String[] dataTypesToExtendNumber;
        if (this.m_primitivesFixed) {
            return;
        }
        JstType arguments = jsGlobals.getType("Arguments", false);
        arguments.setMetaType(true);
        JstType global = jsGlobals.getType("Global", false);
        global.setMetaType(true);
        JstType charT = javaPrimitivelib.getType("char", false);
        charT.setMetaType(true);
        JstType voidT = javaPrimitivelib.getType("void", false);
        voidT.setMetaType(true);
        JstType booleanT = javaPrimitivelib.getType("boolean", false);
        booleanT.setMetaType(true);
        booleanT.removeExtend(booleanT.getExtend());
        booleanT.addExtend((IJstType)jsGlobals.getType("PrimitiveBoolean", false));
        JstType number = jsGlobals.getType("Number", false);
        String[] stringArray = dataTypesToExtendNumber = new String[]{"int", "double", "float", "short", "long", "byte"};
        int n = dataTypesToExtendNumber.length;
        int n2 = 0;
        while (n2 < n) {
            String needsToExtend = stringArray[n2];
            JstType type = javaPrimitivelib.getType(needsToExtend, false);
            type.setMetaType(true);
            IJstType extend = type.getExtend();
            if (extend == null || number.getName().equals(extend.getName())) {
                type.removeExtend(extend);
                type.addExtend((IJstType)number);
            }
            ++n2;
        }
        this.m_primitivesFixed = true;
    }

    public IJstLibProvider add(IJstLib jstLib) {
        if (jstLib == null) {
            return this;
        }
        this.m_jstLibMap.put(jstLib.getName(), jstLib);
        JstCache.getInstance().addLib(jstLib);
        return this;
    }

    public void clearAll() {
        this.m_jstLibMap.clear();
    }

    public List<IJstLib> getAll() {
        return new ArrayList<IJstLib>(this.m_jstLibMap.values());
    }

    public IJstLib remove(String lib) {
        return this.m_jstLibMap.remove(lib);
    }
}

