/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.HelpFormatter;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.Option;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.OptionGroup;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.Options;

public class VjetVFormatter
extends HelpFormatter {
    @Override
    public void printUsage(PrintWriter pw, int width, String app, Options options) {
        StringBuffer buff = new StringBuffer(this.defaultSyntaxPrefix).append(app).append(" ");
        ArrayList<OptionGroup> processedGroups = new ArrayList<OptionGroup>();
        ArrayList optList = new ArrayList(options.getOptions());
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option = (Option)i.next();
            OptionGroup group = options.getOptionGroup(option);
            if (group != null) {
                if (!processedGroups.contains(group)) {
                    processedGroups.add(group);
                    this.appendOptionGroup(buff, group);
                }
            } else {
                VjetVFormatter.appendOption(buff, option, option.isRequired());
            }
            if (!i.hasNext()) continue;
            buff.append(" ");
        }
        this.printWrapped(pw, width, buff.toString().indexOf(32) + 1, buff.toString());
    }

    private void appendOptionGroup(StringBuffer buff, OptionGroup group) {
        if (!group.isRequired()) {
            buff.append("[");
        }
        ArrayList optList = new ArrayList(group.getOptions());
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            VjetVFormatter.appendOption(buff, (Option)i.next(), true);
            if (!i.hasNext()) continue;
            buff.append(" | ");
        }
        if (!group.isRequired()) {
            buff.append("]");
        }
    }

    private static void appendOption(StringBuffer buff, Option option, boolean required) {
        if (!required) {
            buff.append("[");
        }
        if (option.getOpt() != null) {
            buff.append("-").append(option.getOpt());
        } else {
            buff.append("--").append(option.getLongOpt());
        }
        if (option.hasArg() && option.hasArgName()) {
            buff.append(" <").append(option.getArgName()).append(">");
        }
        if (!required) {
            buff.append("]");
        }
    }

    @Override
    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        StringBuffer optBuf;
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        ArrayList optList = new ArrayList(options.getOptions());
        for (Option option : optList) {
            optBuf = new StringBuffer(8);
            if (option.getOpt() == null) {
                optBuf.append(lpad).append("   " + this.defaultLongOptPrefix).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.defaultOptPrefix).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.defaultLongOptPrefix).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    optBuf.append(" <").append(option.getArgName()).append(">");
                } else {
                    optBuf.append(' ');
                }
            }
            prefixList.add(optBuf);
            int n = max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option = (Option)i.next();
            if ((optBuf = new StringBuffer(prefixList.get(x++).toString())).length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPad;
            if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
            if (!i.hasNext()) continue;
            sb.append(this.defaultNewLine);
        }
        return sb;
    }
}

