/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.index;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexNode;
import org.eclipse.vjet.dsf.ts.index.IDependencyIndexMap;

public class DependencyIndexMap<D>
implements IDependencyIndexMap<D> {
    private final Map<String, DependencyIndexNode<D>> m_nodes = new LinkedHashMap<String, DependencyIndexNode<D>>();

    @Override
    public List<D> getDependents(String name) {
        DependencyIndexNode<D> node = this.getNodes().get(name);
        if (node == null) {
            return Collections.emptyList();
        }
        return node.getDependents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependent(String name, D dependent) {
        if (name == null || dependent == null) {
            return;
        }
        DependencyIndexMap dependencyIndexMap = this;
        synchronized (dependencyIndexMap) {
            DependencyIndexNode<D> node = this.m_nodes.get(name);
            if (node == null) {
                node = new DependencyIndexNode(name);
                this.m_nodes.put(name, node);
            }
            node.addDependent(dependent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependents(String name, List<D> dependents) {
        if (name == null || dependents == null) {
            return;
        }
        DependencyIndexMap dependencyIndexMap = this;
        synchronized (dependencyIndexMap) {
            DependencyIndexNode<D> node = this.m_nodes.get(name);
            if (node == null) {
                node = new DependencyIndexNode(name);
                this.m_nodes.put(name, node);
            }
            node.addDependents(dependents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameEntity(String oldName, String newName) {
        if (oldName == null) {
            throw new RuntimeException("oldName is null");
        }
        if (newName == null) {
            throw new RuntimeException("newName is null");
        }
        DependencyIndexMap dependencyIndexMap = this;
        synchronized (dependencyIndexMap) {
            this.m_nodes.put(newName, this.m_nodes.remove(oldName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyIndexNode<D> removeEntity(String name) {
        if (name == null) {
            return null;
        }
        DependencyIndexMap dependencyIndexMap = this;
        synchronized (dependencyIndexMap) {
            return this.m_nodes.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntity(DependencyIndexNode<D> node) {
        if (node == null) {
            return;
        }
        DependencyIndexMap dependencyIndexMap = this;
        synchronized (dependencyIndexMap) {
            this.m_nodes.put(node.getName(), node);
        }
    }

    public void removeDependent(String name, D dependent) {
        if (name == null || dependent == null) {
            return;
        }
        DependencyIndexNode<D> node = this.getNodes().get(name);
        if (node != null) {
            node.removeDependent(dependent);
        }
    }

    public void removeDependents(String name, List<D> dependents) {
        if (name == null || dependents == null || dependents.size() == 0) {
            return;
        }
        DependencyIndexNode<D> node = this.getNodes().get(name);
        if (node != null) {
            node.removeDependents(dependents);
        }
    }

    public int size() {
        return this.getNodes().size();
    }

    public Map<String, DependencyIndexNode<D>> getMap() {
        return Collections.unmodifiableMap(this.m_nodes);
    }

    public String toString() {
        Z z = new Z();
        Map<String, DependencyIndexNode<D>> nodes = this.getNodes();
        z.format((Object)"Types: ");
        for (String name : nodes.keySet()) {
            z.format((Object)(" * " + name + "=[" + nodes.get(name) + "]"));
        }
        return z.toString();
    }

    private synchronized Map<String, DependencyIndexNode<D>> getNodes() {
        return Collections.unmodifiableMap(this.m_nodes);
    }
}

