/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.group;

import java.util.List;
import org.eclipse.vjet.dsf.ts.graph.IDependencyCollector;
import org.eclipse.vjet.dsf.ts.group.Group;
import org.eclipse.vjet.dsf.ts.group.GroupDependencyNode;

public class Project<T>
extends Group<T> {
    private String m_path;
    private List<String> m_classPath;
    private String m_srcPath;

    public Project(String name, IDependencyCollector<T> builder) {
        this(name, null, null, null, builder);
    }

    public Project(String name, String path, IDependencyCollector<T> builder) {
        this(name, path, null, null, builder);
    }

    public Project(String name, String path, String srcPath, List<String> classPaths, IDependencyCollector<T> builder) {
        super(name, builder);
        this.m_path = path;
        this.m_srcPath = srcPath;
        this.m_classPath = classPaths;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getSrcPath() {
        return this.m_srcPath;
    }

    public void buildGroupDependency() {
        GroupDependencyNode thisProject = this.getTypeSpace().getGroupDependencyNode(this.getName());
        if (this.m_classPath != null && this.m_classPath.size() > 0) {
            for (String path : this.m_classPath) {
                this.addGroupDependency(thisProject, path);
            }
        }
    }

    public void addGroupDependency(String dependency) {
        GroupDependencyNode thisProject = this.getTypeSpace().getGroupDependencyNode(this.getName());
        this.addGroupDependency(thisProject, dependency);
    }

    public void removeGroupDependency(String dependency) {
        GroupDependencyNode thisProject = this.getTypeSpace().getGroupDependencyNode(this.getName());
        GroupDependencyNode dependencyGroup = this.getTypeSpace().getGroupDependencyNode(dependency);
        this.removeDependency(thisProject, dependencyGroup);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    private void addGroupDependency(GroupDependencyNode thisProj, String dependency) {
        GroupDependencyNode dependencyNode = this.getTypeSpace().getGroupDependencyNode(dependency);
        if (thisProj == null) {
            throw new RuntimeException("target project is null");
        }
        if (dependencyNode == null) {
            throw new RuntimeException("dependency group is null");
        }
        thisProj.addDependency(dependencyNode);
        dependencyNode.addDependent(thisProj);
    }

    private void removeDependency(GroupDependencyNode thisProj, GroupDependencyNode dependency) {
        if (thisProj == null) {
            throw new RuntimeException("target project is null");
        }
        if (dependency == null) {
            throw new RuntimeException("dependency group is null");
        }
        thisProj.removeDependency(dependency);
        dependency.removeDependent(thisProj);
    }
}

