/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.graph.DependencyGraph;
import org.eclipse.vjet.dsf.ts.graph.DependencyNode;
import org.eclipse.vjet.dsf.ts.graph.IDependencyCollector;
import org.eclipse.vjet.dsf.ts.group.IGroup;

public class Group<E>
implements IGroup<E> {
    private final String m_name;
    private DependencyGraph<E> m_graph;
    private List<IGroup<E>> m_directGroupDependency = new CopyOnWriteArrayList<IGroup<E>>();
    private TypeSpace<E, ?> m_typeSpace;
    private final Map<String, E> m_entities;
    private final Map<String, Object> m_userObjects;
    private Map<String, E> m_aliasTypeNames;
    public static final String DEFAULT_GRP_NAME = "DefaultGroup";

    public Group(String name, IDependencyCollector<E> builder) {
        assert (name != null) : "name cannot be null";
        assert (builder != null) : "builder cannot be null";
        this.m_name = name;
        this.m_graph = new DependencyGraph<E>(builder, this);
        this.m_entities = new LinkedHashMap<String, E>();
        this.m_userObjects = new LinkedHashMap<String, Object>();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public synchronized E getEntity(String name) {
        return this.getEntities().get(name);
    }

    @Override
    public Map<String, E> getEntities() {
        return Collections.unmodifiableMap(this.m_entities);
    }

    @Override
    public DependencyGraph<E> getGraph() {
        return this.m_graph;
    }

    @Override
    public List<IGroup<E>> getGroupDependency() {
        ArrayList<IGroup<E>> all = new ArrayList<IGroup<E>>();
        this.collectDependency(this, all);
        return Collections.unmodifiableList(all);
    }

    @Override
    public List<IGroup<E>> getDirectGroupDependency() {
        return Collections.unmodifiableList(this.m_directGroupDependency);
    }

    @Override
    public boolean isDependOn(IGroup<E> group) {
        return this.isDependOn(this, group, new ArrayList<IGroup<E>>());
    }

    @Override
    public boolean isDirectlyDependOn(IGroup<E> group) {
        if (group == null) {
            return false;
        }
        if (this.m_directGroupDependency.isEmpty()) {
            return false;
        }
        return this.m_directGroupDependency.contains(group);
    }

    @Override
    public Group<E> addGroupDependency(IGroup<E> group) {
        if (group != null && !this.m_directGroupDependency.contains(group)) {
            this.m_directGroupDependency.add(group);
        }
        return this;
    }

    @Override
    public Group<E> removeGroupDependency(IGroup<?> group) {
        if (group != null) {
            this.m_directGroupDependency.remove(group);
        }
        return this;
    }

    public void setGraph(DependencyGraph<E> graph) {
        this.m_graph = graph;
    }

    public boolean addEntity(String name, E entity) {
        return this.addEntity(name, entity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserObject(String name, Object userObj) {
        Group group = this;
        synchronized (group) {
            this.m_userObjects.put(name, userObj);
        }
        return true;
    }

    public synchronized Object getUserObject(String name) {
        return this.m_userObjects.get(name);
    }

    public void setGroupNameInJstType(E type) {
        if (type instanceof JstType) {
            JstType jstType = (JstType)type;
            JstPackage jstPackage = jstType.getPackage();
            String grpName = this.getName();
            if (jstPackage == null && grpName != null) {
                jstPackage = new JstPackage();
                jstPackage.setGroupName(grpName);
                ((JstType)type).setPackage(jstPackage);
            } else if (!(jstPackage == null || jstPackage.getGroupName() != null && jstPackage.getGroupName().equals(grpName))) {
                jstPackage.setGroupName(grpName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntity(String name, E entity, boolean buildDependency) {
        Group group = this;
        synchronized (group) {
            this.m_entities.put(name, entity);
        }
        this.setGroupNameInJstType(entity);
        this.setAliasTypeNameInGroup(entity);
        DependencyNode<E> node = null;
        if (this.m_typeSpace != null) {
            node = this.m_typeSpace.getUnresolvedNodes().get(name);
        }
        if (node != null) {
            Group group2 = this;
            synchronized (group2) {
                this.m_typeSpace.removeUnresolvedNode(name);
            }
            if (node.getGraph() == null) {
                node.setGraph(this.m_graph);
            }
            node.clearAllDependencies();
            this.m_graph.addNode(name, node);
        }
        if (buildDependency) {
            this.m_graph.addToGraph(name, entity);
        }
        return true;
    }

    private void setAliasTypeNameInGroup(E entity) {
        JstType type;
        if (entity instanceof JstType && (type = (JstType)entity).getAliasTypeName() != null) {
            this.addAliasTypeName(type.getAliasTypeName(), entity);
        }
    }

    private void addAliasTypeName(String aliasTypeName, E type) {
        if (this.m_aliasTypeNames == null) {
            this.m_aliasTypeNames = new HashMap<String, E>();
        }
        this.m_aliasTypeNames.put(aliasTypeName, type);
    }

    public void addEntities(Map<String, ? extends E> entities) {
        this.addEntities(entities, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntities(Map<String, ? extends E> entities, boolean buildDependency) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        Group group = this;
        synchronized (group) {
            for (Map.Entry<String, E> entry : entities.entrySet()) {
                this.addEntity(entry.getKey(), entry.getValue(), buildDependency);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameEntity(String oldName, String newName) {
        E entity = this.getEntity(oldName);
        Object userObj = this.getUserObject(oldName);
        if (entity == null) {
            return;
        }
        Group group = this;
        synchronized (group) {
            this.m_entities.remove(oldName);
            this.m_entities.put(newName, entity);
            if (userObj != null) {
                this.m_userObjects.remove(oldName);
                this.m_userObjects.put(newName, userObj);
            }
        }
        ((DependencyGraph)this.getGraph()).renameNode(oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntity(String name) {
        E entity = this.getEntity(name);
        Object userObj = this.getUserObject(name);
        if (entity == null) {
            return;
        }
        Group group = this;
        synchronized (group) {
            this.m_entities.remove(name);
            if (userObj != null) {
                this.m_userObjects.remove(name);
            }
        }
        ((DependencyGraph)this.getGraph()).removeDependencyNode(name);
    }

    public void setTypeSpace(TypeSpace<E, ?> typeSpace) {
        this.m_typeSpace = typeSpace;
    }

    public TypeSpace<E, ?> getTypeSpace() {
        return this.m_typeSpace;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public String toString() {
        Z z = new Z();
        z.format("Group: ", (Object)this.m_name);
        z.format((Object)this.m_graph.toString());
        return z.toString();
    }

    private void collectDependency(IGroup<E> group, List<IGroup<E>> all) {
        for (IGroup<E> g : group.getDirectGroupDependency()) {
            if (g == this || all.contains(g)) continue;
            all.add(g);
            this.collectDependency(g, all);
        }
    }

    private boolean isDependOn(IGroup<E> fromGroup, IGroup<E> toGroup, List<IGroup<E>> alreadyVisited) {
        if (fromGroup == null) {
            throw new IllegalArgumentException("fromGroup is null");
        }
        if (toGroup == null) {
            return false;
        }
        if (fromGroup.equals(toGroup) || fromGroup.isDirectlyDependOn(toGroup)) {
            return true;
        }
        alreadyVisited.add(this);
        for (IGroup<E> g : fromGroup.getDirectGroupDependency()) {
            if (alreadyVisited.contains(g) || !this.isDependOn(g, toGroup, alreadyVisited)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, E> getAliasTypeNames() {
        if (this.m_aliasTypeNames == null) {
            return Collections.EMPTY_MAP;
        }
        return this.m_aliasTypeNames;
    }
}

