/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.event.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.ISourceEventListener;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventListenerHandle;
import org.eclipse.vjet.dsf.ts.event.group.GroupEvent;
import org.eclipse.vjet.dsf.ts.event.group.IGroupEventListener;

public final class AddGroupEvent
extends GroupEvent {
    private final List<String> m_classPathList;
    private final List<String> m_srcPathList;
    private final List<String> m_directDependency;
    private List<String> m_bootstrapList;
    private List<String> m_srcPathExclusionPatterns;
    private List<String> m_srcPathInclusionPatterns;

    public AddGroupEvent(String groupName, String groupPath) {
        this(groupName, groupPath, null);
    }

    public AddGroupEvent(String groupName, String groupPath, String srcPath, List<String> classPaths) {
        this(groupName, groupPath, srcPath, classPaths, null);
    }

    public AddGroupEvent(String groupName, String groupPath, List<String> srcPathList, List<String> classPaths) {
        this(groupName, groupPath, srcPathList, classPaths, null);
    }

    public AddGroupEvent(String groupName, String groupPath, List<String> directDependency) {
        super(groupName, groupPath);
        this.m_srcPathList = null;
        this.m_classPathList = null;
        this.m_directDependency = directDependency;
    }

    public AddGroupEvent(String groupName, String groupPath, String srcPath, List<String> classPaths, List<String> directDependency) {
        super(groupName, groupPath);
        this.m_srcPathList = new ArrayList<String>(1);
        this.m_srcPathList.add(srcPath);
        this.m_classPathList = classPaths;
        this.m_directDependency = directDependency;
    }

    public AddGroupEvent(String groupName, String groupPath, List<String> srcPathList, List<String> classPaths, List<String> directDependency) {
        super(groupName, groupPath);
        this.m_srcPathList = srcPathList;
        this.m_classPathList = classPaths;
        this.m_directDependency = directDependency;
    }

    public AddGroupEvent(String groupName, String groupPath, List<String> srcPathList, List<String> classPaths, List<String> directDependency, List<String> bootstrapList, List<String> inclusionList, List<String> exclusionList) {
        super(groupName, groupPath);
        this.m_srcPathList = srcPathList;
        this.m_classPathList = classPaths;
        this.m_directDependency = directDependency;
        this.m_bootstrapList = bootstrapList;
        this.m_srcPathExclusionPatterns = exclusionList;
        this.m_srcPathInclusionPatterns = inclusionList;
    }

    public AddGroupEvent(String groupName, String groupPath, List<String> srcPathList, List<String> classPaths, List<String> directDependency, List<String> bootstrapList) {
        this(groupName, groupPath, srcPathList, classPaths, directDependency, bootstrapList, null, null);
    }

    public boolean addSrcPath(String srcPath) {
        if (this.m_srcPathList != null) {
            return this.m_srcPathList.add(srcPath);
        }
        return false;
    }

    public boolean addSrcPathExclusionRule(String excludePattern) {
        if (this.m_srcPathExclusionPatterns != null) {
            return this.m_srcPathExclusionPatterns.add(excludePattern);
        }
        return false;
    }

    public boolean addClassPath(String classPath) {
        if (this.m_classPathList != null) {
            return this.m_classPathList.add(classPath);
        }
        return false;
    }

    @Override
    public void dispatch(ISourceEventListener listener) {
        if (listener == null) {
            return;
        }
        ((IGroupEventListener)listener).onGroupAdded(this, null, null);
    }

    @Override
    public void dispatch(ISourceEventListener listener, IEventListenerHandle handle, ISourceEventCallback callback) {
        if (listener == null) {
            return;
        }
        ((IGroupEventListener)listener).onGroupAdded(this, handle, callback);
    }

    public String getSourcePath() {
        if (this.m_srcPathList != null && this.m_srcPathList.size() > 0) {
            return this.m_srcPathList.get(0);
        }
        return null;
    }

    public List<String> getSourcePathList() {
        return this.m_srcPathList;
    }

    public List<String> getBootStrapList() {
        return this.m_bootstrapList;
    }

    public List<String> getClassPath() {
        return this.m_classPathList;
    }

    public List<String> getDirectDependency() {
        if (this.m_directDependency == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_directDependency);
    }

    @Override
    public boolean shouldLock() {
        return false;
    }

    public List<String> getSrcPathInclusionPatterns() {
        return this.m_srcPathInclusionPatterns;
    }

    public List<String> getSrcPathExclusionPatterns() {
        return this.m_srcPathExclusionPatterns;
    }

    public void setSrcPathInclusionPatterns(List<String> m_srcPathInclusionPatterns) {
        this.m_srcPathInclusionPatterns = m_srcPathInclusionPatterns;
    }
}

