/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.ts.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;

public class EventListenerStatus<D> {
    private final Code m_code;
    private final String m_msg;
    private final D m_data;
    private List<ErrorSource> m_errSrcList;

    public EventListenerStatus(Code code) {
        this(code, null, null);
    }

    public EventListenerStatus(Code code, String msg) {
        this(code, msg, null);
    }

    public EventListenerStatus(Code code, D data) {
        this(code, null, data);
    }

    public EventListenerStatus(Code code, String msg, D data) {
        this.m_code = code;
        this.m_msg = msg;
        this.m_data = data;
    }

    public Code getCode() {
        return this.m_code;
    }

    public String getMsg() {
        return this.m_msg;
    }

    public D getData() {
        return this.m_data;
    }

    public void addErrorSource(ErrorSource source) {
        if (this.m_errSrcList == null) {
            this.m_errSrcList = new ArrayList<ErrorSource>();
        }
        this.m_errSrcList.add(source);
    }

    public List<ErrorSource> getErrorSourceList() {
        return this.m_errSrcList;
    }

    public static enum Code {
        NoOp,
        Started,
        Successful,
        Incomplete,
        Failed,
        Exception,
        Interrupted;

    }

    public static class ErrorSource {
        private final String m_source;
        private final String m_errMsg;
        private final Throwable m_exception;

        public ErrorSource(String source, String error, Throwable e) {
            this.m_source = source;
            this.m_errMsg = error;
            this.m_exception = e;
        }

        public String getSource() {
            return this.m_source;
        }

        public String getErrMsg() {
            return this.m_errMsg;
        }

        public Throwable getException() {
            return this.m_exception;
        }

        public String toString() {
            Z z = new Z();
            z.format("m_source", (Object)this.m_source);
            z.format("m_error", (Object)this.m_errMsg);
            if (this.m_exception != null) {
                z.format("m_exception", (Object)this.m_exception.getMessage());
            }
            return z.toString();
        }
    }
}

