/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jsnative.anno.JsNativeMeta;
import org.eclipse.vjet.dsf.jsnative.global.Boolean;
import org.eclipse.vjet.dsf.jsnative.global.Date;
import org.eclipse.vjet.dsf.jsnative.global.Number;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jsnative.global.String;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.datatype.JstReservedTypes;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class DataTypeHelper {
    private static Set<java.lang.String> s_primitiveTypes = new HashSet<java.lang.String>();
    private static final List<java.lang.String> s_numericPrimitiveTypes;
    private static final List<java.lang.String> s_numericWrapperTypes;
    private static final Map<java.lang.String, JstType> s_wrapperToPrimitiveTypes;
    private static final List<java.lang.String> s_stringTypes;
    private static List<java.lang.String> s_javaLangType;
    private static final Map<java.lang.String, Class<?>> s_primitiveClasses;
    private static final Map<java.lang.String, java.lang.String> s_javaToNativeMap;

    static {
        s_primitiveTypes.add("boolean");
        s_primitiveTypes.add("PrimitiveBoolean");
        s_primitiveTypes.add("byte");
        s_primitiveTypes.add("short");
        s_primitiveTypes.add("int");
        s_primitiveTypes.add("long");
        s_primitiveTypes.add("float");
        s_primitiveTypes.add("double");
        s_primitiveTypes.add("char");
        s_primitiveTypes.add("String");
        s_primitiveTypes.add("void");
        s_numericPrimitiveTypes = new ArrayList<java.lang.String>();
        s_numericPrimitiveTypes.add("byte");
        s_numericPrimitiveTypes.add("short");
        s_numericPrimitiveTypes.add("int");
        s_numericPrimitiveTypes.add("float");
        s_numericPrimitiveTypes.add("long");
        s_numericPrimitiveTypes.add("double");
        s_numericWrapperTypes = new ArrayList<java.lang.String>();
        s_numericWrapperTypes.add("Byte");
        s_numericWrapperTypes.add("Short");
        s_numericWrapperTypes.add("Integer");
        s_numericWrapperTypes.add("Float");
        s_numericWrapperTypes.add("Long");
        s_numericWrapperTypes.add("Double");
        s_wrapperToPrimitiveTypes = new HashMap<java.lang.String, JstType>();
        s_wrapperToPrimitiveTypes.put("Boolean", JstReservedTypes.JavaPrimitive.BOOLEAN);
        s_wrapperToPrimitiveTypes.put("Byte", JstReservedTypes.JavaPrimitive.BYTE);
        s_wrapperToPrimitiveTypes.put("Short", JstReservedTypes.JavaPrimitive.SHORT);
        s_wrapperToPrimitiveTypes.put("Character", JstReservedTypes.JavaPrimitive.CHAR);
        s_wrapperToPrimitiveTypes.put("Integer", JstReservedTypes.JavaPrimitive.INT);
        s_wrapperToPrimitiveTypes.put("Float", JstReservedTypes.JavaPrimitive.FLOAT);
        s_wrapperToPrimitiveTypes.put("Long", JstReservedTypes.JavaPrimitive.LONG);
        s_wrapperToPrimitiveTypes.put("Double", JstReservedTypes.JavaPrimitive.DOUBLE);
        s_stringTypes = new ArrayList<java.lang.String>();
        s_stringTypes.add("String");
        s_javaLangType = new ArrayList<java.lang.String>();
        s_javaLangType.add(java.lang.Boolean.class.getSimpleName());
        s_javaLangType.add(Byte.class.getSimpleName());
        s_javaLangType.add(Short.class.getSimpleName());
        s_javaLangType.add(Integer.class.getSimpleName());
        s_javaLangType.add(Long.class.getSimpleName());
        s_javaLangType.add(Float.class.getSimpleName());
        s_javaLangType.add(Double.class.getSimpleName());
        s_javaLangType.add(java.lang.Number.class.getSimpleName());
        s_javaLangType.add(Character.class.getSimpleName());
        s_javaLangType.add(java.lang.String.class.getSimpleName());
        s_javaLangType.add(Void.class.getSimpleName());
        s_javaLangType.add(java.lang.Object.class.getSimpleName());
        s_javaLangType.add(Class.class.getSimpleName());
        s_javaLangType.add(Enum.class.getSimpleName());
        s_javaLangType.add(Math.class.getSimpleName());
        s_javaLangType.add(StringBuffer.class.getSimpleName());
        s_javaLangType.add(StringBuilder.class.getSimpleName());
        s_javaLangType.add(System.class.getSimpleName());
        s_javaLangType.add(Throwable.class.getSimpleName());
        s_javaLangType.add(Exception.class.getSimpleName());
        s_javaLangType.add(RuntimeException.class.getSimpleName());
        s_javaLangType.add(Error.class.getSimpleName());
        s_javaLangType.add(ArithmeticException.class.getSimpleName());
        s_javaLangType.add(ArrayIndexOutOfBoundsException.class.getSimpleName());
        s_javaLangType.add(ArrayStoreException.class.getSimpleName());
        s_javaLangType.add(ClassCastException.class.getSimpleName());
        s_javaLangType.add(ClassNotFoundException.class.getSimpleName());
        s_javaLangType.add(CloneNotSupportedException.class.getSimpleName());
        s_javaLangType.add(EnumConstantNotPresentException.class.getSimpleName());
        s_javaLangType.add(IllegalAccessException.class.getSimpleName());
        s_javaLangType.add(IllegalArgumentException.class.getSimpleName());
        s_javaLangType.add(IllegalMonitorStateException.class.getSimpleName());
        s_javaLangType.add(IllegalStateException.class.getSimpleName());
        s_javaLangType.add(IndexOutOfBoundsException.class.getSimpleName());
        s_javaLangType.add(InstantiationException.class.getSimpleName());
        s_javaLangType.add(NegativeArraySizeException.class.getSimpleName());
        s_javaLangType.add(NullPointerException.class.getSimpleName());
        s_javaLangType.add(NumberFormatException.class.getSimpleName());
        s_javaLangType.add(StringIndexOutOfBoundsException.class.getSimpleName());
        s_javaLangType.add(AbstractMethodError.class.getSimpleName());
        s_javaLangType.add(AssertionError.class.getSimpleName());
        s_primitiveClasses = new HashMap(10);
        s_primitiveClasses.put(java.lang.String.class.getSimpleName(), java.lang.String.class);
        s_primitiveClasses.put(java.lang.Number.class.getSimpleName(), java.lang.Number.class);
        s_primitiveClasses.put(Integer.TYPE.getSimpleName(), Integer.TYPE);
        s_primitiveClasses.put(Void.TYPE.getSimpleName(), Void.TYPE);
        s_primitiveClasses.put(java.lang.Boolean.TYPE.getSimpleName(), java.lang.Boolean.TYPE);
        s_primitiveClasses.put(Short.TYPE.getSimpleName(), Short.TYPE);
        s_primitiveClasses.put(Long.TYPE.getSimpleName(), Long.TYPE);
        s_primitiveClasses.put(Float.TYPE.getSimpleName(), Float.TYPE);
        s_primitiveClasses.put(Double.TYPE.getSimpleName(), Double.TYPE);
        s_primitiveClasses.put(Character.TYPE.getSimpleName(), Character.TYPE);
        s_primitiveClasses.put(Byte.TYPE.getSimpleName(), Byte.TYPE);
        s_javaToNativeMap = new HashMap<java.lang.String, java.lang.String>(10);
        s_javaToNativeMap.put(java.lang.Object.class.getName(), Object.class.getName());
        s_javaToNativeMap.put(java.lang.String.class.getName(), String.class.getName());
        s_javaToNativeMap.put(java.lang.Boolean.class.getName(), Boolean.class.getName());
        s_javaToNativeMap.put(java.util.Date.class.getName(), Date.class.getName());
        s_javaToNativeMap.put(java.lang.Number.class.getName(), Number.class.getName());
    }

    public static boolean isPrimitiveType(java.lang.String name) {
        return s_primitiveTypes.contains(name);
    }

    public static boolean isPrimitiveType(IJstType type) {
        JstType jstType = JstTypeHelper.getJstType(type);
        return jstType == null ? false : s_primitiveTypes.contains(jstType.getSimpleName());
    }

    public static boolean isBooleanPrimitiveType(IJstType type) {
        JstType jstType = JstTypeHelper.getJstType(type);
        return jstType == null ? false : "boolean".equals(jstType.getSimpleName());
    }

    public static boolean isBooleanWrapperType(IJstType type) {
        JstType jstType = JstTypeHelper.getJstType(type);
        return jstType == null ? false : "Boolean".equals(jstType.getSimpleName());
    }

    public static boolean isNumericPrimitiveType(IJstType type) {
        JstType jstType = JstTypeHelper.getJstType(type);
        return jstType == null ? false : s_numericPrimitiveTypes.contains(jstType.getSimpleName());
    }

    public static boolean isNumericWrapperType(IJstType type) {
        JstType jstType = JstTypeHelper.getJstType(type);
        return jstType == null ? false : s_numericWrapperTypes.contains(jstType.getSimpleName());
    }

    public static boolean isCharPrimitiveType(IJstType type) {
        JstType jstType = JstTypeHelper.getJstType(type);
        return jstType == null ? false : "char".equals(jstType.getSimpleName());
    }

    public static boolean isCharWrapperType(IJstType type) {
        JstType jstType = JstTypeHelper.getJstType(type);
        return jstType == null ? false : "Character".equals(jstType.getSimpleName());
    }

    public static JstType getPrimitivetype(IJstType wrapperType) {
        return wrapperType == null ? null : s_wrapperToPrimitiveTypes.get(wrapperType.getSimpleName());
    }

    public static boolean isString(IJstType type) {
        JstType jstType = JstTypeHelper.getJstType(type);
        return jstType == null ? false : s_stringTypes.contains(jstType.getSimpleName());
    }

    public static boolean isInJavaLang(java.lang.String name) {
        return s_javaLangType.contains(name);
    }

    public static boolean isInJDK(java.lang.String name) {
        return name != null && name.startsWith("java.");
    }

    public static java.lang.String getDefaultValue(java.lang.String name) {
        if ("boolean".equals(name)) {
            return "false";
        }
        if ("char".equals(name)) {
            return "\"\"";
        }
        if (s_numericPrimitiveTypes.contains(name)) {
            return "0";
        }
        return null;
    }

    public static boolean canPromote(IJstType aType, IJstType bType) {
        JstType jstTypeA = JstTypeHelper.getJstType(aType);
        JstType jstTypeB = JstTypeHelper.getJstType(bType);
        if (DataTypeHelper.isNumericPrimitiveType(jstTypeA) && DataTypeHelper.isNumericPrimitiveType(jstTypeB)) {
            int indexA = -1;
            int indexB = -1;
            int i = 0;
            while (i < s_numericPrimitiveTypes.size()) {
                if (s_numericPrimitiveTypes.get(i).equals(jstTypeA.getSimpleName())) {
                    indexA = i;
                }
                if (s_numericPrimitiveTypes.get(i).equals(jstTypeB.getSimpleName())) {
                    indexB = i;
                }
                ++i;
            }
            return indexA < indexB;
        }
        return false;
    }

    public static java.lang.String getWrapperTypeName(java.lang.String str, boolean fullName) {
        if (str.equals("boolean")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Boolean";
            }
            return "Boolean";
        }
        if (str.equals("byte")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Byte";
            }
            return "Byte";
        }
        if (str.equals("char")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Character";
            }
            return "Character";
        }
        if (str.equals("short")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Short";
            }
            return "Short";
        }
        if (str.equals("int")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Integer";
            }
            return "Integer";
        }
        if (str.equals("long")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Long";
            }
            return "Long";
        }
        if (str.equals("float")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Float";
            }
            return "Float";
        }
        if (str.equals("double")) {
            if (fullName) {
                return "org.eclipse.vjet.vjo.java.lang.Double";
            }
            return "Double";
        }
        return null;
    }

    public static Class<?> getPrimitiveClass(java.lang.String name) {
        return s_primitiveClasses.get(name);
    }

    public static boolean isJavaMappedToNative(java.lang.String javaName) {
        return s_javaToNativeMap.containsKey(javaName);
    }

    public static java.lang.String getTypeName(java.lang.String javaName) {
        java.lang.String name = javaName;
        if (s_javaToNativeMap.containsKey(javaName)) {
            name = s_javaToNativeMap.get(javaName);
        }
        if (DataTypeHelper.getNativeType(name) != null) {
            java.lang.String alias = JsNativeMeta.getNativeTypeAlias((java.lang.String)javaName);
            if (alias == null) {
                if (name.indexOf(".") > 0) {
                    name = name.substring(name.lastIndexOf(".") + 1);
                }
            } else {
                name = alias;
            }
        }
        return name;
    }

    public static java.lang.String getJavaTypeNameForNative(java.lang.String nativeTypeName) {
        if (nativeTypeName != null && s_javaToNativeMap.containsValue(nativeTypeName)) {
            for (Map.Entry<java.lang.String, java.lang.String> itm : s_javaToNativeMap.entrySet()) {
                if (!nativeTypeName.equals(itm.getValue())) continue;
                return itm.getKey();
            }
        }
        return null;
    }

    public static Class<?> getNativeType(java.lang.String name) {
        return JsNativeMeta.getNativeClass((java.lang.String)name);
    }
}

