/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.ts.AJstSymbolTableMgr;
import org.eclipse.vjet.dsf.jst.ts.JstQueryExecutor;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexMap;
import org.eclipse.vjet.dsf.ts.index.DependencyIndexNode;
import org.eclipse.vjet.dsf.ts.property.PropertyIndex;
import org.eclipse.vjet.dsf.ts.property.PropertyName;
import org.eclipse.vjet.dsf.ts.type.ISymbolName;
import org.eclipse.vjet.dsf.ts.type.TypeName;

final class PropertyIndexMgr
extends AJstSymbolTableMgr<PropertyName> {
    PropertyIndexMgr(TypeSpace<IJstType, IJstNode> ts, JstQueryExecutor executor) {
        super(ts, executor);
    }

    @Override
    protected Map<PropertyName, List<IJstNode>> findSymbolUsagesWithinType(IJstType type) {
        return this.m_qe.findPropertyUsagesWithinNode(type);
    }

    @Override
    protected DependencyIndexMap<IJstNode> createIndex(IJstType type) {
        return new PropertyIndex(type);
    }

    @Override
    protected void addDanglingReferencesToSymbol(ISymbolName symbol, DependencyIndexNode<IJstNode> indexnode) {
        this.m_ts.addToUnresolvedIndexNode((PropertyName)symbol, indexnode);
    }

    @Override
    protected IJstNode getSymbolNode(ISymbolName symbol, boolean isStatic) {
        TypeName typeName = new TypeName(symbol.getGroupName(), symbol.getOwnerTypeName());
        IJstType type = (IJstType)this.m_ts.getType(typeName);
        if (type == null) {
            throw new RuntimeException("cannot find type for type:" + type);
        }
        return type.getProperty(symbol.getLocalName(), isStatic, false);
    }

    @Override
    protected boolean isSymbolInType(IJstType type, String symbol) {
        return type.getProperty(symbol) != null;
    }

    @Override
    protected Map<? extends ISymbolName, List<IJstNode>> getMethodUsages(IJstNode n) {
        IJstProperty pty;
        IExpr initializer;
        if (n instanceof IJstProperty && (initializer = (pty = (IJstProperty)n).getInitializer()) != null) {
            n = initializer;
        }
        return this.m_qe.findMethodUsagesWithinNode(n);
    }

    @Override
    protected Map<? extends ISymbolName, List<IJstNode>> getPropertyUsages(IJstNode n) {
        IJstProperty pty;
        IExpr initializer;
        if (n instanceof IJstProperty && (initializer = (pty = (IJstProperty)n).getInitializer()) != null) {
            n = initializer;
        }
        return this.m_qe.findPropertyUsagesWithinNode(n);
    }

    void removeProperty(PropertyName ptyName, boolean isStatic) {
        this.removeSymbol(ptyName, isStatic);
    }

    void addProperty(PropertyName ptyName, boolean isStatic, IJstProperty pty) {
        TypeName typeName = ptyName.typeName();
        IJstType type = (IJstType)this.m_ts.getType(typeName);
        if (type == null) {
            throw new RuntimeException("cannot find type for type:" + typeName);
        }
        DependencyIndexMap index = this.getTypeIndex(typeName, true, true);
        DependencyIndexNode node = this.m_ts.getUnresolvedIndexNode(ptyName);
        if (index != null && node != null) {
            index.addEntity(node);
        }
        Map propertyUsageMap = this.getPropertyUsages(pty);
        this.addReferencesUsedByType(type, propertyUsageMap);
        Map methodUsageMap = this.getMethodUsages(pty);
        this.m_ts.getMethodSymbolTableManager().addReferencesUsedByType(type, methodUsageMap);
    }
}

