/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.ts;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeDependencyCollector;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeDependencyHelper;
import org.eclipse.vjet.dsf.jst.ts.util.JstTypeSerializer;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.group.Group;

class JstResourceMgr {
    private boolean m_initialized = false;
    private JstTypeSpaceMgr m_tsMgr;
    private TypeSpace<IJstType, IJstNode> m_ts;

    JstResourceMgr(JstTypeSpaceMgr tsMgr) {
        assert (tsMgr != null) : "tsMgr cannot be null";
        this.m_tsMgr = tsMgr;
        this.m_ts = this.m_tsMgr.getTypeSpaceImpl();
    }

    public boolean initialize() {
        if (!this.m_initialized) {
            this.m_initialized = true;
        }
        return this.m_initialized;
    }

    public void loadLibrary(InputStream is, String grpName) {
        if (this.m_ts == null) {
            return;
        }
        Group<IJstType> group = new Group<IJstType>(grpName, new JstTypeDependencyCollector());
        this.m_ts.addGroup(group);
        group.addEntities(JstTypeDependencyHelper.toMap(JstTypeSerializer.getInstance().deserialize(is)));
    }

    public void loadLibrary(IJstLib lib, String grpName) {
        if (this.m_ts == null) {
            return;
        }
        Group<IJstType> group = new Group<IJstType>(grpName, new JstTypeDependencyCollector());
        this.m_ts.addGroup(group);
        LinkedHashMap<String, IJstType> map = new LinkedHashMap<String, IJstType>();
        for (JstType t : lib.getAllTypes(true)) {
            group.setGroupNameInJstType(t);
            map.put(t.getName(), t);
            List<JstType> innerTypes = t.getEmbededTypes();
            if (innerTypes == null) continue;
            for (IJstType iJstType : innerTypes) {
                map.put(iJstType.getName(), iJstType);
            }
        }
        group.addEntities(map);
    }

    public void persistTypeSpace() {
        if (!this.m_tsMgr.getConfig().shouldPersistTypeSpace()) {
            return;
        }
        if (this.m_ts == null) {
            return;
        }
        this.persistGroups(this.m_ts.getGroups().values());
    }

    private void persistGroups(Collection<Group<IJstType>> groups) {
    }
}

