/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.term;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstProxyIdentifier
extends JstIdentifier {
    private static final long serialVersionUID = 1L;
    private IExpr m_actualExpr;

    public JstProxyIdentifier(IExpr actualExpr) {
        this(actualExpr, null);
    }

    public JstProxyIdentifier(IExpr actualExpr, JstProxyIdentifier qualifier) {
        super("proxy", qualifier);
        this.setActualExpr(actualExpr);
    }

    public IExpr getActualExpr() {
        return this.m_actualExpr;
    }

    public void setActualExpr(IExpr actualExpr) {
        if (this.m_actualExpr != null) {
            this.removeChild(this.m_actualExpr);
        }
        this.m_actualExpr = actualExpr;
        this.addChild(this.m_actualExpr);
        if (actualExpr != null) {
            if (actualExpr instanceof BaseJstNode) {
                this.setSource(((BaseJstNode)((Object)actualExpr)).getSource());
            }
            if (actualExpr instanceof JstIdentifier) {
                this.setName(((JstIdentifier)actualExpr).getName());
            }
        }
    }

    @Override
    public String toSimpleTermText() {
        String text;
        StringBuilder sb = new StringBuilder();
        String q = null;
        if (this.getQualifier() != null) {
            q = this.getQualifier().toSimpleTermText();
        }
        if (q != null) {
            sb.append(q);
        }
        if (q != null && this.m_actualExpr != null) {
            sb.append(".");
        }
        if (this.m_actualExpr != null) {
            sb.append(this.m_actualExpr.toExprText());
        }
        return (text = sb.toString()).length() > 0 ? text : null;
    }

    @Override
    public IJstType getType() {
        return super.getType();
    }

    @Override
    public String toLHSText() {
        return this.toSimpleTermText();
    }

    @Override
    public IJstType getResultType() {
        return this.getType();
    }

    @Override
    public String toExprText() {
        return this.toSimpleTermText();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void setQualifier(JstIdentifier qualifier) {
        super.setQualifier(qualifier);
    }

    @Override
    public JstIdentifier getQualifier() {
        return super.getQualifier();
    }

    @Override
    public JstIdentifier setType(IJstType type) {
        return super.setType(type);
    }

    @Override
    public void setJstBinding(IJstNode binding) {
        super.setJstBinding(binding);
    }

    @Override
    public IJstNode getJstBinding() {
        return super.getJstBinding();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

