/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstResultTypeModifier;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class PostfixExpr
extends ArithExpr
implements IJstResultTypeModifier {
    private static final long serialVersionUID = 1L;
    private IExpr m_term;
    private Operator m_op;
    private IJstType m_type;
    private boolean m_isLastTerm = true;

    public PostfixExpr(IExpr term, Operator op) {
        assert (term != null) : "term cannot be null";
        assert (op != null) : "op cannot be null";
        this.m_term = term;
        this.m_op = op;
        this.addChild(term);
    }

    @Override
    public IJstType getResultType() {
        if (this.m_type == null) {
            this.m_type = this.m_term.getResultType();
            if (this.m_op == Operator.INCREMENT || this.m_op == Operator.DECREMENT) {
                JstType nativeNumber = JstCache.getInstance().getType("Number");
                if (nativeNumber != null) {
                    if (this.m_type != null && this.m_type != nativeNumber && this.m_type.getExtend() != nativeNumber) {
                        this.m_type = nativeNumber;
                    }
                } else {
                    this.m_type = JstTypeHelper.getPrimitiveType(this.m_term);
                }
            }
        }
        return this.m_type;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        if (this.m_term != null) {
            sb.append(this.m_term.toExprText());
        }
        sb.append(this.m_op.toString());
        if (!this.m_isLastTerm) {
            sb.append(" ");
        }
        return sb.toString();
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    public void setOperand(IExpr operand) {
        this.removeChild(this.m_term);
        this.m_term = operand;
        this.addChild(this.m_term);
    }

    public IExpr getIdentifier() {
        return this.m_term;
    }

    public Operator getOperator() {
        return this.m_op;
    }

    public boolean isLastTerm() {
        return this.m_isLastTerm;
    }

    public void setIsLastTerm(boolean isLastTerm) {
        this.m_isLastTerm = isLastTerm;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }

    @Override
    public void setType(IJstType type) {
        this.m_type = type;
    }

    public static class Operator
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String token;
        public static final Operator INCREMENT = new Operator("++");
        public static final Operator DECREMENT = new Operator("--");
        private static final Map<String, Operator> CODES = new HashMap<String, Operator>(20);

        static {
            Operator[] ops = new Operator[]{INCREMENT, DECREMENT};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return CODES.get(token);
        }
    }
}

