/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public final class ListExpr
extends BaseJstNode
implements IExpr,
IStmt {
    private static final long serialVersionUID = 1L;
    private final IExpr[] m_exprTerms;

    public ListExpr(IExpr[] exprTerms) {
        this.m_exprTerms = exprTerms;
        IExpr[] iExprArray = exprTerms;
        int n = exprTerms.length;
        int n2 = 0;
        while (n2 < n) {
            IExpr expr = iExprArray[n2];
            this.addChild(expr);
            ++n2;
        }
    }

    public IExpr[] getExprTerms() {
        return this.m_exprTerms;
    }

    @Override
    public IJstType getResultType() {
        return null;
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.m_exprTerms.length) {
            sb.append(this.m_exprTerms[i].toExprText());
            if (i != this.m_exprTerms.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }
}

