/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.expr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class ArrayCreationExpr
extends BaseJstNode
implements IExpr {
    private static final long serialVersionUID = 1L;
    private final IExpr m_identifier;
    private final List<IExpr> m_dimensions = new ArrayList<IExpr>();

    public ArrayCreationExpr(IExpr identifier) {
        assert (identifier != null) : "identifier cannot be null";
        this.m_identifier = identifier;
        this.addChild(identifier);
    }

    public void addDimension(IExpr dimension) {
        this.m_dimensions.add(dimension);
        this.addChild(dimension);
    }

    public List<IExpr> getDimensions() {
        return this.m_dimensions;
    }

    @Override
    public IJstType getResultType() {
        return this.m_identifier == null ? null : this.m_identifier.getResultType();
    }

    @Override
    public String toExprText() {
        StringBuilder sb = new StringBuilder("vjo.createArray(");
        sb.append(this.getDefaultValString());
        for (IExpr d : this.m_dimensions) {
            if (d == null) continue;
            sb.append(", ").append(d.toExprText());
        }
        sb.append(")");
        return sb.toString();
    }

    private String getDefaultValString() {
        String dType = this.m_identifier.toExprText().replace("[]", "");
        String type = DataTypeHelper.getDefaultValue(dType);
        if (type == null) {
            type = "null";
        }
        return type;
    }

    public String toStmtText() {
        return String.valueOf(this.toExprText()) + ";";
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toExprText();
    }
}

