/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class VarTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, IJstType> m_varTypes;
    private Map<String, IJstNode> m_varNodes;
    private Map<String, JstType> m_localTypes;
    public static IVarTableEntryViewer SAME_SCOPE_VIEWER = new IVarTableEntryViewer(){

        @Override
        public IJstNode view(IJstNode varNode, boolean visibleFromSameScope) {
            return visibleFromSameScope ? varNode : null;
        }
    };

    public void addVarNode(String name, IJstNode node) {
        if (this.m_varNodes == null) {
            this.m_varNodes = new HashMap<String, IJstNode>(8);
        }
        this.m_varNodes.put(name, node);
    }

    public IJstNode getVarNode(String name) {
        return this.m_varNodes != null ? this.m_varNodes.get(name) : null;
    }

    public Map<String, IJstNode> getVarNodes() {
        return this.getVarNodes(SAME_SCOPE_VIEWER);
    }

    public Map<String, IJstNode> getVarNodes(IVarTableEntryViewer viewer) {
        if (this.m_varNodes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, IJstNode> varNodes = new HashMap<String, IJstNode>(this.m_varNodes.size());
        for (Map.Entry<String, IJstNode> varEntry : this.m_varNodes.entrySet()) {
            IJstNode value = varEntry.getValue();
            varNodes.put(varEntry.getKey(), value);
        }
        return varNodes;
    }

    public void addVarType(String name, IJstType type) {
        if (this.m_varTypes == null) {
            this.m_varTypes = new LinkedHashMap<String, IJstType>(2);
        }
        this.m_varTypes.put(name, type);
    }

    public IJstType getVarType(String name) {
        return this.m_varTypes != null ? this.m_varTypes.get(name) : null;
    }

    public void addLocalType(String name, JstType type) {
        if (this.m_localTypes == null) {
            this.m_localTypes = new LinkedHashMap<String, JstType>(2);
        }
        this.m_localTypes.put(name, type);
    }

    public boolean hasLocalType(String name) {
        return this.m_localTypes != null ? this.m_localTypes.containsKey(name) : false;
    }

    public JstType getLocalType(String name) {
        return this.m_localTypes != null ? this.m_localTypes.get(name) : null;
    }

    public Set<String> getVars() {
        if (this.m_varTypes == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.m_varTypes.keySet());
    }

    public Map<String, IJstType> getVarTypes() {
        if (this.m_varTypes == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.m_varTypes);
    }

    public String toString() {
        Z z = new Z();
        if (this.m_varTypes != null && this.m_varTypes.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, IJstType> entry : this.m_varTypes.entrySet()) {
                sb.append("\n\t").append(entry.getKey()).append(" ").append(entry.getValue().getName());
            }
            z.format("m_varTypes", (Object)sb.toString());
        }
        return z.toString();
    }

    public static interface IVarTableEntryViewer {
        public IJstNode view(IJstNode var1, boolean var2);
    }
}

