/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;

public class TopLevelVarTable
extends VarTable {
    private static final long serialVersionUID = 1L;
    private List<IJstType> m_includedTypes = new ArrayList<IJstType>();

    public TopLevelVarTable addIncludedType(IJstType type) {
        this.m_includedTypes.add(type);
        return this;
    }

    @Override
    public IJstNode getVarNode(String name) {
        IJstNode node = super.getVarNode(name);
        if (node != null) {
            return node;
        }
        for (IJstType t : this.m_includedTypes) {
            node = t.getInitBlock().getVarTable().getVarNode(name);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public IJstNode getSelfVarNode(String name) {
        IJstNode node = super.getVarNode(name);
        if (node != null) {
            return node;
        }
        return null;
    }

    public Map<String, IJstNode> getSelfVarNodes() {
        return super.getVarNodes();
    }

    @Override
    public Map<String, IJstNode> getVarNodes() {
        LinkedHashMap<String, IJstNode> merged = new LinkedHashMap<String, IJstNode>();
        merged.putAll(super.getVarNodes());
        for (IJstType t : this.m_includedTypes) {
            merged.putAll(t.getInitBlock().getVarTable().getVarNodes());
        }
        return merged;
    }

    public List<VarTable> getLinkedVarTables() {
        LinkedList<VarTable> linkedVarTables = new LinkedList<VarTable>();
        for (IJstType t : this.m_includedTypes) {
            linkedVarTables.add(t.getInitBlock().getVarTable());
        }
        return linkedVarTables;
    }

    @Override
    public IJstType getVarType(String name) {
        IJstType varType = super.getVarType(name);
        if (varType != null) {
            return varType;
        }
        for (IJstType t : this.m_includedTypes) {
            varType = t.getInitBlock().getVarTable().getVarType(name);
            if (varType == null) continue;
            return varType;
        }
        return null;
    }

    @Override
    public Set<String> getVars() {
        LinkedHashSet<String> merged = new LinkedHashSet<String>();
        merged.addAll(super.getVars());
        for (IJstType t : this.m_includedTypes) {
            merged.addAll(t.getInitBlock().getVarTable().getVars());
        }
        return merged;
    }

    @Override
    public Map<String, IJstType> getVarTypes() {
        LinkedHashMap<String, IJstType> merged = new LinkedHashMap<String, IJstType>();
        merged.putAll(super.getVarTypes());
        for (IJstType t : this.m_includedTypes) {
            merged.putAll(t.getInitBlock().getVarTable().getVarTypes());
        }
        return merged;
    }
}

