/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class JstProperty
extends BaseJstNode
implements IJstProperty {
    private static final long serialVersionUID = 1L;
    private final JstTypeReference m_type;
    private JstName m_name;
    private JstModifiers m_modifiers;
    private ISimpleTerm m_value;
    private IExpr m_initializer;
    private IJstDoc m_doc;

    public JstProperty(IJstType type, String name) {
        this(type, name, (JstIdentifier)null, new JstModifiers());
    }

    public JstProperty(IJstType type, String name, JstIdentifier value) {
        this(type, name, value, new JstModifiers());
    }

    public JstProperty(IJstType type, String name, JstLiteral value) {
        this(type, name, value, new JstModifiers());
    }

    public JstProperty(IJstType type, String name, JstModifiers modifiers) {
        this(type, new JstName(name), (JstIdentifier)null, modifiers);
    }

    public JstProperty(IJstType type, String name, JstIdentifier value, JstModifiers modifiers) {
        this(type, new JstName(name), value, modifiers);
    }

    public JstProperty(IJstType type, JstName name, JstIdentifier value, JstModifiers modifiers) {
        this(type, name, modifiers, value, null);
    }

    public JstProperty(IJstType type, String name, JstLiteral value, JstModifiers modifiers) {
        this(type, new JstName(name), value, modifiers);
    }

    public JstProperty(IJstType type, JstName name, JstLiteral value, JstModifiers modifiers) {
        this(type, name, modifiers, value, null);
    }

    public JstProperty(IJstType type, String name, IExpr initializer, JstModifiers modifiers) {
        this(type, new JstName(name), initializer, modifiers);
    }

    public JstProperty(IJstType type, JstName name, IExpr initializer, JstModifiers modifiers) {
        this(type, name, modifiers, null, initializer);
    }

    protected JstProperty(IJstType type, JstName name, JstModifiers modifiers, ISimpleTerm value, IExpr expr) {
        assert (type != null) : "type cannot be null";
        assert (name != null) : "name cannot be null";
        assert (modifiers != null) : "modifiers cannot be null";
        this.m_type = new JstTypeReference(type);
        this.m_name = name;
        this.m_value = value;
        this.m_initializer = expr;
        this.m_modifiers = modifiers;
        this.addChild(name);
        if (value != null) {
            this.addChild(value);
        }
        if (expr != null) {
            this.addChild(expr);
        }
        this.addChild(this.m_type);
    }

    @Override
    public IJstType getType() {
        return this.m_type == null ? null : this.m_type.getReferencedType();
    }

    @Override
    public IJstTypeReference getTypeRef() {
        return this.m_type;
    }

    @Override
    public JstName getName() {
        return this.m_name;
    }

    @Override
    public JstModifiers getModifiers() {
        return this.m_modifiers;
    }

    public void setModifiers(JstModifiers modifiers) {
        this.m_modifiers = modifiers;
    }

    @Override
    public boolean isPublic() {
        return this.m_modifiers.isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.m_modifiers.isProtected();
    }

    @Override
    public boolean isInternal() {
        return this.m_modifiers.isInternal();
    }

    @Override
    public boolean isPrivate() {
        return this.m_modifiers.isPrivate();
    }

    @Override
    public boolean isStatic() {
        return this.m_modifiers.isStatic();
    }

    @Override
    public boolean isFinal() {
        return this.m_modifiers.isFinal();
    }

    @Override
    public ISimpleTerm getValue() {
        return this.m_value;
    }

    @Override
    public IExpr getInitializer() {
        return this.m_initializer;
    }

    public void setName(String name) {
        this.setName(new JstName(name));
    }

    public void setName(JstName name) {
        assert (name != null) : "name cannot be null";
        this.m_name = name;
    }

    public void setType(IJstType type) {
        this.m_type.setReferencedType(type);
    }

    public void setValue(ISimpleTerm value) {
        this.m_value = value;
        this.addChild(value);
    }

    public void setInitializer(IExpr initializer) {
        this.m_initializer = initializer;
    }

    public String getAccessScope() {
        return this.m_modifiers.getAccessScope();
    }

    public String toNVText() {
        if (this.m_value == null) {
            String defaultValue = null;
            IJstType elementType = this.getType();
            defaultValue = DataTypeHelper.getDefaultValue(elementType.getName());
            return this.m_name + ":" + defaultValue;
        }
        return this.m_name + ":" + this.m_value.toSimpleTermText();
    }

    @Override
    public IJstDoc getDoc() {
        return this.m_doc;
    }

    public void setDoc(IJstDoc jstDoc) {
        this.m_doc = jstDoc;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        Z z = new Z();
        z.format("m_name", this.m_name == null ? null : this.m_name.getName());
        z.format("m_value", (Object)this.m_value);
        z.format("m_modifiers", (Object)this.m_modifiers);
        z.format("m_type", (Object)this.m_type);
        return z.toString();
    }

    @Deprecated
    public String getProcessedValue() {
        char[] val;
        if (this.m_value != null && (val = this.m_value.toSimpleTermText().toCharArray()).length > 0) {
            if (val[0] == '\"' && val[val.length - 1] == '\"' || val[0] == '\'' && val[val.length - 1] == '\'') {
                return new String(val, 1, val.length - 2);
            }
            return this.m_value.toSimpleTermText();
        }
        return null;
    }
}

