/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.List;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstGlobalFunc;
import org.eclipse.vjet.dsf.jst.IJstGlobalProp;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class JstGlobalVar
extends BaseJstNode
implements IJstGlobalVar {
    private static final long serialVersionUID = 1L;
    private JstTypeReference m_type;
    private JstName m_name;
    private ISimpleTerm m_value;
    private IExpr m_initializer;
    private IJstDoc m_doc;
    private IJstGlobalFunc m_globalFunction;
    private IJstGlobalProp m_globalProp;
    private boolean m_memberPromotion;
    private String m_scopeForGlobal;

    public void setMemberPromotion(boolean memberPromotion) {
        this.m_memberPromotion = memberPromotion;
    }

    public JstGlobalVar(IJstGlobalFunc globalFunc) {
        this.m_name = globalFunc.getName();
        this.m_doc = globalFunc.getDoc();
        this.m_type = new JstTypeReference(globalFunc.getRtnType());
        this.m_globalFunction = globalFunc;
        this.addChild(globalFunc);
    }

    public JstGlobalVar(IJstGlobalProp globalProp) {
        this.m_name = globalProp.getName();
        this.m_doc = globalProp.getDoc();
        this.m_type = new JstTypeReference(globalProp.getType());
        this.m_globalProp = globalProp;
        this.addChild(globalProp);
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public IJstDoc getDoc() {
        return this.m_doc;
    }

    @Override
    public IExpr getInitializer() {
        return this.m_initializer;
    }

    @Override
    public JstName getName() {
        return this.m_name;
    }

    @Override
    public IJstType getType() {
        return this.m_type == null ? null : this.m_type.getReferencedType();
    }

    @Override
    public IJstTypeReference getTypeRef() {
        return this.m_type;
    }

    public void setName(String name) {
        this.setName(new JstName(name));
    }

    public void setName(JstName name) {
        assert (name != null) : "name cannot be null";
        this.m_name = name;
    }

    public void setType(IJstType type) {
        this.m_type.setReferencedType(type);
    }

    public void setValue(ISimpleTerm value) {
        this.m_value = value;
        this.addChild(value);
    }

    public void setInitializer(IExpr initializer) {
        this.m_initializer = initializer;
    }

    @Override
    public ISimpleTerm getValue() {
        return this.m_value;
    }

    @Override
    public List<IJstAnnotation> getAnnotations() {
        return null;
    }

    public String toNVText() {
        if (this.m_value == null) {
            String defaultValue = null;
            IJstType elementType = this.getType();
            defaultValue = DataTypeHelper.getDefaultValue(elementType.getName());
            return this.m_name + ":" + defaultValue;
        }
        return this.m_name + ":" + this.m_value.toSimpleTermText();
    }

    public void setDoc(IJstDoc jstDoc) {
        this.m_doc = jstDoc;
    }

    @Override
    public IJstGlobalFunc getFunction() {
        return this.m_globalFunction;
    }

    @Override
    public boolean isFunc() {
        return this.m_globalFunction != null;
    }

    @Override
    public IJstGlobalProp getProperty() {
        return this.m_globalProp;
    }

    @Override
    public JstSource getSource() {
        if (this.m_globalProp != null) {
            return this.m_globalProp.getSource();
        }
        return this.m_globalFunction.getSource();
    }

    @Override
    public void setScopeForGlobal(String scopeForGlobal) {
        this.m_scopeForGlobal = scopeForGlobal;
    }

    @Override
    public String getScopeForGlobal() {
        return this.m_scopeForGlobal;
    }
}

