/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.vjo;

import java.io.PrintWriter;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.BaseGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.JsCoreGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.ArrayCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.ConditionalExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.expr.PtyGetter;
import org.eclipse.vjet.dsf.jst.stmt.PtySetter;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.term.ArrayLiteral;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class ExprGenerator
extends BaseGenerator {
    public ExprGenerator(GeneratorCtx ctx) {
        super(ctx);
    }

    public void writeExpr(IExpr expr) {
        if (expr == null) {
            return;
        }
        this.writeComments((IJstNode)expr);
        if (expr instanceof ArrayAccessExpr) {
            this.write((ArrayAccessExpr)expr);
        } else if (expr instanceof ArrayCreationExpr) {
            this.write((ArrayCreationExpr)expr);
        } else if (expr instanceof ArrayLiteral) {
            this.write((ArrayLiteral)expr);
        } else if (expr instanceof AssignExpr) {
            this.write((AssignExpr)expr);
        } else if (expr instanceof JstIdentifier) {
            this.getWriter().append(((JstIdentifier)expr).toSimpleTermText());
        } else if (expr instanceof BoolExpr) {
            this.write((BoolExpr)expr);
        } else if (expr instanceof ConditionalExpr) {
            this.write((ConditionalExpr)expr);
        } else if (expr instanceof FieldAccessExpr) {
            this.getWriter().append(((FieldAccessExpr)expr).toLHSText());
        } else if (expr instanceof FuncExpr) {
            this.write((FuncExpr)expr);
        } else if (expr instanceof InfixExpr) {
            this.write((InfixExpr)expr);
        } else if (expr instanceof MtdInvocationExpr) {
            this.write((MtdInvocationExpr)expr);
        } else if (expr instanceof ObjCreationExpr) {
            this.write((ObjCreationExpr)expr);
        } else if (expr instanceof ObjLiteral) {
            this.write((ObjLiteral)expr);
        } else if (expr instanceof PostfixExpr) {
            this.write((PostfixExpr)expr);
        } else if (expr instanceof PrefixExpr) {
            this.write((PrefixExpr)expr);
        } else if (expr instanceof PtyGetter) {
            this.write((PtyGetter)expr);
        } else if (expr instanceof PtySetter) {
            this.write((PtySetter)expr);
        } else if (expr instanceof SimpleLiteral) {
            this.getWriter().append(((SimpleLiteral)expr).toSimpleTermText());
        } else {
            String text = expr.toExprText();
            if (text != null) {
                this.getWriter().append(text);
            }
        }
    }

    private void write(ArrayAccessExpr arrayAccessExpr) {
        if (arrayAccessExpr == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        this.writeExpr(arrayAccessExpr.getExpr());
        IExpr index = arrayAccessExpr.getIndex();
        if (index != null) {
            writer.append("[");
            this.writeExpr(index);
            writer.append("]");
        }
    }

    private void write(ArrayCreationExpr arrayCreationExpr) {
        this.getWriter().append(arrayCreationExpr.toExprText());
    }

    private void write(AssignExpr assignExpr) {
        if (assignExpr.getLHS() != null) {
            this.getWriter().append(assignExpr.getLHS().toLHSText());
        }
        this.getWriter().append(assignExpr.getOprator().toString());
        this.writeExpr(assignExpr.getExpr());
    }

    private void write(ArrayLiteral arrayLiteral) {
        this.getWriter().append(arrayLiteral.toSimpleTermText());
    }

    private void write(ObjLiteral objLiteral) {
        this.getWriter().append("{");
        this.writeNameValues(objLiteral.getNVs(), false);
        this.getWriter().append("}");
    }

    private void write(BoolExpr boolExpr) {
        if (boolExpr == null) {
            return;
        }
        IExpr left = boolExpr.getLeft();
        IExpr right = boolExpr.getRight();
        this.writeExpr(left);
        if (boolExpr.getOperator() != null) {
            this.getWriter().append(boolExpr.getOperator().toString());
        }
        this.writeExpr(right);
    }

    private void write(ConditionalExpr condExpr) {
        this.writeExpr((IExpr)condExpr.getCondition());
        this.getWriter().append("?");
        this.writeExpr(condExpr.getThenExpr());
        this.getWriter().append(":");
        this.writeExpr(condExpr.getElseExpr());
    }

    private void write(InfixExpr infixExpr) {
        this.writeExpr(infixExpr.getLeft());
        this.getWriter().append(infixExpr.getOperator().toString());
        this.writeExpr(infixExpr.getRight());
    }

    private void write(MtdInvocationExpr mtdInvocation) {
        IExpr q = mtdInvocation.getQualifyExpr();
        IExpr m = mtdInvocation.getMethodIdentifier();
        this.writeExpr(q);
        if (m instanceof JstIdentifier && ((JstIdentifier)m).getName() == null) {
            return;
        }
        if (q != null && m != null) {
            this.getWriter().append(".");
        }
        this.writeExpr(m);
        this.getWriter().append("(");
        List args = mtdInvocation.getArgs();
        int i = 0;
        while (i < args.size()) {
            if (args.get(i) != null) {
                if (i > 0) {
                    this.getWriter().append(",");
                }
                this.getCtx().getProvider().getJsDocGenerator().writeJsDocForArg((IExpr)args.get(i));
                this.writeExpr((IExpr)args.get(i));
            }
            ++i;
        }
        this.getWriter().append(")");
    }

    private void write(ObjCreationExpr expr) {
        if (expr == null) {
            return;
        }
        PrintWriter writer = this.getWriter();
        IJstType anonymousType = expr.getAnonymousType();
        if (anonymousType == null) {
            writer.append("new ");
            IExpr oExpr = expr.getExpression();
            if (oExpr != null) {
                writer.append(oExpr.toExprText()).append(".");
            }
            this.writeExpr((IExpr)expr.getInvocationExpr());
            return;
        }
        VjoGenerator typeGenerator = this.getTypeGenerator();
        this.indent();
        if (!(expr.getParentNode() instanceof RtnStmt)) {
            this.writeNewline();
            this.writeIndent();
        }
        String name = expr.getExpression() != null ? expr.getExpression() + "." + expr.getInvocationExpr().getMethodIdentifier() : expr.getInvocationExpr().getMethodIdentifier().toExprText();
        List args = expr.getInvocationExpr().getArgs();
        IJstType previousType = typeGenerator.getCurrentType();
        typeGenerator.writeAnonymousType(anonymousType, name, args);
        typeGenerator.setCurrentType(previousType);
        this.outdent();
    }

    private void write(PostfixExpr postfixExpr) {
        this.getWriter().append(postfixExpr.toExprText());
    }

    private void write(PrefixExpr prefixExpr) {
        this.getWriter().append(prefixExpr.toExprText());
    }

    private void write(FuncExpr expr) {
        this.write(expr, false);
    }

    private void write(FuncExpr expr, boolean hasMore) {
        if (expr == null) {
            return;
        }
        JstMethod method = expr.getFunc();
        List args = method.getArgs();
        Object[] params = new Object[args.size()];
        int j = 0;
        while (j < params.length) {
            params[j] = ((JstArg)args.get(j)).getName();
            ++j;
        }
        JsCoreGenerator coreGenerator = this.getJsCoreGenerator();
        coreGenerator.startWriteFunc(params);
        this.writeBlock(method.getBlock());
        coreGenerator.endWriteFunc(hasMore, method.getOwnerType().isMetaType());
    }

    private void write(PtyGetter getter) {
        IExpr qualifier = getter.getQualifyExpr();
        JstIdentifier name = getter.getPtyName();
        this.getExprGenerator().writeExpr(qualifier);
        if (qualifier != null && name != null) {
            this.getWriter().append(".");
        }
        if (name != null) {
            this.getWriter().append(name.toSimpleTermText());
        }
    }

    private void write(PtySetter setter) {
        IExpr qualifier = setter.getQualifyExpr();
        JstIdentifier name = setter.getPtyName();
        String value = setter.getPtyValue();
        this.getExprGenerator().writeExpr(qualifier);
        if (qualifier != null && name != null) {
            this.getWriter().append(".");
        }
        if (name != null) {
            this.getWriter().append(name.toSimpleTermText());
        }
        this.getWriter().append("=");
        this.getWriter().append(value);
    }

    private void writeNameValues(List<NV> nvs, boolean addNewLine) {
        int size = nvs.size();
        int i = 0;
        while (i < size) {
            NV nv = nvs.get(i);
            IExpr value = nv.getValue();
            if (value instanceof FuncExpr) {
                this.getWriter().append(nv.getName()).append(":");
                this.write((FuncExpr)value, i != size - 1);
            } else {
                this.getJsCoreGenerator().writeNameValue(nv.getName(), nv.getValue().toExprText(), i != size - 1, addNewLine);
            }
            ++i;
        }
    }

    private void writeNameValues(List<NV> nvs) {
        this.writeNameValues(nvs, true);
    }

    private void writeBlock(JstBlock block) {
        if (block == null || block.getStmts().isEmpty()) {
            return;
        }
        for (IStmt s : block.getStmts()) {
            this.getStmtGenerator().writeStmt(s);
        }
    }
}

