/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.vjo;

import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.generate.SourceGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.BodyGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.ExprGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.FragmentGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.JsClientGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.JsCoreGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.MtdGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.StmtGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.util.JstCommentHelper;

public abstract class BaseGenerator
extends SourceGenerator {
    private GeneratorCtx m_ctx;

    public BaseGenerator(GeneratorCtx ctx) {
        super(ctx.getWriter(), ctx.getIndenter(), ctx.getStyle());
        this.m_ctx = ctx;
    }

    public String getGeneratedText() {
        return this.m_ctx.getStringWriter().toString();
    }

    protected GeneratorCtx getCtx() {
        return this.m_ctx;
    }

    protected JsCoreGenerator getJsCoreGenerator() {
        return this.getCtx().getProvider().getJsCoreGenerator();
    }

    protected JsClientGenerator getJsClientGenerator() {
        return this.getCtx().getProvider().getJsClientGenerator();
    }

    protected VjoGenerator getTypeGenerator() {
        return this.getCtx().getProvider().getTypeGenerator();
    }

    protected MtdGenerator getMtdGenerator() {
        return this.getCtx().getProvider().getMtdGenerator();
    }

    protected BodyGenerator getBodyGenerator() {
        return this.getCtx().getProvider().getBodyGenerator();
    }

    protected StmtGenerator getStmtGenerator() {
        return this.getCtx().getProvider().getStmtGenerator();
    }

    protected ExprGenerator getExprGenerator() {
        return this.getCtx().getProvider().getExprGenerator();
    }

    protected FragmentGenerator getFragmentGenerator() {
        return this.getCtx().getProvider().getFragmentGenerator();
    }

    protected void writeComments(IJstNode node) {
        if (node != null && node.getCommentLocations() != null) {
            List commentLocations = node.getCommentLocations();
            List comments = JstCommentHelper.getCommentsAsString((IJstType)node.getOwnerType(), (List)commentLocations);
            for (String comment : comments) {
                this.writeNewline();
                this.getWriter().append(comment);
            }
        }
    }
}

