/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;

public class MixinValidationUtil {
    public static boolean validateMixin(VjoValidationCtx ctx, VjoSemanticValidator validator, IJstType targetType, IJstType mixinType) {
        return MixinValidationUtil.validateMixin(ctx, validator, targetType, mixinType, false);
    }

    public static boolean validateMixin(VjoValidationCtx ctx, VjoSemanticValidator validator, IJstType targetType, IJstType mixinType, boolean isInstanceMixin) {
        if (targetType == null || mixinType == null) {
            return false;
        }
        if (!targetType.isClass()) {
            return false;
        }
        if (!mixinType.isMixin()) {
            return false;
        }
        HashMap<String, List<IJstMethod>> instanceMethodMap = new HashMap<String, List<IJstMethod>>();
        List allInstanceMethods = targetType.getMethods(false, true);
        for (IJstMethod m : allInstanceMethods) {
            ArrayList<IJstMethod> mList = (ArrayList<IJstMethod>)instanceMethodMap.get(m.getName().getName());
            if (mList == null) {
                mList = new ArrayList<IJstMethod>();
                instanceMethodMap.put(m.getName().getName(), mList);
            }
            mList.add(m);
        }
        HashMap<String, List<IJstMethod>> staticMethodMap = new HashMap<String, List<IJstMethod>>();
        List allStaticMethods = targetType.getMethods(true);
        for (IJstMethod m : allStaticMethods) {
            ArrayList<IJstMethod> mList = (ArrayList<IJstMethod>)staticMethodMap.get(m.getName().getName());
            if (mList == null) {
                mList = new ArrayList<IJstMethod>();
                staticMethodMap.put(m.getName().getName(), mList);
            }
            mList.add(m);
        }
        return MixinValidationUtil.validateMixin(ctx, validator, targetType, mixinType, instanceMethodMap, staticMethodMap, isInstanceMixin);
    }

    public static boolean validateMixin(VjoValidationCtx ctx, VjoSemanticValidator validator, IJstType targetType, IJstType mixinType, Map<String, List<IJstMethod>> instanceMtds, Map<String, List<IJstMethod>> staticMtds, boolean isInstanceMixin) {
        BaseVjoSemanticRuleCtx ruleCtx;
        IJstProperty p;
        List<IJstMethod> candidateMethods;
        if (targetType == null || mixinType == null) {
            return false;
        }
        if (!targetType.isClass()) {
            return false;
        }
        if (!mixinType.isMixin()) {
            return false;
        }
        if (isInstanceMixin && mixinType.getMethods(true).size() <= 0) {
            mixinType.getProperties(true).size();
        }
        block0: for (IJstType expectType : mixinType.getExpects()) {
            if (expectType == null) continue;
            expectType = ctx.getTypeSpaceType(expectType);
            for (IJstType satisfyType : MixinValidationUtil.getSatisfies(ctx, targetType)) {
                if (satisfyType != null && satisfyType.getName().equals(expectType.getName())) continue block0;
            }
            if (!expectType.isInterface() && !expectType.getModifiers().isAbstract() || !(targetType instanceof JstType)) continue;
            MixinValidationUtil.validateImplemented(ctx, (JstType)targetType, expectType, validator, mixinType);
        }
        for (IJstMethod toMixMethod : mixinType.getMethods(false, true)) {
            if (toMixMethod instanceof ISynthesized || (candidateMethods = instanceMtds.get(toMixMethod.getName().getName())) == null || candidateMethods.size() <= 0) continue;
            for (IJstMethod mtd : candidateMethods) {
                if (mtd instanceof JstProxyMethod) continue;
                if (toMixMethod instanceof JstProxyMethod && toMixMethod.getOwnerType().isClass()) {
                    MixinValidationUtil.fireDuplicateProblem(ctx, validator, mtd);
                    continue;
                }
                if (!(toMixMethod instanceof JstMethod) || !toMixMethod.getOwnerType().isMixin()) continue;
                MixinValidationUtil.fireDuplicateProblem(ctx, validator, mtd);
            }
        }
        for (IJstMethod toMixMethod : mixinType.getMethods(true, true)) {
            if (toMixMethod instanceof ISynthesized || (candidateMethods = staticMtds.get(toMixMethod.getName().getName())) == null || candidateMethods.size() <= 0) continue;
            for (IJstMethod mtd : candidateMethods) {
                if (mtd instanceof JstProxyMethod) continue;
                if (toMixMethod instanceof JstProxyMethod && toMixMethod.getOwnerType().isClass()) {
                    MixinValidationUtil.fireDuplicateProblem(ctx, validator, mtd);
                    continue;
                }
                if (!(toMixMethod instanceof JstMethod) || !toMixMethod.getOwnerType().isMixin()) continue;
                MixinValidationUtil.fireDuplicateProblem(ctx, validator, mtd);
            }
        }
        for (IJstProperty toMixProperty : mixinType.getAllPossibleProperties(false, true)) {
            p = targetType.getProperty(toMixProperty.getName().getName(), false, true);
            if (p == null || p instanceof JstProxyProperty || p instanceof ISynthesized) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)p, ctx.getGroupId(), new String[]{toMixProperty.getName().getName()});
            validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().DUPLICATE_PROPERTY, ruleCtx);
        }
        for (IJstProperty toMixProperty : mixinType.getAllPossibleProperties(true, true)) {
            p = targetType.getProperty(toMixProperty.getName().getName(), true, false);
            if (p == null || p instanceof JstProxyProperty || p instanceof ISynthesized) continue;
            ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)p, ctx.getGroupId(), new String[]{toMixProperty.getName().getName()});
            validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().DUPLICATE_PROPERTY, ruleCtx);
        }
        return true;
    }

    private static void fireDuplicateProblem(VjoValidationCtx ctx, VjoSemanticValidator validator, IJstMethod mtd) {
        BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)mtd.getName(), ctx.getGroupId(), new String[]{mtd.getName().getName()});
        validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().DUPLICATE_METHOD, ruleCtx);
    }

    private static Set<IJstType> getSatisfies(VjoValidationCtx ctx, IJstType jstType) {
        HashSet<IJstType> satisfies = new HashSet<IJstType>();
        MixinValidationUtil.getSatifies(ctx, jstType, satisfies, new HashSet<IJstType>());
        return satisfies;
    }

    private static void getSatifies(VjoValidationCtx ctx, IJstType root, Set<IJstType> satifies, Set<IJstType> visited) {
        block5: {
            block4: {
                if ((root = ctx.getTypeSpaceType(root)) == null || visited.contains(root)) {
                    return;
                }
                visited.add(root);
                if (!root.isClass()) break block4;
                for (IJstType satisfy : root.getSatisfies()) {
                    MixinValidationUtil.getSatifies(ctx, satisfy, satifies, visited);
                }
                for (IJstType extend : root.getExtends()) {
                    MixinValidationUtil.getSatifies(ctx, extend, satifies, visited);
                }
                break block5;
            }
            if (!root.isInterface()) break block5;
            satifies.add(root);
            for (IJstType extend : root.getExtends()) {
                MixinValidationUtil.getSatifies(ctx, extend, satifies, visited);
            }
        }
    }

    private static boolean validateImplemented(VjoValidationCtx ctx, JstType jstType, IJstType extendType, VjoSemanticValidator validator, IJstType mixType) {
        List extTypeMtds;
        JstTypeWithArgs typeWithArgs = null;
        if (extendType instanceof JstTypeWithArgs) {
            typeWithArgs = (JstTypeWithArgs)extendType;
            extendType = typeWithArgs.getType();
        }
        if ((extTypeMtds = extendType.getMethods(false, true)) != null) {
            for (IJstMethod extTypeMtd : extTypeMtds) {
                IJstMethod toExtMethod;
                if (extTypeMtd == null || (toExtMethod = extTypeMtd).isPrivate()) continue;
                IJstMethod candidateMtd = jstType.getMethod(toExtMethod.getName().getName(), false, true);
                JstType candidateType = jstType;
                if (candidateMtd != null) {
                    while (candidateType != null && candidateType.getMethod(candidateMtd.getName().getName(), false, false) != candidateMtd) {
                        candidateType = candidateType.getExtend();
                    }
                } else {
                    candidateType = null;
                }
                boolean overriden = false;
                IJstMethod implMethodFound = null;
                if (candidateMtd != null) {
                    IJstMethod implMethod = candidateMtd;
                    if (implMethod.equals(toExtMethod)) {
                        overriden = false;
                    } else if (implMethod.isAbstract()) {
                        overriden = false;
                    } else {
                        overriden = true;
                        implMethodFound = implMethod;
                    }
                }
                if (overriden && implMethodFound != null) {
                    BaseVjoSemanticRuleCtx ruleCtx;
                    JstTypeWithArgs implType = null;
                    if (candidateType != null && candidateType instanceof JstTypeWithArgs) {
                        implType = (JstTypeWithArgs)candidateType;
                    }
                    if (toExtMethod.isFinal()) {
                        ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)implMethodFound.getName(), ctx.getGroupId(), new String[]{toExtMethod.getName().getName()});
                        validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().FINAL_METHOD_SHOULD_NOT_BE_OVERRIDEN, ruleCtx);
                    }
                    if (toExtMethod.isPublic() && !implMethodFound.isPublic() || toExtMethod.isProtected() && implMethodFound.isPrivate()) {
                        ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)implMethodFound.getName(), ctx.getGroupId(), new String[]{toExtMethod.getName().getName()});
                        validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OVERRIDE_METHOD_SHOULD_NOT_REDUCE_VISIBILITY, ruleCtx);
                        continue;
                    }
                    if (MixinValidationUtil.isCompatibleMethod(typeWithArgs, implType, toExtMethod, implMethodFound)) continue;
                    if (toExtMethod.isAbstract() || extendType.isInterface()) {
                        ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{mixType.getName(), toExtMethod.getName().getName(), jstType.getName()});
                        validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().MIXIN_EXPECTS_INSTANCE_METHOD_MUST_BE_SATISFIED, ruleCtx);
                        continue;
                    }
                    ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)implMethodFound.getName(), ctx.getGroupId(), new String[]{toExtMethod.getName().getName()});
                    validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().OVERRIDE_METHOD_SHOULD_HAVE_COMPATIBLE_SIGNATURE, ruleCtx);
                    continue;
                }
                if (overriden || !toExtMethod.isAbstract() && !toExtMethod.getOwnerType().isInterface() && !extendType.isInterface()) continue;
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)jstType, ctx.getGroupId(), new String[]{mixType.getName(), toExtMethod.getName().getName(), jstType.getName()});
                validator.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().MIXIN_EXPECTS_INSTANCE_METHOD_MUST_BE_SATISFIED, ruleCtx);
            }
        }
        return true;
    }

    public static boolean isCompatibleMethod(JstTypeWithArgs typeWithArgsContract, JstTypeWithArgs typeWithArgsImpl, IJstMethod contract, IJstMethod impl) {
        ArrayList<IJstMethod> contractOverloaded = new ArrayList<IJstMethod>();
        contractOverloaded.add(contract);
        contractOverloaded.addAll(contract.getOverloaded());
        block0: for (IJstMethod contractMtd : contractOverloaded) {
            List implOverloaded = impl.getOverloaded();
            if (MixinValidationUtil.isCompatibleMethodNoOverload(typeWithArgsContract, typeWithArgsImpl, contractMtd, impl)) continue;
            for (IJstMethod implMtd : implOverloaded) {
                if (MixinValidationUtil.isCompatibleMethodNoOverload(typeWithArgsContract, typeWithArgsImpl, contractMtd, implMtd)) continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean isCompatibleMethodNoOverload(JstTypeWithArgs typeWithArgsContract, JstTypeWithArgs typeWithArgsImpl, IJstMethod contract, IJstMethod impl) {
        List args = contract.getArgs();
        List mArgs = impl.getArgs();
        if (args.size() != mArgs.size()) {
            return false;
        }
        int i = 0;
        int len = args.size();
        while (i < len) {
            JstArg arg = (JstArg)args.get(i);
            JstArg mArg = (JstArg)mArgs.get(i);
            IJstType argType = arg.getType();
            if (typeWithArgsContract != null && argType instanceof JstParamType) {
                argType = typeWithArgsContract.getParamArgType((JstParamType)argType);
            }
            IJstType mArgType = mArg.getType();
            if (typeWithArgsImpl != null && mArgType instanceof JstParamType) {
                mArgType = typeWithArgsImpl.getParamArgType((JstParamType)mArgType);
            }
            if (argType instanceof JstTypeWithArgs && mArgType instanceof JstTypeWithArgs ? !TypeCheckUtil.isAssignable(typeWithArgsContract, typeWithArgsImpl, (JstTypeWithArgs)argType, (JstTypeWithArgs)mArgType) : !TypeCheckUtil.isAssignable(argType, mArgType)) {
                return false;
            }
            ++i;
        }
        IJstType rtnType = contract.getRtnType();
        IJstType mRtnType = impl.getRtnType();
        if (typeWithArgsContract != null && rtnType instanceof JstParamType) {
            rtnType = typeWithArgsContract.getParamArgType((JstParamType)rtnType);
        }
        if (typeWithArgsImpl != null && mRtnType instanceof JstParamType) {
            mRtnType = typeWithArgsImpl.getParamArgType((JstParamType)mRtnType);
        }
        return !(rtnType instanceof JstTypeWithArgs && mRtnType instanceof JstTypeWithArgs ? !TypeCheckUtil.isAssignable(typeWithArgsContract, typeWithArgsImpl, (JstTypeWithArgs)rtnType, (JstTypeWithArgs)mRtnType) : !TypeCheckUtil.isAssignable(rtnType, mRtnType));
    }
}

