/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util;

import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.EVjoSymbolType;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.IVjoSymbol;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbolTable;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;

public class JstTypeToPackageUtil {
    public static IJstType lookUpPackage(VjoValidationCtx ctx, IJstType type) {
        String typeName = type.getName();
        String[] packageNames = typeName != null ? typeName.split("\\.") : new String[]{};
        VjoSymbolTable symbolTable = ctx.getSymbolTable();
        boolean isGlobal = true;
        IJstType parentPackage = ctx.getGlobal();
        int i = 0;
        int len = packageNames.length - 1;
        while (i < len) {
            if (parentPackage == null) {
                return null;
            }
            IVjoSymbol childPackageSymbol = symbolTable.getSymbolInScope((IJstNode)parentPackage, packageNames[i], isGlobal ? EVjoSymbolType.LOCAL_VARIABLE : EVjoSymbolType.INSTANCE_VARIABLE);
            if (childPackageSymbol == null) {
                return null;
            }
            parentPackage = childPackageSymbol.getAssignedType();
            isGlobal = false;
            ++i;
        }
        return parentPackage;
    }
}

