/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class VjoArrayAccessExprValidator
extends VjoSemanticValidator
implements IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(ArrayAccessExpr.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof ArrayAccessExpr)) {
            return;
        }
        String groupId = ctx.getGroupId();
        ArrayAccessExpr expr = (ArrayAccessExpr)jstNode;
        IExpr arrayExpr = expr.getExpr();
        IExpr arrayIndex = expr.getIndex();
        if (arrayExpr != null) {
            IJstType indexValue;
            IJstType arrayExprValue = arrayExpr.getResultType();
            if (arrayExprValue == null) {
                return;
            }
            String[] arguments = new String[]{arrayIndex != null ? arrayIndex.toExprText() : "NULL", expr.toExprText()};
            if (arrayIndex != null && (indexValue = arrayIndex.getResultType()) != null && !TypeCheckUtil.isNumber(indexValue) && !TypeCheckUtil.isString(indexValue)) {
                BaseVjoSemanticRuleCtx arrayIndexShouldBeIntTypeRuleCtx = new BaseVjoSemanticRuleCtx((IJstNode)expr, groupId, arguments);
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ARRAY_INDEX_SHOULD_BE_INT_OR_STRING_TYPE, arrayIndexShouldBeIntTypeRuleCtx);
            }
        }
    }
}

