/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.EVjoSymbolType;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.IVjoSymbol;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoScope;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;

public class VjoSymbolTable {
    private Map<IJstNode, Map<VjoSymbolTableKey, List<IVjoSymbol>>> m_scopeToSymbols = new HashMap<IJstNode, Map<VjoSymbolTableKey, List<IVjoSymbol>>>();

    public void addSymbolInScope(IJstNode scope, IVjoSymbol symbol) {
        VjoSymbolTableKey key;
        List<IVjoSymbol> symbols;
        Map<VjoSymbolTableKey, List<IVjoSymbol>> symbolMap;
        if (scope instanceof IJstRefType) {
            scope = ((IJstRefType)scope).getReferencedNode();
        }
        if ((symbolMap = this.m_scopeToSymbols.get(scope)) == null) {
            symbolMap = new LinkedHashMap<VjoSymbolTableKey, List<IVjoSymbol>>();
            this.m_scopeToSymbols.put(scope, symbolMap);
        }
        if ((symbols = symbolMap.get(key = new VjoSymbolTableKey(symbol.getName(), symbol.getSymbolType()))) == null) {
            symbols = new ArrayList<IVjoSymbol>();
            symbolMap.put(key, symbols);
        }
        symbols.add(symbol);
    }

    public void removeSymbolInScope(IJstNode scope, IVjoSymbol symbol) {
        Map<VjoSymbolTableKey, List<IVjoSymbol>> symbolMap;
        if (scope instanceof IJstRefType) {
            scope = ((IJstRefType)scope).getReferencedNode();
        }
        if ((symbolMap = this.m_scopeToSymbols.get(scope)) != null) {
            VjoSymbolTableKey key = new VjoSymbolTableKey(symbol.getName(), symbol.getSymbolType());
            List<IVjoSymbol> symbols = symbolMap.get(key);
            int i = symbols != null ? symbols.size() - 1 : -1;
            while (i >= 0) {
                if (symbol.equals(symbols.get(i))) {
                    symbols.remove(i);
                    break;
                }
                --i;
            }
        }
    }

    public void removeSymbolsInScope(IJstNode scope) {
        this.m_scopeToSymbols.remove(scope);
    }

    public void removeSymbolsInScope(IJstType scope, boolean removePublic) {
        if (scope instanceof IJstRefType) {
            scope = ((IJstRefType)scope).getReferencedNode();
        }
        List<IVjoSymbol> symbols = this.getSymbolsInScope((IJstNode)scope);
        for (IVjoSymbol symbol : symbols) {
            String symbolName = symbol.getName();
            EVjoSymbolType symbolType = symbol.getSymbolType();
            if (EVjoSymbolType.STATIC_FUNCTION.equals((Object)symbolType) || EVjoSymbolType.INSTANCE_FUNCTION.equals((Object)symbolType)) {
                IJstMethod method = scope.getMethod(symbolName);
                if (!removePublic && (method == null || method.getModifiers().isPublic())) continue;
                symbol.setVisible(false);
                continue;
            }
            IJstProperty property = scope.getProperty(symbolName);
            if (!removePublic && (property == null || property.getModifiers().isPublic())) continue;
            symbol.setVisible(false);
        }
    }

    public List<IVjoSymbol> getSymbolsInScope(IJstNode node) {
        return this.getSymbolsInScope(node, EVjoSymbolType.INSTANCE_VARIABLE);
    }

    public List<IVjoSymbol> getSymbolsInScope(IJstNode node, EVjoSymbolType symbolType) {
        if (node instanceof IJstRefType) {
            node = ((IJstRefType)node).getReferencedNode();
        }
        Map<VjoSymbolTableKey, List<IVjoSymbol>> symbolMap = this.m_scopeToSymbols.get(node);
        ArrayList<IVjoSymbol> toReturn = new ArrayList<IVjoSymbol>();
        if (symbolMap != null) {
            for (List<IVjoSymbol> symbols : symbolMap.values()) {
                for (IVjoSymbol symbol : symbols) {
                    if (!symbol.isVisible()) continue;
                    if (symbolType.equals((Object)symbol.getSymbolType())) {
                        toReturn.add(symbol);
                        continue;
                    }
                    if (EVjoSymbolType.INSTANCE_VARIABLE.equals((Object)symbolType) && EVjoSymbolType.INSTANCE_FUNCTION.equals((Object)symbol.getSymbolType())) {
                        toReturn.add(symbol);
                        continue;
                    }
                    if (EVjoSymbolType.STATIC_VARIABLE.equals((Object)symbolType) && EVjoSymbolType.STATIC_FUNCTION.equals((Object)symbol.getSymbolType())) {
                        toReturn.add(symbol);
                        continue;
                    }
                    if (!EVjoSymbolType.LOCAL_VARIABLE.equals((Object)symbolType) || !EVjoSymbolType.LOCAL_FUNCTION.equals((Object)symbol.getSymbolType())) continue;
                    toReturn.add(symbol);
                }
            }
        }
        return toReturn;
    }

    public IVjoSymbol getSymbolInScope(IJstNode scope, String name) {
        return this.getSymbolInScope(scope, name, EVjoSymbolType.INSTANCE_VARIABLE);
    }

    public IVjoSymbol getSymbolInScope(IJstNode scope, String name, EVjoSymbolType symbolType) {
        return this.getSymbolInScope(scope, name, symbolType, false);
    }

    public IVjoSymbol getSymbolInScope(IJstNode scope, String name, EVjoSymbolType symbolType, boolean alwaysVisible) {
        Map<VjoSymbolTableKey, List<IVjoSymbol>> symbolMap;
        if (scope instanceof IJstRefType) {
            scope = ((IJstRefType)scope).getReferencedNode();
        }
        if ((symbolMap = this.m_scopeToSymbols.get(scope)) == null || name == null) {
            return null;
        }
        IVjoSymbol found = null;
        VjoSymbolTableKey key = new VjoSymbolTableKey(name, symbolType);
        List<IVjoSymbol> symbols = symbolMap.get(key);
        int i = symbols != null ? symbols.size() - 1 : -1;
        while (i >= 0) {
            IVjoSymbol candidate = symbols.get(i);
            if (candidate != null && (alwaysVisible || candidate.isVisible())) {
                found = candidate;
                break;
            }
            --i;
        }
        return found;
    }

    public IVjoSymbol getSymbol(VjoScope scope, String name) {
        return this.getSymbol(scope, name, EVjoSymbolType.LOCAL_VARIABLE);
    }

    public IVjoSymbol getSymbol(VjoScope scope, String name, EVjoSymbolType symbolType) {
        IVjoSymbol foundSymbol = null;
        int i = scope.getScopeNodes().size() - 1;
        while (i >= 0) {
            foundSymbol = this.getSymbolInScope(scope.getScopeNodes().get(i), name, symbolType);
            if (foundSymbol != null) break;
            --i;
        }
        return foundSymbol;
    }

    private static final class VjoSymbolTableKey {
        private String m_keyName;
        private EVjoSymbolType m_keyType;

        public VjoSymbolTableKey(String keyName, EVjoSymbolType keyType) {
            this.m_keyName = keyName;
            this.m_keyType = keyType;
        }

        public String getKeyName() {
            return this.m_keyName;
        }

        public EVjoSymbolType getKeyType() {
            return this.m_keyType;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof VjoSymbolTableKey)) {
                return false;
            }
            VjoSymbolTableKey instance = (VjoSymbolTableKey)obj;
            if (this.getKeyName() != null ? !this.getKeyName().equals(instance.getKeyName()) : instance.getKeyName() != null) {
                return false;
            }
            if (this.getKeyType() != null) {
                if (EVjoSymbolType.LOCAL_VARIABLE.equals((Object)this.getKeyType()) && (EVjoSymbolType.LOCAL_VARIABLE.equals((Object)instance.getKeyType()) || EVjoSymbolType.LOCAL_FUNCTION.equals((Object)instance.getKeyType()))) {
                    return true;
                }
                if (EVjoSymbolType.INSTANCE_VARIABLE.equals((Object)this.getKeyType()) && (EVjoSymbolType.INSTANCE_VARIABLE.equals((Object)instance.getKeyType()) || EVjoSymbolType.INSTANCE_FUNCTION.equals((Object)instance.getKeyType()))) {
                    return true;
                }
                if (EVjoSymbolType.STATIC_VARIABLE.equals((Object)this.getKeyType()) && (EVjoSymbolType.STATIC_VARIABLE.equals((Object)instance.getKeyType()) || EVjoSymbolType.STATIC_FUNCTION.equals((Object)instance.getKeyType()))) {
                    return true;
                }
            } else if (instance.getKeyType() != null) {
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 0;
            if (this.getKeyName() != null) {
                hash = this.getKeyName().hashCode() << 5;
            }
            if (EVjoSymbolType.LOCAL_VARIABLE.equals((Object)this.getKeyType()) || EVjoSymbolType.LOCAL_FUNCTION.equals((Object)this.getKeyType())) {
                hash += EVjoSymbolType.LOCAL_VARIABLE.hashCode();
            } else if (EVjoSymbolType.INSTANCE_VARIABLE.equals((Object)this.getKeyType()) || EVjoSymbolType.INSTANCE_FUNCTION.equals((Object)this.getKeyType())) {
                hash += EVjoSymbolType.INSTANCE_VARIABLE.hashCode();
            } else if (EVjoSymbolType.STATIC_VARIABLE.equals((Object)this.getKeyType()) || EVjoSymbolType.STATIC_FUNCTION.equals((Object)this.getKeyType())) {
                hash += EVjoSymbolType.STATIC_VARIABLE.hashCode();
            }
            return hash;
        }
    }
}

