/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validate;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validate.ErrorReporter;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;

public class JstValidationVisitor
implements IJstVisitor {
    private static final String NO_PKG_TYPE_NAME = "NoPkgTypeName";
    private Properties m_messages;
    private ErrorReporter m_errorReporter;

    public JstValidationVisitor(ErrorReporter errorReporter) {
        if (this.m_messages == null) {
            this.m_messages = new Properties();
            try {
                String file = ResourceUtil.getResource(JstValidationVisitor.class, (String)"messages.properties").getFile();
                this.m_messages.load(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.m_errorReporter = errorReporter;
    }

    public void endVisit(IJstNode node) {
    }

    public void postVisit(IJstNode node) {
    }

    public void preVisit(IJstNode node) {
    }

    public boolean visit(IJstNode node) {
        if (node instanceof IJstType) {
            return this.visitType((IJstType)node);
        }
        return false;
    }

    private boolean visitType(IJstType node) {
        if (node.getName() == "") {
            this.m_errorReporter.error(this.m_messages.getProperty(NO_PKG_TYPE_NAME), node.getSource().toString(), node.getSource().getStartOffSet(), node.getSource().getEndOffSet());
        }
        if (node.isClass()) {
            this.validateCType(node);
        }
        return true;
    }

    private void validateCType(IJstType node) {
    }
}

