/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.util;

import org.eclipse.vjet.dsf.jsnative.anno.JsSupport;
import org.eclipse.vjet.dsf.jsnative.anno.JsVersion;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class SupportedJsVersion {
    public static boolean mozillaOneDotZero(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_ZERO);
    }

    public static boolean mozillaOneDotOne(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_ONE);
    }

    public static boolean mozillaOneDotTwo(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_TWO);
    }

    public static boolean mozillaOneDotThree(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_THREE);
    }

    public static boolean mozillaOneDotFour(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_FOUR);
    }

    public static boolean mozillaOneDotFive(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_FIVE);
    }

    public static boolean mozillaOneDotSix(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_SIX);
    }

    public static boolean mozillaOneDotSeven(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_SEVEN);
    }

    public static boolean mozillaOneDotEight(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.MOZILLA_ONE_DOT_EIGHT);
    }

    public static boolean jScriptOneDotZero(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_ONE_DOT_ZERO);
    }

    public static boolean jScriptTwoDotZero(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_TWO_DOT_ZERO);
    }

    public static boolean jScriptThreeDotZero(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_THREE_DOT_ZERO);
    }

    public static boolean jScriptFourDotZero(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_FOUR_DOT_ZERO);
    }

    public static boolean jScriptFiveDotZero(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_FIVE_DOT_ZERO);
    }

    public static boolean jScriptFiveDotOne(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_FIVE_DOT_ONE);
    }

    public static boolean jScriptFiveDotFive(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_FIVE_DOT_FIVE);
    }

    public static boolean jScriptFiveDotSix(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_FIVE_DOT_SIX);
    }

    public static boolean jScriptEightDotZero(IJstAnnotation annot) {
        return SupportedJsVersion.isSupportedBy(annot, JsVersion.JSCRIPT_EIGHT_DOT_ZERO);
    }

    public static boolean isSupportedBy(IJstAnnotation annot, JsVersion jsVersion) {
        if (!JsSupport.class.getSimpleName().equals(annot.getName().toString())) {
            return false;
        }
        for (IExpr expr : annot.values()) {
            String[] supportedJsRuntimes;
            if (expr instanceof JstIdentifier) {
                return SupportedJsVersion.getVersion(jsVersion, expr.toExprText());
            }
            if (!(expr instanceof JstArrayInitializer)) continue;
            JstArrayInitializer init = (JstArrayInitializer)expr;
            String jsruntimes = init.toExprText();
            jsruntimes = jsruntimes.substring(jsruntimes.indexOf(91) + 1, jsruntimes.indexOf(93));
            String[] stringArray = supportedJsRuntimes = jsruntimes.split(",");
            if (supportedJsRuntimes.length == 0) continue;
            String ver = stringArray[0];
            return SupportedJsVersion.getVersion(jsVersion, ver);
        }
        return false;
    }

    private static boolean getVersion(JsVersion jsVersion, String ver) {
        JsVersion supVer;
        int dotIndex = ver.indexOf(46);
        if (dotIndex > 0 && (supVer = JsVersion.valueOf((String)ver.substring(dotIndex + 1))) != null && supVer.getName().equals(jsVersion.getName())) {
            try {
                double aVersion = Double.valueOf(supVer.getVersion());
                double jVersion = Double.valueOf(jsVersion.getVersion());
                if (aVersion >= jVersion) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }
}

