/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.vjet.dsf.javatojs.control.ICodeGenPathResolver;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class CodeGenPathResolver
implements ICodeGenPathResolver {
    private final URL m_vjoRoot;
    private final URL m_jsrRoot;

    public CodeGenPathResolver(URL vjoRoot, URL jsrRoot) {
        this.m_vjoRoot = vjoRoot;
        this.m_jsrRoot = jsrRoot;
    }

    @Override
    public URL getJsrFilePath(JstType type) throws MalformedURLException {
        return new URL(this.m_jsrRoot + "/" + CodeGenPathResolver.getPath(type) + "Jsr.java");
    }

    @Override
    public URL getVjoFilePath(JstType type) throws MalformedURLException {
        return new URL(this.m_vjoRoot + "/" + CodeGenPathResolver.getPath(type) + ".js");
    }

    private static String getPath(JstType type) {
        return type.getName().replace('.', File.separatorChar);
    }

    @Override
    public URL getJavaFilePath(JstType type) throws MalformedURLException {
        return new URL(this.m_vjoRoot + "/" + CodeGenPathResolver.getPath(type) + ".java");
    }
}

