/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.util;

import java.net.URL;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.vjet.dsf.javatojs.translate.AstBinding;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class AstBindingHelper {
    public static AstBinding getAstSrcBinding(IJstNode jstNode) {
        try {
            return (AstBinding)jstNode.getOwnerType().getSource().getBinding();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ASTNode getAstNode(IJstNode jstNode) {
        try {
            return ((AstBinding)jstNode.getSource().getBinding()).getAstNode();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static CompilationUnit getCompilationUnit(JstType type) {
        try {
            return (CompilationUnit)AstBindingHelper.getAstSrcBinding((IJstNode)type).getAstNode();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static AbstractTypeDeclaration getAstType(IJstType jstType) {
        ASTNode astNode = AstBindingHelper.getAstNode((IJstNode)jstType);
        if (astNode instanceof AbstractTypeDeclaration) {
            return (AbstractTypeDeclaration)astNode;
        }
        if (astNode instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)astNode;
            for (Object obj : cu.types()) {
                AbstractTypeDeclaration astType = (AbstractTypeDeclaration)obj;
                if (!TranslateHelper.isPublic(astType.modifiers())) continue;
                return astType;
            }
        }
        return null;
    }

    public static Type getAstType(JstArg jstArg) {
        ASTNode astNode = AstBindingHelper.getAstNode((IJstNode)jstArg);
        if (astNode instanceof Type) {
            return (Type)astNode;
        }
        return null;
    }

    public static Type getAstType(IJstTypeReference jstTypeRef) {
        ASTNode astNode = AstBindingHelper.getAstNode((IJstNode)jstTypeRef);
        if (astNode instanceof Type) {
            return (Type)astNode;
        }
        return null;
    }

    public static MethodDeclaration getAstMethod(IJstMethod jstMtd) {
        return (MethodDeclaration)AstBindingHelper.getAstNode((IJstNode)jstMtd);
    }

    public static String getSourceName(IJstNode jstNode) {
        AstBinding binding;
        block4: {
            try {
                IJstType jstType = jstNode.getOwnerType();
                while (jstType.getOuterType() != null) {
                    jstType = jstType.getOuterType();
                }
                binding = AstBindingHelper.getAstSrcBinding((IJstNode)jstType);
                if (binding != null) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return binding.getPkgName() == null ? binding.getClassName() : String.valueOf(binding.getPkgName()) + "." + binding.getClassName();
    }

    public static URL getPackagePath(JstType type) {
        try {
            return AstBindingHelper.getAstSrcBinding((IJstNode)type).getPkgPath();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

