/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.util;

import java.util.List;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class AutoBoxer {
    private static AutoBoxer s_instance = new AutoBoxer();

    private AutoBoxer() {
    }

    public static AutoBoxer getInstance() {
        return s_instance;
    }

    public boolean needAutoBoxing(IExpr expr, IJstType expectedType) {
        IJstNode binding;
        MtdInvocationExpr mtdExpr;
        if (expr == null) {
            return false;
        }
        if (expr instanceof AssignExpr) {
            AssignExpr assignExpr = (AssignExpr)expr;
            return this.needAutoBoxing(assignExpr.getExpr(), assignExpr.getResultType());
        }
        if (expr instanceof MtdInvocationExpr && (mtdExpr = (MtdInvocationExpr)expr).getMethodIdentifier() instanceof JstIdentifier && (binding = ((JstIdentifier)mtdExpr.getMethodIdentifier()).getJstBinding()) instanceof IJstMethod) {
            IJstMethod jstMtd = (IJstMethod)binding;
            JstArg expectedArg = null;
            int i = 0;
            while (i < mtdExpr.getArgs().size()) {
                IExpr actualArg = (IExpr)mtdExpr.getArgs().get(i);
                if (i < jstMtd.getArgs().size()) {
                    expectedArg = (JstArg)jstMtd.getArgs().get(i);
                }
                if (expectedArg != null && this.needAutoBoxing(actualArg, expectedArg.getType())) {
                    return true;
                }
                ++i;
            }
        }
        if (expr instanceof ObjCreationExpr || this.isNull(expr)) {
            return false;
        }
        IJstType toType = this.getExpectedType(expectedType);
        if (this.forceBoxing(expr, toType)) {
            return true;
        }
        return this.needAutoBoxing(expr.getResultType(), toType);
    }

    public boolean needAutoBoxing(IJstType actualType, IJstType expectedType) {
        if (actualType == null || expectedType == null || actualType.getSimpleName() == null || expectedType.getSimpleName() == null) {
            return false;
        }
        if ((DataTypeHelper.isNumericPrimitiveType((IJstType)actualType) || DataTypeHelper.isCharPrimitiveType((IJstType)actualType)) && (DataTypeHelper.isNumericWrapperType((IJstType)expectedType) || TranslateHelper.isObjectType(expectedType) || expectedType instanceof JstParamType)) {
            return true;
        }
        if (DataTypeHelper.isBooleanPrimitiveType((IJstType)actualType) && (DataTypeHelper.isBooleanWrapperType((IJstType)expectedType) || TranslateHelper.isObjectType(expectedType) || expectedType instanceof JstParamType)) {
            return true;
        }
        return !(!DataTypeHelper.isNumericPrimitiveType((IJstType)actualType) && !DataTypeHelper.isCharPrimitiveType((IJstType)actualType) || !DataTypeHelper.isCharWrapperType((IJstType)expectedType) && !TranslateHelper.isObjectType(expectedType) && !(expectedType instanceof JstParamType));
    }

    public IExpr autoBoxing(IExpr expr, IJstType expectedType) {
        if (!this.needAutoBoxing(expr, expectedType)) {
            return expr;
        }
        return this.box(expr, expectedType);
    }

    private boolean forceBoxing(IExpr expr, IJstType expectedType) {
        if (expr == null || expectedType == null) {
            return false;
        }
        return expr instanceof JstArrayInitializer;
    }

    private IExpr box(IExpr expr, IJstType expectedType) {
        if (expr instanceof JstArrayInitializer) {
            return this.box((JstArrayInitializer)expr, expectedType);
        }
        if (expr instanceof AssignExpr) {
            IExpr newExpr;
            AssignExpr assignExpr = (AssignExpr)expr;
            IExpr e = assignExpr.getExpr();
            if (this.needAutoBoxing(e, expectedType) && (newExpr = this.box(e, expectedType)) != e) {
                assignExpr.setExpr(newExpr);
            }
            return expr;
        }
        if (expr instanceof MtdInvocationExpr) {
            IJstNode binding;
            MtdInvocationExpr mtdExpr = (MtdInvocationExpr)expr;
            if (mtdExpr.getMethodIdentifier() instanceof JstIdentifier && (binding = ((JstIdentifier)mtdExpr.getMethodIdentifier()).getJstBinding()) instanceof JstMethod) {
                JstMethod jstMtd = (JstMethod)binding;
                JstArg expectedArg = null;
                int i = 0;
                while (i < mtdExpr.getArgs().size()) {
                    IExpr newExpr;
                    IExpr actualArg = (IExpr)mtdExpr.getArgs().get(i);
                    if (i < jstMtd.getArgs().size()) {
                        expectedArg = (JstArg)jstMtd.getArgs().get(i);
                    }
                    if (expectedArg != null && this.needAutoBoxing(actualArg, expectedArg.getType()) && (newExpr = this.box(actualArg, expectedArg.getType())) != actualArg) {
                        mtdExpr.setArg(i, newExpr);
                    }
                    ++i;
                }
            }
            if (this.needAutoBoxing(expr.getResultType(), expectedType)) {
                return this.doIt(expr, expectedType);
            }
            return expr;
        }
        return this.doIt(expr, expectedType);
    }

    private IExpr box(JstArrayInitializer arrayInitializer, IJstType expectedType) {
        List exprs = arrayInitializer.getExprs();
        if (exprs == null) {
            return arrayInitializer;
        }
        int i = 0;
        while (i < exprs.size()) {
            IExpr expr = (IExpr)exprs.get(i);
            IExpr newExpr = this.autoBoxing(expr, expectedType);
            if (newExpr != expr) {
                exprs.set(i, newExpr);
            }
            ++i;
        }
        return arrayInitializer;
    }

    private IExpr doIt(IExpr expr, IJstType expectedType) {
        String name;
        IJstNode parentNode = expr.getParentNode();
        IJstType toType = this.getExpectedType(expectedType);
        if (toType instanceof JstParamType || TranslateHelper.isObjectType(toType)) {
            name = DataTypeHelper.getWrapperTypeName((String)expr.getResultType().getSimpleName(), (boolean)true);
            if (parentNode.getRootType() instanceof JstType) {
                toType = JstCache.getInstance().getType(name, true);
                JstType ownerType = (JstType)parentNode.getRootType();
                ownerType.addImport(toType);
            }
        }
        name = null;
        String origialName = toType.getName();
        if (DataTypeHelper.getNativeType((String)origialName) != null || DataTypeHelper.isJavaMappedToNative((String)origialName)) {
            name = DataTypeHelper.getTypeName((String)origialName);
        } else if (parentNode instanceof BaseJstNode) {
            JstIdentifier jstQualifier = VjoTranslateHelper.getStaticTypeQualifier(toType, (BaseJstNode)parentNode);
            name = String.valueOf(jstQualifier == null ? "" : String.valueOf(jstQualifier.getName()) + ".") + toType.getSimpleName();
        }
        if (name == null) {
            return expr;
        }
        JstIdentifier mtdIdentifier = new JstIdentifier(name);
        mtdIdentifier.setJstBinding((IJstNode)new JstConstructor(new JstArg[]{new JstArg(expr.getResultType(), "value", false)}));
        MtdInvocationExpr mtdCall = new MtdInvocationExpr(mtdIdentifier, new IExpr[0]);
        mtdCall.setResultType(toType);
        mtdCall.addArg(expr);
        ObjCreationExpr objCreationExpr = new ObjCreationExpr(mtdCall);
        objCreationExpr.setParent(parentNode);
        return objCreationExpr;
    }

    private IJstType getExpectedType(IJstType expectedType) {
        if (expectedType == null) {
            return null;
        }
        if (expectedType instanceof JstArray) {
            return ((JstArray)expectedType).getComponentType();
        }
        return expectedType;
    }

    private boolean isNull(IExpr expr) {
        return expr == null || "null".equals(expr.toExprText());
    }
}

