/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.jdk;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.jdk.ObjectPrivilegedProcessorAdapter;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.BaseCustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomField;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomMethod;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomType;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.ICustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.PrivilegedProcessorAdapter;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class JavaLangMeta
extends BaseCustomMetaProvider
implements ICustomMetaProvider {
    private static JavaLangMeta s_instance = new JavaLangMeta();
    private static boolean m_initialized = false;
    private static final String VJOX = VjoConvention.getVjoExtScope();
    private static final String ORG_ECLIPSE = "org.eclipse.vjet.";
    public static final String VJO_OBJECT = "vjo.Object";
    public static final String VJO_CLASS = "vjo.Class";
    public static final String VJO_ENUM = "vjo.Enum";
    private static String NUMBER_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Number";
    private static String INTEGER_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Integer";
    private static String SHORT_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Short";
    private static String LONG_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Long";
    private static String BYTE_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Byte";
    private static String FLOAT_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Float";
    private static String DOUBLE_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Double";
    private static String CHARACTER_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Character";
    private static String COMPARABLE_PKG = "org.eclipse.vjet." + VJOX + ".java.lang.Comparable";
    private static final String VJO_JAVA_LANG_MATH = "org.eclipse.vjet." + VJOX + ".java.lang.Math";
    private static final String ARRAYLIST = "org.eclipse.vjet." + VJOX + ".java.util.ArrayList";
    private static String VJO_PKG = "org.eclipse.vjet." + VJOX + ".";
    private static String COLLECTIONS_TYPE_NAME = "org.eclipse.vjet." + VJOX + ".java.util.Collections";
    private static String STRING_UTIL_TYPE_NAME = "org.eclipse.vjet." + VJOX + ".java.lang.StringUtil";
    private static String OBJECT_UTIL_TYPE_NAME = "org.eclipse.vjet." + VJOX + ".java.lang.ObjectUtil";
    private static String CLASS_UTIL_TYPE_NAME = "org.eclipse.vjet." + VJOX + ".java.lang.ClassUtil";
    private static String NUMBER_UTIL_TYPE_NAME = "org.eclipse.vjet." + VJOX + ".java.lang.NumberUtil";
    private static String DATE_UTIL_TYPE_NAME = "org.eclipse.vjet." + VJOX + ".java.lang.DateUtil";
    private static String BOOLEAN_UTIL_TYPE_NAME = "org.eclipse.vjet." + VJOX + ".java.lang.BooleanUtil";

    private JavaLangMeta() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaLangMeta getInstance() {
        if (!m_initialized) {
            JavaLangMeta javaLangMeta = s_instance;
            synchronized (javaLangMeta) {
                if (!m_initialized) {
                    s_instance.init();
                    m_initialized = true;
                }
            }
        }
        return s_instance;
    }

    private void init() {
        this.loadStringType();
        this.loadBooleanType();
        this.loadNumberType();
        this.loadIntegerType();
        this.loadFloatType();
        this.loadDoubleType();
        this.loadLongType();
        this.loadShortType();
        this.loadByteType();
        this.loadCharacterType();
        this.loadCharSequenceType();
        this.loadClassType();
        this.loadMathType();
        this.loadObjectType();
        this.loadEnumType();
        this.loadEnumSet();
        this.loadEnumMap();
        this.loadStringBufferType();
        this.loadStringBuilderType();
        this.loadSystem();
        this.loadComparableType();
        this.loadNullPointerException();
        this.loadIllegalArgumentException();
        this.loadThrowableType();
        this.loadExceptionType();
        this.loadRuntimeExceptionType();
        this.loadCloneNotSupportedExceptionType();
        this.loadArrayType();
        this.loadError();
        this.loadIllegalAccessException();
        this.loadNoSuchFieldException();
        this.loadOutOfMemoryError();
        this.loadUnsupportedOperationException();
        this.loadNumberFormatException();
        this.loadArithmeticException();
        this.loadArrayIndexOutOfBoundsException();
        this.loadIndexOutOfBoundsException();
        this.loadStringIndexOutOfBoundsException();
        this.loadInstantiationException();
        this.loadConcurrentModificationException();
        this.loadIllegalStateException();
        this.loadNoSuchElementException();
        this.loadArrayStoreException();
        this.loadClassCastException();
        this.loadList();
        this.loadVector();
        this.loadArrayList();
        this.loadLinkedList();
        this.loadSet();
        this.loadHashSet();
        this.loadLinkedHashSet();
        this.loadCollection();
        this.loadEnumeration();
        this.loadIterator();
        this.loadListIterator();
        this.loadCollections();
        this.loadArrays();
        this.loadStack();
        this.loadStringTokenizer();
        this.loadAbstractCollection();
        this.loadMapEntry();
        this.loadTreeSet();
        this.loadTreeMap();
        this.loadSortedSet();
        this.loadSortedMap();
        this.loadComparator();
        this.loadRandom();
        this.loadDate();
        this.loadMap();
        this.loadProperties();
        this.loadHashMap();
        this.loadHashtable();
        this.loadLinkedHashMap();
        this.loadIdentityHashMap();
        this.loadQueue();
        this.loadPriorityQueue();
        this.loadPrintStream();
        this.loadPrintWriter();
        this.loadInputStream();
        this.loadFileInputStream();
        this.loadOutputStream();
        this.loadFileOutputStream();
    }

    private void loadStringType() {
        Class<String> type = String.class;
        CustomType cType = new CustomType(type).setAttr(CustomAttr.MAPPED_TO_JS).addCustomMethod("charAt", "charAt").addCustomMethod("codePointAt", "charCodeAt").addCustomMethod("concat", "concat").addCustomMethod("indexOf", "indexOf").addCustomMethod("lastIndexOf", "lastIndexOf").addCustomMethod("length", "length", true).addCustomMethod("replaceFirst", "replace").addCustomMethod("split", "split").addCustomMethod("substring", "substring").addCustomMethod("String", "build", ORG_ECLIPSE + VJOX + ".java.lang.StringFactory").addCustomMethod("compareTo", "compareTo", STRING_UTIL_TYPE_NAME).addCustomMethod("compareToIgnoreCase", "compareToIgnoreCase", STRING_UTIL_TYPE_NAME).addCustomMethod("endsWith", "endsWith", STRING_UTIL_TYPE_NAME).addCustomMethod("equalsIgnoreCase", "equalsIgnoreCase", STRING_UTIL_TYPE_NAME).addCustomMethod("getBytes", "getBytes", STRING_UTIL_TYPE_NAME).addCustomMethod("getChars", "getChars", STRING_UTIL_TYPE_NAME).addCustomMethod("intern", "intern", STRING_UTIL_TYPE_NAME).addCustomMethod("regionMatches", "regionMatches", STRING_UTIL_TYPE_NAME).addCustomMethod("startsWith", "startsWith", STRING_UTIL_TYPE_NAME).addCustomMethod("toCharArray", "toCharArray", STRING_UTIL_TYPE_NAME).addCustomMethod("toLowerCase", "toLowerCase", STRING_UTIL_TYPE_NAME).addCustomMethod("toUpperCase", "toUpperCase", STRING_UTIL_TYPE_NAME).addCustomMethod("trim", "trim", STRING_UTIL_TYPE_NAME).addCustomMethod("contentEquals", "contentEquals", STRING_UTIL_TYPE_NAME).addCustomMethod("matches", "matches", STRING_UTIL_TYPE_NAME).addCustomMethod("replace", "replace", STRING_UTIL_TYPE_NAME).addCustomMethod("replaceAll", "replaceAll", STRING_UTIL_TYPE_NAME).addCustomMethod("subSequence", "subSequence", STRING_UTIL_TYPE_NAME).addCustomMethod("codePointBefore", "codePointBefore", STRING_UTIL_TYPE_NAME).addCustomMethod("codePointCount", "codePointCount", STRING_UTIL_TYPE_NAME).addCustomMethod("offsetByCodePoints", "offsetByCodePoints", STRING_UTIL_TYPE_NAME).addCustomMethod("contains", "contains", STRING_UTIL_TYPE_NAME).addCustomMethod("valueOf", "_valueOf", STRING_UTIL_TYPE_NAME).addCustomMethod(new CustomMethod("toString").setAttr(CustomAttr.JAVA_ONLY)).addCustomMethod(new CustomMethod("getBytes").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getSimpleName(), cType);
        this.addCustomType(type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
        this.addObjectUtilMethods(type.getSimpleName());
    }

    private void loadBooleanType() {
        Class<Boolean> type = Boolean.class;
        CustomType cType = new CustomType(type).setAttr(CustomAttr.MAPPED_TO_JS).addCustomMethod("booleanValue", "booleanValue", BOOLEAN_UTIL_TYPE_NAME).addCustomMethod("getBoolean", "getBoolean", BOOLEAN_UTIL_TYPE_NAME).addCustomMethod("parseBoolean", "parseBoolean", BOOLEAN_UTIL_TYPE_NAME).addCustomMethod("toBoolean", "toBoolean", BOOLEAN_UTIL_TYPE_NAME).addCustomMethod("toString", "toString", BOOLEAN_UTIL_TYPE_NAME).addCustomMethod("valueOf", "valueOf_", BOOLEAN_UTIL_TYPE_NAME).addCustomMethod("compareTo", "compareTo", OBJECT_UTIL_TYPE_NAME).addCustomMethod("equals", "equals", OBJECT_UTIL_TYPE_NAME).addCustomMethod("hashCode", "hashCode", OBJECT_UTIL_TYPE_NAME).addCustomMethod("Boolean", "valueOf_", BOOLEAN_UTIL_TYPE_NAME).addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomField(new CustomField("TRUE").setAttr(CustomAttr.MAPPED_TO_VJO).setJstName("TRUE").setJstTypeName(type.getName()).setJstOwnerTypeName(BOOLEAN_UTIL_TYPE_NAME)).addCustomField(new CustomField("FALSE").setAttr(CustomAttr.MAPPED_TO_VJO).setJstName("FALSE").setJstTypeName(type.getName()).setJstOwnerTypeName(BOOLEAN_UTIL_TYPE_NAME)).addCustomField(new CustomField("TYPE").setAttr(CustomAttr.MAPPED_TO_VJO).setJstName("TRUE").setJstTypeName(type.getName()).setJstOwnerTypeName(BOOLEAN_UTIL_TYPE_NAME));
        this.addCustomType(type.getSimpleName(), cType);
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadNumberType() {
        Class<Number> type = Number.class;
        CustomType cType = new CustomType(type, NUMBER_PKG).addCustomMethod(new CustomMethod("getInteger").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(NUMBER_PKG, cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadIntegerType() {
        Class<Integer> type = Integer.class;
        String[] params1 = new String[]{"String nm"};
        MethodKey key1 = new MethodKey("getInteger", true, params1);
        String[] params2 = new String[]{"String nm", "int val"};
        MethodKey key2 = new MethodKey("getInteger", true, params2);
        String[] params3 = new String[]{"String nm", "Integer val"};
        MethodKey key3 = new MethodKey("getInteger", true, params3);
        CustomType cType = new CustomType(type, INTEGER_PKG).addCustomField(new CustomField("TYPE").setAttr(CustomAttr.EXCLUDED)).addCustomMethod("myParseInt", "parseInteger", NUMBER_UTIL_TYPE_NAME).addCustomMethod(new CustomMethod(key1).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key2).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key3).setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(INTEGER_PKG, cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadDoubleType() {
        Class<Double> type = Double.class;
        CustomType cType = new CustomType(type, DOUBLE_PKG).addCustomField(new CustomField("TYPE").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("myParseDouble", "Number").setJstReturnTypeName("double").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("parseFD", "Number").setJstReturnTypeName("double").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myIsFinite", "isFinite").setJstReturnTypeName("boolean").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myIsNaN", "isNaN").setJstReturnTypeName("boolean").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myToHexString", "org.eclipse.vjet.vjo.java.lang.MathUtil.dec2Hex").setJstReturnTypeName("String").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("doubleToLongBits").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("doubleToRawLongBits").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("longBitsToDouble").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("rawCopySign").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getExponent").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadLongType() {
        Class<Long> type = Long.class;
        CustomType cType = new CustomType(type, LONG_PKG).addCustomField(new CustomField("TYPE").setAttr(CustomAttr.EXCLUDED)).addCustomMethod("myParseLong", "parseLong", NUMBER_UTIL_TYPE_NAME);
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadShortType() {
        Class<Short> type = Short.class;
        CustomType cType = new CustomType(type, SHORT_PKG).addCustomField(new CustomField("TYPE").setAttr(CustomAttr.EXCLUDED)).addCustomMethod("myParseShort", "parseShort", NUMBER_UTIL_TYPE_NAME);
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadByteType() {
        Class<Byte> type = Byte.class;
        CustomType cType = new CustomType(type, BYTE_PKG).addCustomField(new CustomField("TYPE").setAttr(CustomAttr.EXCLUDED)).addCustomMethod("myParseByte", "parseByte", NUMBER_UTIL_TYPE_NAME);
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadCharacterType() {
        Class<Character> type = Character.class;
        CustomType cType = new CustomType(type, CHARACTER_PKG).addCustomField(new CustomField("TYPE").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadFloatType() {
        Class<Float> type = Float.class;
        String[] params1 = new String[]{"double value"};
        MethodKey key1 = new MethodKey("Float", false, params1);
        CustomType cType = new CustomType(type, FLOAT_PKG).addCustomField(new CustomField("TYPE").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("myParseFloat", "Number").setJstReturnTypeName("float").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myToHexString", "org.eclipse.vjet.vjo.java.lang.MathUtil.dec2Hex").setJstReturnTypeName("String").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myIsNaN", "isNaN").setJstReturnTypeName("boolean").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod(key1).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("floatToIntBits").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("floatToRawIntBits").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("intBitsToFloat").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadCharSequenceType() {
        Class<CharSequence> type = CharSequence.class;
        CustomType cType = new CustomType(type, String.valueOf(VJOX) + ".java.lang.CharSequence").setAttr(CustomAttr.MAPPED_TO_VJO);
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadArrayType() {
        Class<Array> type = Array.class;
        CustomType cType = new CustomType(type, String.valueOf(VJOX) + ".java.lang.reflect.Array");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadClassType() {
        Class<Class> type = Class.class;
        CustomType cType = new CustomType(type, VJO_CLASS).setAttr(CustomAttr.MAPPED_TO_VJO).addCustomMethod("getEnumConstants", "getEnumConstants", CLASS_UTIL_TYPE_NAME).addCustomMethod("getSuperclass", "getSuperclass", CLASS_UTIL_TYPE_NAME).addCustomMethod(new CustomMethod("asSubclass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("cast").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("desiredAssertionStatus").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("forName").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getAnnotation").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getAnnotations").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getCanonicalName").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getClasses").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getClassLoader").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getComponentType").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getConstructor").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getConstructors").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaredAnnotations").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaredClasses").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaredConstructor").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaredConstructors").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaredField").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaredFields").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaredMethod").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaredMethods").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getDeclaringClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getEnclosingClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getEnclosingConstructor").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getEnclosingMethod").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getField").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getFields").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getGenericInterfaces").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getGenericSuperclass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getInterfaces").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getMethod").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getMethods").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getModifiers").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getPackage").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getProtectionDomain").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getResource").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getResourceAsStream").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getSigners").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getTypeParameters").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isAnnotation").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isAnnotationPresent").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isAnonymousClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isArray").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isAssignableFrom").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isEnum").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isLocalClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isMemberClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isPrimitive").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("isSynthetic").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("newInstance").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(VJO_CLASS, cType);
        this.addCustomType(type.getName(), cType);
    }

    private void loadThrowableType() {
        Class<Throwable> type = Throwable.class;
        CustomType cType = new CustomType(type, String.valueOf(VJOX) + ".java.lang.Throwable");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadExceptionType() {
        Class<Exception> type = Exception.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.Exception");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadRuntimeExceptionType() {
        Class<RuntimeException> type = RuntimeException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.RuntimeException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadCloneNotSupportedExceptionType() {
        Class<CloneNotSupportedException> type = CloneNotSupportedException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.CloneNotSupportedException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadMathType() {
        Class<Math> type = Math.class;
        String[] params2 = new String[]{"float f"};
        MethodKey key2 = new MethodKey("abs", true, params2);
        String[] params3 = new String[]{"int i"};
        MethodKey key3 = new MethodKey("abs", true, params3);
        String[] params4 = new String[]{"long l"};
        MethodKey key4 = new MethodKey("abs", true, params4);
        String[] params6 = new String[]{"float f1", "float f2"};
        MethodKey key6 = new MethodKey("max", true, params6);
        String[] params7 = new String[]{"int i1", "int i2"};
        MethodKey key7 = new MethodKey("max", true, params7);
        String[] params8 = new String[]{"long l1", "long l2"};
        MethodKey key8 = new MethodKey("max", true, params8);
        String[] params10 = new String[]{"float f1", "float f2"};
        MethodKey key10 = new MethodKey("min", true, params10);
        String[] params11 = new String[]{"int i1", "int i2"};
        MethodKey key11 = new MethodKey("min", true, params11);
        String[] params12 = new String[]{"long l1", "long l2"};
        MethodKey key12 = new MethodKey("min", true, params12);
        String[] params14 = new String[]{"float f"};
        MethodKey key14 = new MethodKey("round", true, params14);
        String[] params16 = new String[]{"float f"};
        MethodKey key16 = new MethodKey("signum", true, params16);
        CustomType cType = new CustomType(type, VJO_JAVA_LANG_MATH).addCustomField(new CustomField("E_").setAttr(CustomAttr.MAPPED_TO_JS).setJstOwnerTypeName("Math").setJstName("E").setJstTypeName(type.getName())).addCustomField(new CustomField("PI_").setAttr(CustomAttr.MAPPED_TO_JS).setJstOwnerTypeName("Math").setJstName("PI").setJstTypeName(type.getName())).addCustomMethod(new CustomMethod("myAbs", "Math.abs").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myMax", "Math.max").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myMin", "Math.min").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myRandom", "Math.random").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myRound", "Math.round").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myPow", "Math.pow").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("mySqrt", "Math.sqrt").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("mySin", "Math.sin").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myCos", "Math.cos").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myTan", "Math.tan").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myFloor", "Math.floor").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myCeil", "Math.ceil").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myExp", "Math.exp").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myLog", "Math.log").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myAtan", "Math.atan").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myAsin", "Math.asin").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myAcos", "Math.acos").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("myAtan2", "Math.atan2").setAttr(CustomAttr.MAPPED_TO_JS)).addCustomMethod(new CustomMethod("mySignum", "org.eclipse.vjet.vjo.java.lang.MathUtil.signum").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myLog10", "org.eclipse.vjet.vjo.java.lang.MathUtil.log10").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myCbrt", "org.eclipse.vjet.vjo.java.lang.MathUtil.cbrt").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("mySinh", "org.eclipse.vjet.vjo.java.lang.MathUtil.sinh").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myCosh", "org.eclipse.vjet.vjo.java.lang.MathUtil.cosh").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myTanh", "org.eclipse.vjet.vjo.java.lang.MathUtil.tanh").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myHypot", "org.eclipse.vjet.vjo.java.lang.MathUtil.hypot").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myExpm1", "org.eclipse.vjet.vjo.java.lang.MathUtil.expm1").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myLog1p", "org.eclipse.vjet.vjo.java.lang.MathUtil.log1p").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod("myRint", "org.eclipse.vjet.vjo.java.lang.MathUtil.rint").setAttr(CustomAttr.MAPPED_TO_VJO)).addCustomMethod(new CustomMethod(key2).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key3).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key4).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key6).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key7).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key8).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key10).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key11).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key12).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key14).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(key16).setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("ulp").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(VJO_JAVA_LANG_MATH, cType);
    }

    private void loadSystem() {
        Class<System> type = System.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.System").addCustomField(new CustomField("TYPE").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadObjectType() {
        Class<Object> type = Object.class;
        CustomType cType = new CustomType(type, VJO_OBJECT).setAttr(CustomAttr.MAPPED_TO_VJO).addCustomMethod("equals", "equals", OBJECT_UTIL_TYPE_NAME).addCustomMethod("hashCode", "hashCode", OBJECT_UTIL_TYPE_NAME).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("finalize").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(VJO_OBJECT, cType);
        this.addCustomType(type.getName(), cType);
    }

    private void loadComparableType() {
        Class<Comparable> type = Comparable.class;
        CustomType cType = new CustomType(type, COMPARABLE_PKG).setAttr(CustomAttr.MAPPED_TO_VJO).addCustomMethod("compareTo", "compareTo", OBJECT_UTIL_TYPE_NAME);
        this.addCustomType(COMPARABLE_PKG, cType);
        this.addCustomType(type.getName(), cType);
    }

    private void loadEnumType() {
        Class<Enum> type = Enum.class;
        CustomType cType = new CustomType(type, VJO_ENUM).setAttr(CustomAttr.MAPPED_TO_VJO);
        this.addCustomType(VJO_ENUM, cType);
        this.addCustomType(type.getName(), cType);
    }

    private void loadNullPointerException() {
        Class<NullPointerException> type = NullPointerException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.NullPointerException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadIllegalArgumentException() {
        Class<IllegalArgumentException> type = IllegalArgumentException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.IllegalArgumentException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadError() {
        Class<Error> type = Error.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.Error");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadIllegalAccessException() {
        Class<IllegalAccessException> type = IllegalAccessException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.IllegalAccessException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadNoSuchFieldException() {
        Class<NoSuchFieldException> type = NoSuchFieldException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.NoSuchFieldException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadOutOfMemoryError() {
        Class<OutOfMemoryError> type = OutOfMemoryError.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.OutOfMemoryError");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadNumberFormatException() {
        Class<NumberFormatException> type = NumberFormatException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.NumberFormatException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadUnsupportedOperationException() {
        Class<UnsupportedOperationException> type = UnsupportedOperationException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.UnsupportedOperationException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadArithmeticException() {
        Class<ArithmeticException> type = ArithmeticException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.ArithmeticException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadArrayIndexOutOfBoundsException() {
        Class<ArrayIndexOutOfBoundsException> type = ArrayIndexOutOfBoundsException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.ArrayIndexOutOfBoundsException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadIndexOutOfBoundsException() {
        Class<IndexOutOfBoundsException> type = IndexOutOfBoundsException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.IndexOutOfBoundsException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadStringIndexOutOfBoundsException() {
        Class<StringIndexOutOfBoundsException> type = StringIndexOutOfBoundsException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.StringIndexOutOfBoundsException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadInstantiationException() {
        Class<InstantiationException> type = InstantiationException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.InstantiationException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadConcurrentModificationException() {
        Class<ConcurrentModificationException> type = ConcurrentModificationException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.ConcurrentModificationException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadIllegalStateException() {
        Class<IllegalStateException> type = IllegalStateException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.IllegalStateException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadNoSuchElementException() {
        Class<NoSuchElementException> type = NoSuchElementException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.NoSuchElementException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadArrayStoreException() {
        Class<ArrayStoreException> type = ArrayStoreException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.ArrayStoreException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadClassCastException() {
        Class<ClassCastException> type = ClassCastException.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.lang.ClassCastException");
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadStringBufferType() {
        Class<StringBuffer> type = StringBuffer.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + "." + type.getName());
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadStringBuilderType() {
        Class<StringBuilder> type = StringBuilder.class;
        String[] params1 = new String[]{"char ch"};
        MethodKey mtdKey1 = new MethodKey("append", false, params1);
        String[] params2 = new String[]{"char chars[]"};
        MethodKey mtdKey2 = new MethodKey("append", false, params2);
        String[] params3 = new String[]{"int index", "char[] chars"};
        MethodKey mtdKey3 = new MethodKey("insert", false, params3);
        String[] params4 = new String[]{"int index", "char ch"};
        MethodKey mtdKey4 = new MethodKey("insert", false, params4);
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + "." + type.getName()).addCustomMethod(new CustomMethod(mtdKey1, "append").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(mtdKey2, "append").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(mtdKey3, "insert").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod(mtdKey4, "insert").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadHashMap() {
        Class<HashMap> type = HashMap.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.HashMap").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadVector() {
        Class<Vector> type = Vector.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Vector").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadArrayList() {
        Class<ArrayList> type = ArrayList.class;
        CustomType cType = new CustomType(type, ARRAYLIST).addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(ARRAYLIST, cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void addObjectUtilMethods(String typeName) {
        ObjectPrivilegedProcessorAdapter objectPrivilegedProcessorAdapter = new ObjectPrivilegedProcessorAdapter();
        this.addPrivilegedMethodProcessor(typeName, "equals", objectPrivilegedProcessorAdapter);
        this.addPrivilegedMethodProcessor(typeName, "hashCode", objectPrivilegedProcessorAdapter);
    }

    private void loadHashtable() {
        Class<Hashtable> type = Hashtable.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Hashtable").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadHashSet() {
        Class<HashSet> type = HashSet.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.HashSet").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadSet() {
        Class<Set> type = Set.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Set").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadMap() {
        Class<Map> type = Map.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Map").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadList() {
        Class<List> type = List.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.List").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadCollection() {
        Class<Collection> type = Collection.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Collection").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadEnumeration() {
        Class<Enumeration> type = Enumeration.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Enumeration").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadIterator() {
        Class<Iterator> type = Iterator.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Iterator").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadListIterator() {
        Class<ListIterator> type = ListIterator.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.ListIterator").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadCollections() {
        Class<Collections> type = Collections.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Collections").addCustomMethod("singleton", "singletonSet", COLLECTIONS_TYPE_NAME).addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadArrays() {
        Class<Arrays> type = Arrays.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Arrays").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadStack() {
        Class<Stack> type = Stack.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Stack").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadProperties() {
        Class<Properties> type = Properties.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Properties").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadStringTokenizer() {
        Class<StringTokenizer> type = StringTokenizer.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.StringTokenizer").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadAbstractCollection() {
        Class<AbstractCollection> type = AbstractCollection.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.AbstractCollection").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadMapEntry() {
        Class<Map.Entry> type = Map.Entry.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Map.Entry").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType("java.util.Map.Entry", cType);
        this.addCustomType("Map.Entry", cType);
        this.addCustomType(String.valueOf(VJO_PKG) + "java.util.Map.Entry", cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadComparator() {
        Class<Comparator> type = Comparator.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Comparator").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadRandom() {
        Class<Random> type = Random.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Random").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadDate() {
        final Class<Date> type = Date.class;
        CustomType cType = new CustomType(type).setAttr(CustomAttr.MAPPED_TO_JS).addCustomMethod("after", "after", DATE_UTIL_TYPE_NAME).addCustomMethod("before", "before", DATE_UTIL_TYPE_NAME).addCustomMethod("compareTo", "compareTo", DATE_UTIL_TYPE_NAME).addCustomMethod("getMillisOf", "getMillisOf", DATE_UTIL_TYPE_NAME).addCustomMethod("getTimezoneOffset", "getTimezoneOffset", DATE_UTIL_TYPE_NAME).addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getSimpleName(), cType);
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addPrivilegedConstructorProcessor(type.getName(), new PrivilegedProcessorAdapter(){

            @Override
            public IExpr processInstanceCreation(ClassInstanceCreation cic, BaseJstNode jstNode, List<IExpr> argExprList, CustomType clientType) {
                int argCount = argExprList.size();
                IExpr[] newArgs = new IExpr[argCount];
                if (argCount == 3 || argCount == 5 || argCount == 6) {
                    int i = 0;
                    while (i < argExprList.size()) {
                        if (i == 0) {
                            InfixExpr expr = new InfixExpr(argExprList.get(i), (IExpr)new TextExpr("1900"), InfixExpr.Operator.PLUS);
                            newArgs[i] = expr;
                        } else {
                            newArgs[i] = argExprList.get(i);
                        }
                        ++i;
                    }
                    ObjCreationExpr objExpr = TranslateHelper.Expression.createObjCreationExpr(type.getName(), newArgs);
                    return objExpr;
                }
                return null;
            }
        });
        this.addPrivilegedMethodProcessor(type.getName(), "setYear", new PrivilegedProcessorAdapter(){

            @Override
            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (optionalExpr == null) {
                    return null;
                }
                ArrayList<InfixExpr> newArgs = new ArrayList<InfixExpr>(1);
                InfixExpr expr = new InfixExpr(args.get(0), (IExpr)new TextExpr("1900"), InfixExpr.Operator.PLUS);
                newArgs.add(expr);
                IJstType qualifierType = optionalExpr.getResultType();
                if (qualifierType == null) {
                    return null;
                }
                if (qualifierType instanceof JstArray) {
                    return null;
                }
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(new JstIdentifier(identifier.getName()), new IExpr[0]);
                mtdCall.setQualifyExpr(optionalExpr);
                mtdCall.setArgs(newArgs);
                return mtdCall;
            }
        });
        this.addObjectUtilMethods(type.getName());
    }

    private void loadTreeSet() {
        Class<TreeSet> type = TreeSet.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.TreeSet").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadSortedSet() {
        Class<SortedSet> type = SortedSet.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.SortedSet").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadTreeMap() {
        Class<TreeMap> type = TreeMap.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.TreeMap").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadLinkedHashMap() {
        Class<LinkedHashMap> type = LinkedHashMap.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.LinkedHashMap").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadIdentityHashMap() {
        Class<IdentityHashMap> type = IdentityHashMap.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.IdentityHashMap").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadEnumSet() {
        Class<EnumSet> type = EnumSet.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.EnumSet").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadEnumMap() {
        Class<EnumMap> type = EnumMap.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.EnumMap").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadQueue() {
        Class<Queue> type = Queue.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.Queue").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadPriorityQueue() {
        Class<PriorityQueue> type = PriorityQueue.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.PriorityQueue").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadLinkedHashSet() {
        Class<LinkedHashSet> type = LinkedHashSet.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.LinkedHashSet").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadLinkedList() {
        Class<LinkedList> type = LinkedList.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.LinkedList").addCustomMethod(new CustomMethod("clone").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
        this.addObjectUtilMethods(type.getName());
    }

    private void loadSortedMap() {
        Class<SortedMap> type = SortedMap.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.util.SortedMap").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadPrintStream() {
        Class<PrintStream> type = PrintStream.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.io.PrintStream").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadPrintWriter() {
        Class<PrintWriter> type = PrintWriter.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.io.PrintWriter").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadInputStream() {
        Class<InputStream> type = InputStream.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.io.InputStream").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadOutputStream() {
        Class<OutputStream> type = OutputStream.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.io.OutputStream").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadFileOutputStream() {
        Class<FileOutputStream> type = FileOutputStream.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.io.FileOutputStream").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }

    private void loadFileInputStream() {
        Class<FileInputStream> type = FileInputStream.class;
        CustomType cType = new CustomType(type, ORG_ECLIPSE + VJOX + ".java.io.FileInputStream").addCustomMethod(new CustomMethod("getClass").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("wait").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notify").setAttr(CustomAttr.EXCLUDED)).addCustomMethod(new CustomMethod("notifyAll").setAttr(CustomAttr.EXCLUDED));
        this.addCustomType(type.getName(), cType);
        this.addCustomType(String.valueOf(VJO_PKG) + type.getName(), cType);
    }
}

