/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.anno;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.vjet.dsf.javatojs.anno.ACustomizedAs;
import org.eclipse.vjet.dsf.javatojs.anno.AExclude;
import org.eclipse.vjet.dsf.javatojs.anno.AForceFullyQualified;
import org.eclipse.vjet.dsf.javatojs.anno.AJavaOnly;
import org.eclipse.vjet.dsf.javatojs.anno.AJsProxy;
import org.eclipse.vjet.dsf.javatojs.anno.AMappedToJS;
import org.eclipse.vjet.dsf.javatojs.anno.AMappedToVJO;
import org.eclipse.vjet.dsf.javatojs.anno.AProperty;
import org.eclipse.vjet.dsf.javatojs.anno.ARename;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.javatojs.translate.custom.anno.BaseAnnoProcessor;
import org.eclipse.vjet.dsf.javatojs.translate.custom.anno.IAnnoProcessor;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.BaseCustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomField;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomMethod;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomType;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.ICustomMetaProvider;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class DefaultAnnoProcessor
extends BaseAnnoProcessor
implements IAnnoProcessor {
    private ICustomMetaProvider m_metaProvider = new MetaProvider();
    private static final String ANNO_NAME = "name";
    private static final String ANNO_VALUE = "value";

    @Override
    public CustomInfo process(ASTNode astNode, JstType jstType) {
        List<Annotation> annos = this.getAnnotations(astNode);
        if (annos.isEmpty()) {
            return null;
        }
        CustomInfo cInfo = new CustomInfo();
        boolean forceFullyQualified = false;
        for (Annotation anno : annos) {
            String annoName = anno.getTypeName().toString();
            if (annoName.equals(AExclude.class.getSimpleName())) {
                cInfo.setAttr(CustomAttr.EXCLUDED);
                continue;
            }
            if (annoName.equals(AJavaOnly.class.getSimpleName())) {
                cInfo.setAttr(CustomAttr.JAVA_ONLY);
                continue;
            }
            if (annoName.equals(AJsProxy.class.getSimpleName())) {
                cInfo.setAttr(CustomAttr.JS_PROXY);
                continue;
            }
            if (annoName.equals(AMappedToJS.class.getSimpleName())) {
                cInfo.setAttr(CustomAttr.MAPPED_TO_JS);
                this.process(astNode, jstType, anno, cInfo);
                continue;
            }
            if (annoName.equals(AMappedToVJO.class.getSimpleName())) {
                cInfo.setAttr(CustomAttr.MAPPED_TO_VJO);
                this.process(astNode, jstType, anno, cInfo);
                continue;
            }
            if (annoName.equals(ACustomizedAs.class.getSimpleName())) {
                for (Object pair : ((NormalAnnotation)anno).values()) {
                    if (!(pair instanceof MemberValuePair)) continue;
                    MemberValuePair mvPair = (MemberValuePair)pair;
                    if (mvPair.getName().toString().equals("type")) {
                        Type asAstType = ((TypeLiteral)mvPair.getValue()).getType();
                        IJstType asJstType = TranslateCtx.ctx().getProvider().getDataTypeTranslator().processType(asAstType, (BaseJstNode)jstType);
                        cInfo.setAsType(asJstType);
                        continue;
                    }
                    if (!mvPair.getName().toString().equals(ANNO_NAME)) continue;
                    cInfo.setAsName(((StringLiteral)mvPair.getValue()).getLiteralValue());
                }
                continue;
            }
            if (annoName.equals(ARename.class.getSimpleName())) {
                this.process(astNode, jstType, anno, cInfo);
                continue;
            }
            if (annoName.equals(AProperty.class.getSimpleName())) {
                if (!(astNode instanceof MethodDeclaration)) continue;
                this.genMetaForPty((MethodDeclaration)astNode, jstType, anno);
                continue;
            }
            if (!annoName.equals(AForceFullyQualified.class.getSimpleName()) || !(astNode instanceof MethodDeclaration)) continue;
            forceFullyQualified = TranslateHelper.isStatic(((MethodDeclaration)astNode).modifiers());
        }
        if (forceFullyQualified) {
            cInfo.setForceFullyQualify(true);
        }
        return cInfo;
    }

    public ICustomMetaProvider getMetaProvider() {
        return this.m_metaProvider;
    }

    private List<Annotation> getAnnotations(ASTNode astNode) {
        List modifiers = null;
        if (astNode instanceof AbstractTypeDeclaration) {
            modifiers = ((AbstractTypeDeclaration)astNode).modifiers();
        } else if (astNode instanceof FieldDeclaration) {
            modifiers = ((FieldDeclaration)astNode).modifiers();
        } else if (astNode instanceof EnumConstantDeclaration) {
            modifiers = ((EnumConstantDeclaration)astNode).modifiers();
        } else if (astNode instanceof MethodDeclaration) {
            modifiers = ((MethodDeclaration)astNode).modifiers();
        }
        if (modifiers == null || modifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Annotation> annos = new ArrayList<Annotation>();
        for (Object m : modifiers) {
            if (!(m instanceof Annotation)) continue;
            annos.add((Annotation)m);
        }
        return annos;
    }

    private List<MemberValuePair> getAnnoMemberPairs(Annotation anno) {
        if (!(anno instanceof NormalAnnotation)) {
            return Collections.emptyList();
        }
        NormalAnnotation nAnno = (NormalAnnotation)anno;
        ArrayList<MemberValuePair> annoList = new ArrayList<MemberValuePair>();
        for (Object pair : nAnno.values()) {
            MemberValuePair mvPair;
            String name;
            if (!(pair instanceof MemberValuePair) || !ANNO_NAME.equals(name = this.getName(mvPair = (MemberValuePair)pair)) && !ANNO_VALUE.equals(name)) continue;
            annoList.add(mvPair);
        }
        return annoList;
    }

    private String getName(MemberValuePair pair) {
        return pair.getName().toString();
    }

    private String getValue(Expression value, ASTNode astNode, JstType jstType) {
        if (value == null) {
            return null;
        }
        String v = null;
        v = value instanceof QualifiedName ? this.getValue((QualifiedName)value, astNode, jstType) : (value instanceof StringLiteral ? ((StringLiteral)value).getLiteralValue() : value.toString());
        return v;
    }

    private String getValue(QualifiedName name, ASTNode astNode, JstType jstType) {
        TranslateInfo tInfo = TranslateCtx.ctx().getTranslateInfo(jstType);
        String typeName = name.getQualifier().getFullyQualifiedName();
        String fullName = tInfo.getImported(typeName);
        try {
            Class<?> toClass = Class.forName(fullName);
            Field field = toClass.getField(name.getName().toString());
            return (String)field.get(toClass);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void process(ASTNode astNode, JstType jstType, Annotation anno, CustomInfo cInfo) {
        CustomType cType = this.getCustomType((IJstNode)jstType);
        if (astNode instanceof AbstractTypeDeclaration) {
            this.process((AbstractTypeDeclaration)astNode, jstType, anno, cType, cInfo);
        } else if (astNode instanceof FieldDeclaration) {
            this.process((FieldDeclaration)astNode, jstType, anno, cType, cInfo);
        } else if (!(astNode instanceof EnumConstantDeclaration) && astNode instanceof MethodDeclaration) {
            this.process((MethodDeclaration)astNode, jstType, anno, cType, cInfo);
        }
    }

    private void process(AbstractTypeDeclaration astNode, JstType jstType, Annotation anno, CustomType cType, CustomInfo cInfo) {
        String value = null;
        if (anno instanceof NormalAnnotation) {
            List<MemberValuePair> annos = this.getAnnoMemberPairs(anno);
            if (annos.size() > 0) {
                for (MemberValuePair pair : annos) {
                    String name = this.getName(pair);
                    if (!ANNO_NAME.equals(name) && !ANNO_VALUE.equals(name)) continue;
                    if (pair.getValue() instanceof QualifiedName) {
                        value = this.getValue((QualifiedName)pair.getValue(), (ASTNode)astNode, jstType);
                        break;
                    }
                    value = this.getValue(pair.getValue(), (ASTNode)astNode, jstType);
                    break;
                }
                cInfo.setName(value);
            }
        } else if (anno instanceof SingleMemberAnnotation) {
            value = this.getValue(((SingleMemberAnnotation)anno).getValue(), (ASTNode)astNode, jstType);
            cInfo.setName(value);
        } else {
            value = astNode.getName().toString();
        }
        if (value == null) {
            return;
        }
        cType.setAttr(cInfo.getAttr());
        cType.setJstName(value);
    }

    private void process(FieldDeclaration astNode, JstType jstType, Annotation anno, CustomType cType, CustomInfo cInfo) {
        String value = null;
        if (anno instanceof NormalAnnotation) {
            List<MemberValuePair> annos = this.getAnnoMemberPairs(anno);
            if (annos.size() > 0) {
                for (MemberValuePair pair : annos) {
                    String name = this.getName(pair);
                    if (!ANNO_NAME.equals(name) && !ANNO_VALUE.equals(name)) continue;
                    value = pair.getValue() instanceof QualifiedName ? this.getValue((QualifiedName)pair.getValue(), (ASTNode)astNode, jstType) : this.getValue(pair.getValue(), (ASTNode)astNode, jstType);
                    cInfo.setName(value);
                    break;
                }
            }
        } else if (anno instanceof SingleMemberAnnotation) {
            value = this.getValue(((SingleMemberAnnotation)anno).getValue(), (ASTNode)astNode, jstType);
            cInfo.setName(value);
        }
        if (value == null) {
            return;
        }
        String fName = null;
        String tName = null;
        if (value != null) {
            cInfo.setName(value);
            int index = value.lastIndexOf(".");
            if (index < 0) {
                fName = value;
            } else {
                fName = value.substring(index + 1, value.length());
                tName = value.substring(0, index);
            }
        }
        for (Object o : astNode.fragments()) {
            if (!(o instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment v = (VariableDeclarationFragment)o;
            String vName = v.getName().toString();
            CustomField cField = cType.getCustomField(vName);
            if (cField == null) {
                cField = new CustomField(vName);
                cType.addCustomField(cField);
            }
            cField.setAttr(cInfo.getAttr());
            cField.setJstName(fName);
            cField.setJstOwnerTypeName(tName);
        }
    }

    private void process(MethodDeclaration astNode, JstType jstType, Annotation anno, CustomType cType, CustomInfo cInfo) {
        MethodKey mtdKey = MethodKey.genMethodKey(astNode);
        CustomMethod cMtd = cType.getCustomMethod(mtdKey);
        if (cMtd == null) {
            cMtd = new CustomMethod(mtdKey);
            cType.addCustomMethod(cMtd);
        }
        String value = null;
        if (anno instanceof NormalAnnotation) {
            List<MemberValuePair> annos = this.getAnnoMemberPairs(anno);
            if (annos.size() > 0) {
                for (MemberValuePair pair : annos) {
                    String name = this.getName(pair);
                    if (!ANNO_NAME.equals(name) && !ANNO_VALUE.equals(name)) continue;
                    value = pair.getValue() instanceof QualifiedName ? this.getValue((QualifiedName)pair.getValue(), (ASTNode)astNode, jstType) : this.getValue(pair.getValue(), (ASTNode)astNode, jstType);
                    break;
                }
            }
        } else if (anno instanceof SingleMemberAnnotation) {
            value = this.getValue(((SingleMemberAnnotation)anno).getValue(), (ASTNode)astNode, jstType);
            cInfo.setName(value);
        } else if (cInfo.isMappedToJS() || cInfo.isMappedToVJO()) {
            value = astNode.getName().toString();
        }
        if (value == null) {
            return;
        }
        cMtd.setAttr(cInfo.getAttr());
        int index = value.lastIndexOf(".");
        if (index > 0) {
            cMtd.setJstOwnerTypeName(value.substring(0, index));
            cMtd.setJstName(value.substring(index + 1));
            cInfo.setName(value);
        } else {
            cMtd.setJstName(value);
            cInfo.setName(value);
        }
    }

    private void genMetaForPty(MethodDeclaration astNode, JstType jstType, Annotation anno) {
        NormalAnnotation normalAnno;
        List annos;
        MemberValuePair pair;
        String name;
        MethodKey mtdKey;
        CustomType cType = this.getCustomType((IJstNode)jstType);
        CustomMethod cMtd = cType.getCustomMethod(mtdKey = MethodKey.genMethodKey(astNode));
        if (cMtd == null) {
            cMtd = new CustomMethod(mtdKey);
            cType.addCustomMethod(cMtd);
        }
        cMtd.setIsProperty(true);
        if (anno instanceof NormalAnnotation && (name = this.getValue((pair = (MemberValuePair)(annos = (normalAnno = (NormalAnnotation)anno).values()).get(0)).getValue(), (ASTNode)astNode, jstType)) != null) {
            cMtd.setJstName(name);
            return;
        }
        String mtdName = cMtd.getJstName();
        if (mtdName.startsWith("get")) {
            mtdName = String.valueOf(mtdName.substring(3, 4).toLowerCase()) + mtdName.substring(4, mtdName.length());
            cMtd.setJstName(mtdName);
        } else if (mtdName.startsWith("set")) {
            mtdName = String.valueOf(mtdName.substring(3, 4).toLowerCase()) + mtdName.substring(4, mtdName.length());
            cMtd.setJstName(mtdName);
        }
    }

    private CustomType getCustomType(IJstNode jstNode) {
        IJstType ownerType;
        if (jstNode == null) {
            return null;
        }
        MetaProvider metaProvider = (MetaProvider)this.getMetaProvider();
        CustomType cType = metaProvider.getCustomType((ownerType = jstNode.getOwnerType()).getName());
        if (cType == null) {
            cType = new CustomType(ownerType.getName());
            metaProvider.addCustomType(ownerType.getName(), cType);
        }
        return cType;
    }

    private static class MetaProvider
    extends BaseCustomMetaProvider
    implements ICustomMetaProvider {
        private MetaProvider() {
        }
    }
}

