/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.vjet.dsf.javatojs.translate.AstBinding;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.DataTypeTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.FieldTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.config.PackageMapping;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.javatojs.translate.custom.anno.IAnnoProcessor;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstDoc;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.stmt.JstBlockInitializer;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class TypeTranslator
extends BaseTranslator {
    public void processType(AbstractTypeDeclaration abstractType, JstType type) {
        JstType jstType = type;
        TranslateCtx ctx = this.getCtx();
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        if (!tInfo.getMode().hasImplementation()) {
            if (TranslateHelper.Type.isEmbededType(abstractType)) {
                String name = abstractType.getName().toString();
                if (tInfo.getEmbeddedTypeCustomInfo(name).isExcluded()) {
                    return;
                }
                tInfo.addEmbededType(name);
                ctx.getTranslateInfo(type).addEmbededType(name);
                if (!name.equals(type.getSimpleName()) && (jstType = type.getEmbededType(name)) == null) {
                    jstType = ctx.getProvider().getTypeTranslator().processEmbededType(abstractType, type);
                }
            }
            CustomInfo cInfo = null;
            for (IAnnoProcessor ap : ctx.getConfig().getAnnoProcessors()) {
                cInfo = ap.process((ASTNode)abstractType, jstType);
                if (cInfo == null || cInfo == CustomInfo.NONE) continue;
                ctx.updateCustomInfo((IJstType)jstType, cInfo);
                cInfo.setJstNode((IJstNode)jstType);
            }
            if (cInfo != null && (cInfo.isMappedToJS() || cInfo.isMappedToVJO())) {
                IJstType jsType = this.getCustomTranslator().processType(jstType.getName(), (ASTNode)abstractType, (BaseJstNode)jstType);
                String typeName = jstType.getSimpleName();
                for (TranslateInfo info : ctx.getAllTranslateInfos()) {
                    IJstType toType = info.getType(typeName, false);
                    if (toType == null || toType == jsType) continue;
                    info.setClearTypeRefs(true);
                    info.setType(typeName, jsType);
                }
            }
        }
        if (!tInfo.getStatus().isDeclTranlationDone()) {
            this.getCustomTranslator().initialize(jstType);
            this.processTypeDecl(abstractType, jstType);
        }
        if (tInfo.getMode().hasImplementation()) {
            if (ctx.isExcluded((IJstType)jstType) || ctx.isJavaOnly((IJstType)jstType) || ctx.isJSProxy((IJstType)jstType) || ctx.isMappedToVJO((IJstType)jstType)) {
                return;
            }
            this.reDoDecl(abstractType, jstType);
            this.processTypeImpl(abstractType, jstType);
            tInfo.getStatus().setImplTranlationDone();
        }
    }

    public JstType processEmbededType(AbstractTypeDeclaration embeddedType, JstType parentType) {
        TranslateCtx ctx = this.getCtx();
        TranslateInfo tInfo = ctx.getTranslateInfo(parentType);
        String shortName = embeddedType.getName().toString();
        JstType innerType = parentType.getEmbededType(shortName);
        if (innerType == null) {
            innerType = (JstType)tInfo.getType(shortName, false);
            if (innerType == null) {
                innerType = JstCache.getInstance().getType(String.valueOf(parentType.getName()) + "." + shortName, true);
            } else {
                JstType cachedType = JstCache.getInstance().addType(innerType, true);
                if (cachedType != innerType) {
                    tInfo.setClearTypeRefs(true);
                    innerType = cachedType;
                }
            }
            innerType.setParent((IJstNode)parentType);
            innerType.setSource(new JstSource((JstSource.IBinding)new AstBinding((ASTNode)embeddedType)));
            tInfo.setType(shortName, (IJstType)innerType);
        }
        for (IAnnoProcessor ap : ctx.getConfig().getAnnoProcessors()) {
            CustomInfo cInfo = ap.process((ASTNode)embeddedType, parentType);
            if (cInfo == null || cInfo == CustomInfo.NONE) continue;
            tInfo.addEmbeddedTypeCustomInfo(shortName, cInfo);
            ctx.updateCustomInfo((IJstType)innerType, cInfo);
        }
        parentType.addInnerType(innerType);
        innerType.setOuterType(parentType);
        boolean isStatic = TranslateHelper.isStatic(embeddedType.modifiers());
        if (embeddedType instanceof TypeDeclaration) {
            isStatic = ((TypeDeclaration)embeddedType).isInterface();
        }
        innerType.getModifiers().setStatic(isStatic);
        ctx.getTranslateInfo(innerType).addMode(tInfo.getMode());
        JstType outer = innerType.getOuterType();
        String key = innerType.getSimpleName();
        while (outer instanceof JstType) {
            tInfo = ctx.getTranslateInfo(outer);
            tInfo.setType(key, (IJstType)innerType);
            key = String.valueOf(outer.getSimpleName()) + "." + key;
            outer = outer.getOuterType();
        }
        return innerType;
    }

    void processBody(List bodyDeclaration, JstType jstType) {
        if (this.getCustomTranslator().processTypeBody(bodyDeclaration, jstType)) {
            return;
        }
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        for (Object d : bodyDeclaration) {
            if (d instanceof FieldDeclaration) {
                this.getFieldTranslator().processField((FieldDeclaration)d, jstType);
                continue;
            }
            if (d instanceof Initializer) {
                Initializer initializer = (Initializer)d;
                JstBlockInitializer jstBlock = this.getCtx().getTranslateInfo(jstType).getJstInitializer(initializer);
                if (jstBlock != null) {
                    this.getOtherTranslator().processBlock(initializer.getBody(), jstBlock.getBody());
                    boolean isStatic = Modifier.isStatic((int)initializer.getModifiers());
                    jstType.addInit((IStmt)jstBlock, isStatic);
                    continue;
                }
                this.getLogger().logError("MissingDataInTranslateInfo", "initializer not found", this, (ASTNode)((Initializer)d), (BaseJstNode)jstType);
                continue;
            }
            if (d instanceof MethodDeclaration) {
                MethodDeclaration astMtd = (MethodDeclaration)d;
                this.getMtdTranslator().processMethod(astMtd, jstType);
                continue;
            }
            if (d instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration embeddedType = (AbstractTypeDeclaration)d;
                String name = embeddedType.getName().toString();
                if (TranslateHelper.Type.isExcluded((ASTNode)embeddedType, jstType, name, (BaseJstNode)jstType)) continue;
                JstType type = jstType.getEmbededType(name);
                if (type == null) {
                    if (tInfo.isEmbededType(name)) continue;
                    type = jstType;
                }
                this.processType((AbstractTypeDeclaration)d, type);
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)d, (BaseJstNode)jstType);
        }
    }

    private void reDoDecl(AbstractTypeDeclaration astType, JstType jstType) {
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstType);
        if (tInfo.clearTypeRefs()) {
            this.processTypeSigniture(astType, jstType);
        }
        for (IJstType extend : jstType.getExtends()) {
            if (!(extend instanceof JstType)) continue;
            this.reDoDecl(AstBindingHelper.getAstType(extend), (JstType)extend);
        }
    }

    private void processTypeDecl(AbstractTypeDeclaration abstractType, JstType jstType) {
        if (jstType == null) {
            return;
        }
        this.processTypeJavadoc(abstractType, jstType);
        this.processTypeSigniture(abstractType, jstType);
        JstModifiers modifiers = jstType.getModifiers();
        modifiers.setDefault();
        for (Object m : abstractType.modifiers()) {
            if (m instanceof Modifier) {
                modifiers.merge(((Modifier)m).getKeyword().toFlagValue());
                continue;
            }
            if (m instanceof Annotation) {
                this.getOtherTranslator().processAnnotation((Annotation)m, (BaseJstNode)jstType);
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)m, (BaseJstNode)jstType);
        }
        if (jstType.isInterface()) {
            modifiers.setPublic();
        }
        for (Object d : abstractType.bodyDeclarations()) {
            if (!(d instanceof AbstractTypeDeclaration)) continue;
            this.processEmbededType((AbstractTypeDeclaration)d, jstType);
        }
    }

    private void processTypeJavadoc(AbstractTypeDeclaration abstractType, JstType jstType) {
        Javadoc javadoc = abstractType.getJavadoc();
        if (javadoc == null) {
            return;
        }
        JstDoc jstDoc = new JstDoc(javadoc.toString());
        jstType.setDoc((IJstDoc)jstDoc);
    }

    private void processTypeSigniture(AbstractTypeDeclaration abstractType, JstType jstType) {
        if (jstType == null) {
            return;
        }
        jstType.clearParams();
        jstType.clearExtends();
        jstType.clearSatisfies();
        jstType.clearEnumValues();
        if (abstractType instanceof TypeDeclaration) {
            List params = ((TypeDeclaration)abstractType).typeParameters();
            for (TypeParameter p : params) {
                JstParamType pType = jstType.addParam(p.getName().toString());
                if (pType == null) continue;
                for (Object b : p.typeBounds()) {
                    if (!(b instanceof Type)) continue;
                    pType.addBound(this.getDataTypeTranslator().processType((Type)b, (BaseJstNode)jstType));
                }
            }
        }
        String typeName = abstractType.getName().toString();
        jstType.setSimpleName(typeName);
        TranslateCtx ctx = this.getCtx();
        TranslateInfo tInfo = ctx.getTranslateInfo(jstType);
        if (abstractType instanceof TypeDeclaration) {
            TypeDeclaration astType = (TypeDeclaration)abstractType;
            if (astType.isInterface()) {
                jstType.setCategory(JstType.Category.INTERFACE);
            } else if ((astType.getModifiers() & 0x400) == 1024) {
                jstType.getModifiers().setAbstract();
            }
            Type type = astType.getSuperclassType();
            if (type != null) {
                String typeFullName = String.valueOf(jstType.getPackage().getName()) + "." + type.toString();
                JstType baseType = JstCache.getInstance().getType(typeFullName, false);
                if (baseType == null) {
                    baseType = this.getDataTypeTranslator().processType(type, (BaseJstNode)jstType);
                }
                if (baseType != null) {
                    tInfo.setBaseType((IJstType)baseType);
                    JstTypeReference extendRef = new JstTypeReference((IJstType)baseType);
                    extendRef.setSource(new JstSource((JstSource.IBinding)new AstBinding((ASTNode)type)));
                    jstType.addExtend((IJstTypeReference)extendRef);
                }
            }
            this.processSuperInterfaces(astType.superInterfaceTypes(), jstType);
            if (this.usingNativeProxy(jstType)) {
                jstType.clearExtends();
                jstType.addExtend((IJstType)JstCache.getInstance().getType("vjo.Object"));
            }
            if (this.canAddDefaultExtendForClass(jstType)) {
                jstType.addExtend((IJstType)JstCache.getInstance().getType("vjo.Object"));
            }
        } else if (abstractType instanceof EnumDeclaration) {
            jstType.setCategory(JstType.Category.ENUM);
            jstType.getModifiers().setFinal();
            if (jstType.getParentNode() != null) {
                jstType.getModifiers().setStatic(true);
            }
            EnumDeclaration enumType = (EnumDeclaration)abstractType;
            this.processSuperInterfaces(enumType.superInterfaceTypes(), jstType);
            FieldTranslator fieldTranslator = this.getCtx().getProvider().getFieldTranslator();
            for (Object d : enumType.enumConstants()) {
                fieldTranslator.processEnumConstsDecl((EnumConstantDeclaration)d, jstType);
            }
            if (jstType.getExtend() == null) {
                jstType.addExtend((IJstType)JstCache.getInstance().getType("vjo.Enum"));
            }
        } else {
            this.getLogger().logUnhandledNode(this, (ASTNode)abstractType, (BaseJstNode)jstType);
        }
    }

    private boolean usingNativeProxy(JstType jstType) {
        return jstType.getExtend() != null && jstType.getExtend().getName().equals("org.eclipse.vjet.dsf.dap.proxy.NativeJsProxy");
    }

    private boolean canAddDefaultExtendForClass(JstType jstType) {
        if (!jstType.isClass()) {
            return false;
        }
        if (jstType.getExtend() == null) {
            return true;
        }
        String name = jstType.getExtend().getName();
        return name.equals("Object") || name.equals("java.lang.Object");
    }

    private void processTypeImpl(AbstractTypeDeclaration abstractType, JstType jstType) {
        if (abstractType instanceof EnumDeclaration) {
            EnumDeclaration enumType = (EnumDeclaration)abstractType;
            FieldTranslator fieldTranslator = this.getCtx().getProvider().getFieldTranslator();
            for (Object d : enumType.enumConstants()) {
                fieldTranslator.processEnumConstsImpl((EnumConstantDeclaration)d, jstType);
            }
        }
        this.processBody(abstractType.bodyDeclarations(), jstType);
    }

    private void processSuperInterfaces(List superInterfaces, JstType jstType) {
        if (superInterfaces.isEmpty()) {
            return;
        }
        TranslateCtx ctx = this.getCtx();
        TranslateInfo tInfo = ctx.getTranslateInfo(jstType);
        DataTypeTranslator dataTypeTranslator = this.getDataTypeTranslator();
        AstBinding binding = AstBindingHelper.getAstSrcBinding((IJstNode)jstType);
        PackageMapping pkgMapping = ctx.getConfig().getPackageMapping();
        for (Type astType : superInterfaces) {
            String simpleName = astType.toString();
            IJstType interfaceType = dataTypeTranslator.processType(astType, (BaseJstNode)jstType);
            if (binding != null && interfaceType != null) {
                String fullName = interfaceType.getName();
                binding.addInterfaceName(simpleName, pkgMapping.mapFrom(fullName));
            }
            if (ctx.isJavaOnly(interfaceType) || ctx.isExcluded(interfaceType)) continue;
            if (ctx.isJavaOnly(interfaceType) || ctx.isExcluded(interfaceType)) {
                tInfo.addInterfaceType(interfaceType);
                continue;
            }
            JstTypeReference jstTypeRef = new JstTypeReference(interfaceType);
            jstTypeRef.setSource(new JstSource((JstSource.IBinding)new AstBinding((ASTNode)astType)));
            if (jstType.isInterface()) {
                jstType.addExtend((IJstTypeReference)jstTypeRef);
                continue;
            }
            jstType.addSatisfy((IJstTypeReference)jstTypeRef);
        }
    }
}

