/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class TranslationStatus {
    private static final int DEPENDENCY = 1;
    private static final int DECL_TRANSLATION = 2;
    private static final int IMPL_TRANSLATION = 4;
    private JstType m_jstType;
    private int m_status;
    private Map<ASTNode, TranslateError> m_errors;

    public TranslationStatus(JstType jstType) {
        this.m_jstType = jstType;
    }

    public TranslationStatus setDependencyDone() {
        this.m_status |= 1;
        return this;
    }

    public TranslationStatus setDeclTranlationDone() {
        this.m_status |= 2;
        if (this.m_jstType != null) {
            this.m_jstType.getStatus().setHasDecl();
        }
        return this;
    }

    public TranslationStatus setImplTranlationDone() {
        this.m_status |= 4;
        if (this.m_jstType != null) {
            this.m_jstType.getStatus().setHasImpl();
        }
        return this;
    }

    public boolean isDependencyDone() {
        return (this.m_status & 1) == 1;
    }

    public boolean isDeclTranlationDone() {
        return (this.m_status & 2) == 2 || this.isImplTranlationDone();
    }

    public boolean isImplTranlationDone() {
        return (this.m_status & 4) == 4;
    }

    public boolean hasError() {
        return this.m_errors != null && !this.m_errors.isEmpty();
    }

    public boolean hasError(ASTNode astNode) {
        return this.m_errors != null && this.m_errors.containsKey(astNode);
    }

    public List<TranslateError> getErrors() {
        if (this.m_errors == null) {
            return Collections.emptyList();
        }
        ArrayList<TranslateError> list = new ArrayList<TranslateError>();
        list.addAll(this.m_errors.values());
        return list;
    }

    void addError(ASTNode astNode, TranslateError error) {
        this.getErrors(true).put(astNode, error);
        if (this.m_jstType != null) {
            this.m_jstType.getStatus().setIsValid(false);
        }
    }

    private Map<ASTNode, TranslateError> getErrors(boolean create) {
        if (this.m_errors == null && create) {
            this.m_errors = new HashMap<ASTNode, TranslateError>();
        }
        return this.m_errors;
    }
}

