/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.vjet.dsf.javatojs.anno.ASupportJsForEachStmt;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.ExpressionTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.config.JavaTranslationConvention;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.datatype.JstReservedTypes;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.stmt.BreakStmt;
import org.eclipse.vjet.dsf.jst.stmt.CatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ContinueStmt;
import org.eclipse.vjet.dsf.jst.stmt.DoStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForInStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForStmt;
import org.eclipse.vjet.dsf.jst.stmt.IfStmt;
import org.eclipse.vjet.dsf.jst.stmt.LabeledStmt;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThisStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.stmt.TryStmt;
import org.eclipse.vjet.dsf.jst.stmt.TypeDeclStmt;
import org.eclipse.vjet.dsf.jst.stmt.WhileStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class StatementTranslator
extends BaseTranslator {
    private static final String CATCH_VAR_NAME = "e";
    private static final String SupportJsForEachStmt = ASupportJsForEachStmt.class.getSimpleName();

    public IStmt processStatement(Statement astStmt, BaseJstNode jstBlock) {
        if (jstBlock == null || jstBlock.getOwnerType() == null) {
            return null;
        }
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(jstBlock.getOwnerType());
        JstVars jstStmt = null;
        if (tInfo.getMode().hasImplementation()) {
            if (astStmt instanceof VariableDeclarationStatement) {
                jstStmt = this.toAssignExpr((VariableDeclarationStatement)astStmt, jstBlock);
            } else if (astStmt instanceof ConstructorInvocation) {
                jstStmt = this.toMtdInvocation((ConstructorInvocation)astStmt, jstBlock);
            } else if (astStmt instanceof SuperConstructorInvocation) {
                jstStmt = this.toMtdInvocation((SuperConstructorInvocation)astStmt, jstBlock);
            } else if (astStmt instanceof ExpressionStatement) {
                jstStmt = this.toExprStmt((ExpressionStatement)astStmt, jstBlock);
            } else if (astStmt instanceof ForStatement) {
                jstStmt = this.toForStmt((ForStatement)astStmt, jstBlock);
            } else if (astStmt instanceof EnhancedForStatement) {
                jstStmt = this.toForEachStmt((EnhancedForStatement)astStmt, jstBlock);
            } else if (astStmt instanceof WhileStatement) {
                jstStmt = this.toWhileStmt((WhileStatement)astStmt, jstBlock);
            } else if (astStmt instanceof DoStatement) {
                jstStmt = this.toDoStmt((DoStatement)astStmt, jstBlock);
            } else if (astStmt instanceof IfStatement) {
                jstStmt = this.toIfStmt((IfStatement)astStmt, jstBlock);
            } else if (astStmt instanceof SwitchStatement) {
                jstStmt = this.toSwitchStmt((SwitchStatement)astStmt, jstBlock);
            } else if (astStmt instanceof SwitchCase) {
                SwitchCase c = (SwitchCase)astStmt;
                jstStmt = new SwitchStmt.CaseStmt(this.getExprTranslator().processExpression(c.getExpression(), jstBlock));
            } else if (astStmt instanceof BreakStatement) {
                jstStmt = this.toBreakStmt((BreakStatement)astStmt, jstBlock);
            } else if (astStmt instanceof ContinueStatement) {
                jstStmt = this.toContinueStmt((ContinueStatement)astStmt, jstBlock);
            } else if (astStmt instanceof LabeledStatement) {
                jstStmt = this.toLabeledStmt((LabeledStatement)astStmt, jstBlock);
            } else if (astStmt instanceof ThrowStatement) {
                jstStmt = this.toThrowStmt((ThrowStatement)astStmt, jstBlock);
            } else if (astStmt instanceof TryStatement) {
                jstStmt = this.toTryStmt((TryStatement)astStmt, jstBlock);
            } else if (astStmt instanceof ReturnStatement) {
                jstStmt = this.toReturnStmt((ReturnStatement)astStmt, jstBlock);
            } else if (astStmt instanceof SynchronizedStatement) {
                jstStmt = this.toBlockStmt(((SynchronizedStatement)astStmt).getBody(), jstBlock);
            } else if (astStmt instanceof AssertStatement) {
                this.getLogger().logWarning("UnsupportedNode", String.valueOf(astStmt.getClass().getSimpleName()) + " not translated", this, (ASTNode)astStmt, jstBlock);
                jstStmt = null;
            } else if (astStmt instanceof EmptyStatement) {
                jstStmt = null;
            } else {
                if (astStmt instanceof Block) {
                    BlockStmt blockStmt = new BlockStmt();
                    jstBlock.addChild((IJstNode)blockStmt);
                    this.getOtherTranslator().processBlock((Block)astStmt, blockStmt.getBody());
                    return blockStmt;
                }
                if (astStmt instanceof TypeDeclarationStatement) {
                    TypeDeclarationStatement tStmt = (TypeDeclarationStatement)astStmt;
                    JstType localType = this.getCtx().getTranslateInfo(jstBlock.getRootType()).getLocalType(tStmt);
                    if (localType == null) {
                        this.getLogger().logError("MissingDataInTranslateInfo", "local type not found", this, (ASTNode)tStmt, jstBlock);
                        return null;
                    }
                    TypeDeclStmt jstTypeStmt = new TypeDeclStmt(localType);
                    jstBlock.addChild((IJstNode)jstTypeStmt);
                    this.getCtx().getTranslateInfo(jstTypeStmt.getType()).getMode().addImplementation();
                    this.getTypeTranslator().processType(tStmt.getDeclaration(), jstTypeStmt.getType());
                    return jstTypeStmt;
                }
                this.getLogger().logUnhandledNode(this, (ASTNode)astStmt, jstBlock);
            }
        } else if (tInfo.getMode().hasDependency()) {
            if (astStmt instanceof ForStatement) {
                jstStmt = new ForStmt();
            } else if (astStmt instanceof EnhancedForStatement) {
                jstStmt = new ForStmt();
            } else if (astStmt instanceof WhileStatement) {
                jstStmt = new WhileStmt();
            } else if (astStmt instanceof DoStatement) {
                jstStmt = new DoStmt();
            } else if (astStmt instanceof IfStatement) {
                jstStmt = new IfStmt();
            } else if (astStmt instanceof SwitchStatement) {
                jstStmt = new SwitchStmt();
            } else if (astStmt instanceof TryStatement) {
                jstStmt = new TryStmt();
            } else if (astStmt instanceof SynchronizedStatement) {
                jstStmt = new BlockStmt();
            } else if (astStmt instanceof Block) {
                jstStmt = new BlockStmt();
            }
        }
        if (jstStmt != null) {
            jstBlock.addChild((IJstNode)jstStmt);
        }
        return jstStmt;
    }

    private JstVars toAssignExpr(VariableDeclarationStatement astStmt, BaseJstNode jstBlock) {
        return this.getExprTranslator().toJstVars(astStmt.getType(), astStmt.fragments(), jstBlock);
    }

    private MtdInvocationExpr toMtdInvocation(ConstructorInvocation astStmt, BaseJstNode jstBlock) {
        Integer argCount;
        List<JstMethod> list;
        ThisStmt mtdCall = new ThisStmt(String.valueOf(VjoConvention.getThisPrefix()) + "." + "constructs", new IExpr[0]);
        ArrayList<IExpr> jstArgs = new ArrayList<IExpr>();
        for (Object a : astStmt.arguments()) {
            if (a instanceof Expression) {
                jstArgs.add(this.getExprTranslator().processExpression((Expression)a, jstBlock));
                continue;
            }
            jstArgs.add((IExpr)new JstIdentifier(a.toString()));
        }
        mtdCall.setArgs(jstArgs);
        JstType ownerType = jstBlock.getOwnerType();
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(ownerType);
        Map<Integer, List<JstMethod>> map = tInfo.getOverloaded("constructs", false);
        if (!map.isEmpty() && (list = map.get(argCount = new Integer(astStmt.arguments().size()))) == null) {
            list = new ArrayList<JstMethod>();
            map.put(argCount, list);
        }
        mtdCall.setConstructor(TranslateHelper.Method.getConstructor((IJstType)ownerType, jstArgs));
        return mtdCall;
    }

    private MtdInvocationExpr toMtdInvocation(SuperConstructorInvocation astStmt, BaseJstNode jstBlock) {
        MtdInvocationExpr mtdCall = new MtdInvocationExpr(this.getCtx().getConfig().getVjoConvention().getBasePrefix(), new IExpr[0]);
        for (Object a : astStmt.arguments()) {
            if (a instanceof Expression) {
                mtdCall.addArg(this.getExprTranslator().processExpression((Expression)a, jstBlock));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)a, jstBlock);
        }
        return mtdCall;
    }

    private IStmt toExprStmt(ExpressionStatement astStmt, BaseJstNode jstBlock) {
        Expression e = astStmt.getExpression();
        return this.getExprTranslator().toStmt(e, jstBlock);
    }

    private ForStmt toForStmt(ForStatement astStmt, BaseJstNode jstBlock) {
        ExpressionTranslator exprTranslator = this.getExprTranslator();
        ForStmt forStmt = new ForStmt();
        jstBlock.addChild((IJstNode)forStmt);
        JstInitializer jstInitializers = null;
        for (Object o : astStmt.initializers()) {
            if (o instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression vde = (VariableDeclarationExpression)o;
                forStmt.setInitializer((IInitializer)exprTranslator.toJstVars(vde.getType(), vde.fragments(), jstBlock));
                continue;
            }
            if (o instanceof Assignment) {
                if (jstInitializers == null) {
                    jstInitializers = new JstInitializer();
                    forStmt.setInitializer((IInitializer)jstInitializers);
                }
                jstInitializers.addAssignment(exprTranslator.toAssignExpr((Assignment)o, jstBlock));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, jstBlock);
        }
        Expression astCond = astStmt.getExpression();
        if (astCond != null && (astCond instanceof InfixExpression || astCond instanceof PrefixExpression)) {
            forStmt.setCondition(this.getExprTranslator().toBoolExpr(astCond, jstBlock));
        } else if (astCond instanceof MethodInvocation) {
            IExpr e = exprTranslator.processExpression(astCond, jstBlock);
            forStmt.setCondition((IBoolExpr)new BoolExpr(e));
        }
        for (Object o : astStmt.updaters()) {
            if (o instanceof Expression) {
                forStmt.addUpdater(this.getExprTranslator().processExpression((Expression)o, jstBlock));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, jstBlock);
        }
        Statement body = astStmt.getBody();
        if (body instanceof Block) {
            Block block = (Block)body;
            for (Object o : block.statements()) {
                if (o instanceof Statement) {
                    forStmt.addStmt(this.processStatement((Statement)o, (BaseJstNode)forStmt.getBody()));
                    continue;
                }
                this.getLogger().logUnhandledNode(this, (ASTNode)o, jstBlock);
            }
        } else if (body instanceof Statement) {
            forStmt.addStmt(this.processStatement(body, (BaseJstNode)forStmt.getBody()));
        } else {
            this.getLogger().logUnhandledNode(this, (ASTNode)body, jstBlock);
        }
        return forStmt;
    }

    private IStmt toForEachStmt(EnhancedForStatement astStmt, BaseJstNode jstBlock) {
        JavaTranslationConvention convention = TranslateCtx.ctx().getConfig().getJavaTranslationConvention();
        ExpressionTranslator exprTranslator = this.getExprTranslator();
        IExpr jstExpr = exprTranslator.processExpression(astStmt.getExpression(), jstBlock);
        JstVar jstVar = this.getOtherTranslator().toJstVar(astStmt.getParameter(), jstBlock.getOwnerType());
        IJstType collectionType = jstExpr.getResultType();
        if (StatementTranslator.isJsForEachSupportedType(collectionType)) {
            return this.toForInStmt(astStmt, jstBlock, jstVar, jstExpr);
        }
        ForStmt forStmt = new ForStmt();
        jstBlock.addChild((IJstNode)forStmt);
        forStmt.getBody().getVarTable().addVarType(jstVar.getName(), jstVar.getType());
        JstInitializer initializer = new JstInitializer((ILHS)jstVar, null);
        forStmt.setInitializer((IInitializer)initializer);
        if (collectionType instanceof JstArray) {
            ArrayAccessExpr arrayAccessExpr;
            FieldAccessExpr lengthExpr;
            String tempIndexName = String.valueOf(convention.getTempIndex()) + this.getCtx().getTranslateInfo(jstBlock.getOwnerType()).getUniqueTempIndex();
            JstIdentifier tmpIndex = new JstIdentifier(tempIndexName).setType((IJstType)JstReservedTypes.JsNative.NUMBER);
            if (!(jstExpr instanceof JstIdentifier)) {
                JstIdentifier tmpArr = new JstIdentifier(convention.getTempArray()).setType(collectionType);
                initializer.addAssignment(new AssignExpr((ILHS)tmpArr, jstExpr));
                lengthExpr = new FieldAccessExpr(new JstIdentifier(convention.getArrayLength(), tmpArr).setType((IJstType)JstReservedTypes.JsNative.NUMBER));
                arrayAccessExpr = new ArrayAccessExpr((IExpr)tmpArr, (IExpr)tmpIndex);
            } else {
                lengthExpr = new FieldAccessExpr(new JstIdentifier(convention.getArrayLength()).setType((IJstType)JstReservedTypes.JsNative.NUMBER), jstExpr);
                arrayAccessExpr = new ArrayAccessExpr(jstExpr, (IExpr)tmpIndex);
            }
            initializer.addAssignment(new AssignExpr((ILHS)tmpIndex, (IExpr)SimpleLiteral.getIntLiteral((int)0)));
            forStmt.setCondition((IBoolExpr)new BoolExpr((IExpr)tmpIndex, (IExpr)lengthExpr, BoolExpr.Operator.LESS));
            forStmt.addUpdater((IExpr)new PostfixExpr((IExpr)tmpIndex, PostfixExpr.Operator.INCREMENT));
            forStmt.addStmt((IStmt)new AssignExpr((ILHS)new JstIdentifier(jstVar.getName()), (IExpr)arrayAccessExpr));
        } else {
            JstIdentifier tmpItr = new JstIdentifier(convention.getTempIterator());
            initializer.addAssignment(new AssignExpr((ILHS)tmpItr, (IExpr)new MtdInvocationExpr(new JstIdentifier(convention.getIteratorMethod()), new IExpr[0]).setQualifyExpr(jstExpr)));
            forStmt.setCondition((IBoolExpr)new BoolExpr((IExpr)new MtdInvocationExpr(new JstIdentifier(convention.getIteratorHasNext(), tmpItr), new IExpr[0])));
            forStmt.addStmt((IStmt)new AssignExpr((ILHS)new JstIdentifier(jstVar.getName()), (IExpr)new MtdInvocationExpr(new JstIdentifier(convention.getIteratorNext(), tmpItr), new IExpr[0])));
        }
        Statement body = astStmt.getBody();
        if (body instanceof Block) {
            Block block = (Block)body;
            for (Object o : block.statements()) {
                if (o instanceof Statement) {
                    forStmt.addStmt(this.processStatement((Statement)o, (BaseJstNode)forStmt.getBody()));
                    continue;
                }
                this.getLogger().logUnhandledNode(this, (ASTNode)o, jstBlock);
            }
        } else if (body instanceof Statement) {
            forStmt.addStmt(this.processStatement(body, (BaseJstNode)forStmt.getBody()));
        } else {
            this.getLogger().logUnhandledNode(this, (ASTNode)body, jstBlock);
        }
        return forStmt;
    }

    private IStmt toForInStmt(EnhancedForStatement astStmt, BaseJstNode jstBlock, JstVar jstVar, IExpr jstExpr) {
        ForInStmt forInStmt = new ForInStmt(jstVar, jstExpr);
        jstBlock.addChild((IJstNode)forInStmt);
        forInStmt.getBody().getVarTable().addVarType(jstVar.getName(), jstVar.getType());
        Statement body = astStmt.getBody();
        if (body instanceof Block) {
            Block block = (Block)body;
            for (Object o : block.statements()) {
                if (o instanceof Statement) {
                    forInStmt.addStmt(this.processStatement((Statement)o, (BaseJstNode)forInStmt.getBody()));
                    continue;
                }
                this.getLogger().logUnhandledNode(this, (ASTNode)o, jstBlock);
            }
        } else if (body instanceof Statement) {
            forInStmt.addStmt(this.processStatement(body, (BaseJstNode)forInStmt.getBody()));
        } else {
            this.getLogger().logUnhandledNode(this, (ASTNode)body, jstBlock);
        }
        return forInStmt;
    }

    private static boolean isJsForEachSupportedType(IJstType type) {
        IJstAnnotation a = type.getAnnotation(SupportJsForEachStmt);
        return a != null;
    }

    private WhileStmt toWhileStmt(WhileStatement astStmt, BaseJstNode jstBlock) {
        Statement body;
        WhileStmt whileStmt = new WhileStmt();
        jstBlock.addChild((IJstNode)whileStmt);
        Expression astCond = astStmt.getExpression();
        if (astCond != null) {
            whileStmt.setCondition(this.getExprTranslator().toBoolExpr(astCond, jstBlock));
        }
        if ((body = astStmt.getBody()) instanceof Block) {
            Block block = (Block)body;
            for (Object o : block.statements()) {
                whileStmt.addStmt(this.processStatement((Statement)o, (BaseJstNode)whileStmt.getBody()));
            }
        } else if (body instanceof Statement) {
            whileStmt.addStmt(this.processStatement(body, (BaseJstNode)whileStmt.getBody()));
        } else {
            this.getLogger().logUnhandledNode(this, (ASTNode)body, jstBlock);
        }
        return whileStmt;
    }

    private DoStmt toDoStmt(DoStatement astStmt, BaseJstNode jstBlock) {
        Statement body;
        DoStmt doStmt = new DoStmt();
        jstBlock.addChild((IJstNode)doStmt);
        Expression astCond = astStmt.getExpression();
        if (astCond != null) {
            if (astCond instanceof Expression) {
                doStmt.setCondition(this.getExprTranslator().toBoolExpr(astCond, jstBlock));
            } else {
                this.getLogger().logUnhandledNode(this, (ASTNode)astCond, jstBlock);
            }
        }
        if ((body = astStmt.getBody()) instanceof Block) {
            Block block = (Block)body;
            for (Object o : block.statements()) {
                if (o instanceof Statement) {
                    doStmt.addStmt(this.processStatement((Statement)o, (BaseJstNode)doStmt.getBody()));
                    continue;
                }
                this.getLogger().logUnhandledNode(this, (ASTNode)o, jstBlock);
            }
        } else {
            this.getLogger().logUnhandledNode(this, (ASTNode)body, jstBlock);
        }
        return doStmt;
    }

    private IfStmt toIfStmt(IfStatement astStmt, BaseJstNode jstNode) {
        Statement thenBlock;
        IfStmt ifStmt = new IfStmt();
        jstNode.addChild((IJstNode)ifStmt);
        Expression astCond = astStmt.getExpression();
        if (astCond != null) {
            IExpr expr = this.getExprTranslator().processExpression(astCond, (BaseJstNode)ifStmt.getBody());
            if (!(expr instanceof IBoolExpr)) {
                expr = new BoolExpr(expr);
            }
            ifStmt.setCondition((IBoolExpr)expr);
        }
        if ((thenBlock = astStmt.getThenStatement()) instanceof Block) {
            Block block = (Block)thenBlock;
            for (Object o : block.statements()) {
                if (o instanceof Statement) {
                    ifStmt.addThenStmt(this.processStatement((Statement)o, (BaseJstNode)ifStmt.getBody()));
                    continue;
                }
                this.getLogger().logUnhandledNode(this, (ASTNode)o, jstNode);
            }
        } else if (thenBlock instanceof Statement) {
            ifStmt.addThenStmt(this.processStatement(thenBlock, (BaseJstNode)ifStmt.getBody()));
        } else {
            this.getLogger().logUnhandledNode(this, (ASTNode)thenBlock, jstNode);
        }
        Statement elseStmt = astStmt.getElseStatement();
        if (elseStmt != null) {
            if (elseStmt instanceof IfStatement) {
                ifStmt.addElseStmt(this.toIfStmt((IfStatement)elseStmt, (BaseJstNode)ifStmt));
            } else if (elseStmt instanceof Block) {
                Block block = (Block)elseStmt;
                for (Object o : block.statements()) {
                    if (o instanceof Statement) {
                        ifStmt.addElseStmt(this.processStatement((Statement)o, (BaseJstNode)ifStmt.getElseBlock(true)));
                        continue;
                    }
                    this.getLogger().logUnhandledNode(this, (ASTNode)o, jstNode);
                }
            } else if (elseStmt instanceof Statement) {
                ifStmt.addElseStmt(this.processStatement(elseStmt, (BaseJstNode)ifStmt.getElseBlock(true)));
            } else {
                this.getLogger().logUnhandledNode(this, (ASTNode)elseStmt, jstNode);
            }
        }
        return ifStmt;
    }

    private SwitchStmt toSwitchStmt(SwitchStatement astStmt, BaseJstNode jstBlock) {
        ExpressionTranslator exprTranslator = this.getExprTranslator();
        SwitchStmt switchStmt = new SwitchStmt();
        jstBlock.addChild((IJstNode)switchStmt);
        Expression astExpr = astStmt.getExpression();
        switchStmt.setExpr(exprTranslator.processExpression(astExpr, jstBlock));
        for (Object s : astStmt.statements()) {
            if (s instanceof Statement) {
                switchStmt.addStmt(this.processStatement((Statement)s, (BaseJstNode)switchStmt.getBody()));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)s, (BaseJstNode)switchStmt);
        }
        return switchStmt;
    }

    private LabeledStmt toLabeledStmt(LabeledStatement astStmt, BaseJstNode jstBlock) {
        SimpleName label = astStmt.getLabel();
        LabeledStmt labeledStmt = new LabeledStmt(new JstIdentifier(label.toString()));
        jstBlock.addChild((IJstNode)labeledStmt);
        labeledStmt.setStmt(this.processStatement(astStmt.getBody(), (BaseJstNode)labeledStmt));
        return labeledStmt;
    }

    private BreakStmt toBreakStmt(BreakStatement astStmt, BaseJstNode jstBlock) {
        SimpleName label = astStmt.getLabel();
        BreakStmt stmt = label == null ? new BreakStmt() : new BreakStmt(new JstIdentifier(label.toString()));
        jstBlock.addChild((IJstNode)stmt);
        return stmt;
    }

    private ContinueStmt toContinueStmt(ContinueStatement astStmt, BaseJstNode jstBlock) {
        SimpleName label = astStmt.getLabel();
        ContinueStmt stmt = label == null ? new ContinueStmt() : new ContinueStmt(new JstIdentifier(label.toString()));
        jstBlock.addChild((IJstNode)stmt);
        return stmt;
    }

    private ThrowStmt toThrowStmt(ThrowStatement astStmt, BaseJstNode jstBlock) {
        IExpr expr = this.getExprTranslator().processExpression(astStmt.getExpression(), jstBlock);
        return new ThrowStmt(expr);
    }

    private TryStmt toTryStmt(TryStatement astStmt, BaseJstNode jstBlock) {
        CatchClause cc;
        TryStmt tryStmt = new TryStmt();
        jstBlock.addChild((IJstNode)tryStmt);
        this.getOtherTranslator().processBlock(astStmt.getBody(), tryStmt.getBody());
        CatchStmt catchStmt = null;
        boolean firstTime = true;
        IfStmt ifStmt = new IfStmt();
        String tmp = "0";
        boolean isSameVarName = true;
        for (Object o : astStmt.catchClauses()) {
            if (!(o instanceof CatchClause)) continue;
            cc = (CatchClause)o;
            if (!tmp.equals("0") && !tmp.equals(cc.getException().getName().toString())) {
                isSameVarName = false;
                break;
            }
            tmp = cc.getException().getName().toString();
        }
        for (Object o : astStmt.catchClauses()) {
            if (o instanceof CatchClause) {
                boolean addCustomVar;
                String typeName;
                IJstType type;
                SingleVariableDeclaration decl;
                cc = (CatchClause)o;
                JstVar jstVar = isSameVarName ? this.getOtherTranslator().toJstVar(cc.getException(), jstBlock.getOwnerType()) : this.getOtherTranslator().toJstVar(cc.getException(), jstBlock.getOwnerType(), CATCH_VAR_NAME);
                if (firstTime) {
                    catchStmt = new CatchStmt(jstVar);
                    tryStmt.addChild((IJstNode)catchStmt);
                    tryStmt.addCatch(catchStmt);
                    if (astStmt.catchClauses().size() > 1) {
                        catchStmt.getBody().addStmt((IStmt)ifStmt);
                    }
                }
                if ((decl = cc.getException()) == null || (type = this.getCtx().getProvider().getDataTypeTranslator().processType(decl.getType(), jstBlock)) == null || catchStmt == null) continue;
                catchStmt.getBody().getVarTable().addVarType(this.getNameTranslator().processVarName(decl.getName(), (BaseJstNode)catchStmt.getBody()), type);
                if (type.getModifiers().isStatic() || jstBlock.getOwnerType().hasImport(type.getSimpleName())) {
                    JstIdentifier jstQualifier = VjoTranslateHelper.getStaticTypeQualifier(type, jstBlock);
                    typeName = jstQualifier.getName();
                    if (type != jstBlock.getOwnerType()) {
                        typeName = String.valueOf(typeName) + "." + type.getSimpleName();
                    }
                } else {
                    typeName = type.getName();
                }
                JstIdentifier rightExpr = new JstIdentifier(typeName);
                rightExpr.setJstBinding((IJstNode)type);
                BoolExpr cond = new BoolExpr((IExpr)new TextExpr(jstVar.getName()), (IExpr)rightExpr, BoolExpr.Operator.INSTANCE_OF);
                AssignExpr assign = null;
                boolean bl = addCustomVar = !isSameVarName && !CATCH_VAR_NAME.equals(decl.getName().toString());
                if (addCustomVar) {
                    JstVar left = new JstVar((IJstType)jstBlock.getOwnerType(), decl.getName().toString());
                    TextExpr right = new TextExpr(CATCH_VAR_NAME);
                    assign = new AssignExpr((ILHS)left, (IExpr)right);
                }
                if (firstTime) {
                    if (astStmt.catchClauses().size() > 1) {
                        if (addCustomVar) {
                            ifStmt.getBody().addStmt(assign);
                        }
                        ifStmt.setCondition((IBoolExpr)cond);
                        this.getOtherTranslator().processBlock(cc.getBody(), ifStmt.getBody());
                    } else {
                        this.getOtherTranslator().processBlock(cc.getBody(), catchStmt.getBody());
                    }
                    firstTime = false;
                    continue;
                }
                IfStmt elseIfStmt = new IfStmt();
                elseIfStmt.setCondition((IBoolExpr)cond);
                ifStmt.addElseStmt(elseIfStmt);
                if (addCustomVar) {
                    elseIfStmt.getBody().addStmt((IStmt)assign);
                }
                this.getOtherTranslator().processBlock(cc.getBody(), elseIfStmt.getBody());
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, jstBlock);
        }
        if (astStmt.getFinally() != null) {
            this.getOtherTranslator().processBlock(astStmt.getFinally(), tryStmt.getFinallyBlock(true));
        }
        return tryStmt;
    }

    private RtnStmt toReturnStmt(ReturnStatement astStmt, BaseJstNode jstBlock) {
        Expression e = astStmt.getExpression();
        RtnStmt rtnStmt = new RtnStmt(this.getExprTranslator().processExpression(e, jstBlock));
        jstBlock.addChild((IJstNode)rtnStmt);
        return rtnStmt;
    }

    private BlockStmt toBlockStmt(Block astBlock, BaseJstNode jstBlock) {
        BlockStmt blockStmt = new BlockStmt();
        jstBlock.addChild((IJstNode)blockStmt);
        this.getCtx().getProvider().getOtherTranslator().processBlock(astBlock, blockStmt.getBody());
        return blockStmt;
    }
}

